/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.codeInsight;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.jetbrains.nodejs.codeInsight.NonFileModulePsiReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSModuleReferenceContributor
implements JSModuleReferenceContributor {
    @NotNull
    public PsiReference[] getCommonJSModuleReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/jetbrains/nodejs/codeInsight/NodeJSModuleReferenceContributor", "getCommonJSModuleReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/jetbrains/nodejs/codeInsight/NodeJSModuleReferenceContributor", "getCommonJSModuleReferences"));
        }
        PsiReference[] psiReferenceArray = NodeJSModuleReferenceContributor.getReferences(unquotedRefText, host, offset, provider);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodeJSModuleReferenceContributor", "getCommonJSModuleReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    public PsiReference[] getAllReferences(@NotNull String unquotedRefText, @NotNull PsiElement host, int offset, @Nullable PsiReferenceProvider provider) {
        if (unquotedRefText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unquotedRefText", "com/jetbrains/nodejs/codeInsight/NodeJSModuleReferenceContributor", "getAllReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/jetbrains/nodejs/codeInsight/NodeJSModuleReferenceContributor", "getAllReferences"));
        }
        PsiReference[] psiReferenceArray = NodeJSModuleReferenceContributor.getReferences(unquotedRefText, host, offset, provider);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodeJSModuleReferenceContributor", "getAllReferences"));
        }
        return psiReferenceArray;
    }

    public boolean isApplicable(@NotNull PsiElement host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/jetbrains/nodejs/codeInsight/NodeJSModuleReferenceContributor", "isApplicable"));
        }
        return !DialectDetector.isTypeScript((PsiElement)host);
    }

    @NotNull
    private static PsiReference[] getReferences(@NotNull String modulePath, @NotNull PsiElement host, int modulePathOffsetInHost, @Nullable PsiReferenceProvider provider) {
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "com/jetbrains/nodejs/codeInsight/NodeJSModuleReferenceContributor", "getReferences"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/jetbrains/nodejs/codeInsight/NodeJSModuleReferenceContributor", "getReferences"));
        }
        Pair path = JSModuleReferenceContributor.getActualPath((String)modulePath);
        String requiredModulePath = (String)path.second;
        if (NodeModuleSearchUtil.isFileModuleRequired((String)requiredModulePath)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodeJSModuleReferenceContributor", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new NonFileModulePsiReference(host, requiredModulePath)};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodeJSModuleReferenceContributor", "getReferences"));
        }
        return psiReferenceArray;
    }
}

