/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.codeInsight;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.library.NodeJsCoreLibraryManager;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.jetbrains.nodejs.codeInsight.EnableNodeJsCodeAssistanceFix;
import com.jetbrains.nodejs.codeInsight.NonFileModulePsiReference;
import org.jetbrains.annotations.NotNull;

public class NodeJsCodingAssistanceForCoreModulesInspection
extends JSInspection {
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        FileType fileType = holder.getFile().getFileType();
        if (TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(fileType)) {
            JSElementVisitor jSElementVisitor = JSElementVisitor.NOP_ELEMENT_VISITOR;
            if (jSElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodeJsCodingAssistanceForCoreModulesInspection", "createVisitor"));
            }
            return jSElementVisitor;
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                for (PsiReference ref : node.getReferences()) {
                    if (!(ref instanceof NonFileModulePsiReference)) continue;
                    NodeJsCodingAssistanceForCoreModulesInspection.handleRef((NonFileModulePsiReference)ref, holder);
                }
            }
        };
        if (jSElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodeJsCodingAssistanceForCoreModulesInspection", "createVisitor"));
        }
        return jSElementVisitor;
    }

    private static void handleRef(@NotNull NonFileModulePsiReference ref, @NotNull ProblemsHolder holder) {
        NodeJsCoreLibraryManager coreLibraryManager;
        ResolvedModuleInfo moduleInfo;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/jetbrains/nodejs/codeInsight/NodeJsCodingAssistanceForCoreModulesInspection", "handleRef"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/nodejs/codeInsight/NodeJsCodingAssistanceForCoreModulesInspection", "handleRef"));
        }
        Project project = holder.getProject();
        boolean coreModule = NodeJsCoreLibraryManager.isCoreModuleName((String)ref.getRequiredModuleName());
        if (coreModule && (moduleInfo = ref.resolveModule()) == null && !(coreLibraryManager = NodeJsCoreLibraryManager.getInstance((Project)project)).isCoreLibraryConfigured()) {
            holder.registerProblemForReference((PsiReference)ref, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, "Node.js coding assistance is disabled", new LocalQuickFix[]{new EnableNodeJsCodeAssistanceFix()});
        }
    }

    @NotNull
    public String getShortName() {
        if ("NodeJsCodingAssistanceForCoreModules" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodeJsCodingAssistanceForCoreModulesInspection", "getShortName"));
        }
        return "NodeJsCodingAssistanceForCoreModules";
    }
}

