/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.codeInsight;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePathManager {
    private static final String NODE_PATH = "NODE_PATH";
    private static final char NODE_PATH_SEPARATOR = (char)(SystemInfo.isWindows ? 59 : 58);
    private final Project myProject;
    private volatile List<VirtualFile> myNodePathDirs;

    public NodePathManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/codeInsight/NodePathManager", "<init>"));
        }
        this.myProject = project;
    }

    public void dropCache() {
        this.myNodePathDirs = null;
    }

    @NotNull
    public List<VirtualFile> getNodePaths() {
        if (this.myNodePathDirs == null) {
            NodeJsRunConfiguration defaultConfiguration = NodeJsRunConfiguration.getDefaultRunConfiguration(this.myProject);
            String nodePathStr = null;
            String workingDirPath = null;
            if (defaultConfiguration != null) {
                nodePathStr = defaultConfiguration.getEnvs().get(NODE_PATH);
                workingDirPath = defaultConfiguration.getWorkingDirectory();
            }
            if (nodePathStr == null) {
                nodePathStr = EnvironmentUtil.getValue((String)NODE_PATH);
            }
            if (StringUtil.isEmptyOrSpaces(workingDirPath)) {
                workingDirPath = this.myProject.getBasePath();
            }
            List<File> nodePathIoFiles = NodePathManager.parsePathsFromNodePathEnvVariable(nodePathStr, workingDirPath);
            this.myNodePathDirs = NodeSettings.toVirtualFiles(nodePathIoFiles);
        }
        List<VirtualFile> list = this.myNodePathDirs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodePathManager", "getNodePaths"));
        }
        return list;
    }

    @NotNull
    public static EnvironmentVariablesData prependPath(@NotNull EnvironmentVariablesData envData, @NotNull String extraNodePath) {
        if (envData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/jetbrains/nodejs/codeInsight/NodePathManager", "prependPath"));
        }
        if (extraNodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraNodePath", "com/jetbrains/nodejs/codeInsight/NodePathManager", "prependPath"));
        }
        String value = (String)envData.getEnvs().get(NODE_PATH);
        if (value == null && envData.isPassParentEnvs()) {
            value = (String)EnvironmentUtil.getEnvironmentMap().get(NODE_PATH);
        }
        value = (value = StringUtil.notNullize((String)value)).isEmpty() || StringUtil.startsWithChar((CharSequence)value, (char)NODE_PATH_SEPARATOR) ? extraNodePath + value : extraNodePath + NODE_PATH_SEPARATOR + value;
        LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>(envData.getEnvs());
        envs.put(NODE_PATH, value);
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.create((Map)ImmutableMap.copyOf(envs), (boolean)envData.isPassParentEnvs());
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodePathManager", "prependPath"));
        }
        return environmentVariablesData;
    }

    @NotNull
    private static List<File> parsePathsFromNodePathEnvVariable(@Nullable String nodePath, @Nullable String workingDirPath) {
        if (nodePath == null || workingDirPath == null) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodePathManager", "parsePathsFromNodePathEnvVariable"));
            }
            return list;
        }
        if (StringUtil.isEmptyOrSpaces((String)nodePath) || StringUtil.isEmptyOrSpaces((String)workingDirPath)) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodePathManager", "parsePathsFromNodePathEnvVariable"));
            }
            return list;
        }
        Iterable res = Splitter.on((char)NODE_PATH_SEPARATOR).split((CharSequence)nodePath);
        File workingDir = new File(workingDirPath);
        if (!workingDir.isAbsolute() || !workingDir.isDirectory()) {
            List<File> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodePathManager", "parsePathsFromNodePathEnvVariable"));
            }
            return list;
        }
        ArrayList dirs = Lists.newArrayList();
        for (String dirPath : res) {
            if (!StringUtil.isNotEmpty((String)dirPath)) continue;
            File dir = new File(dirPath);
            if (!dir.isAbsolute()) {
                dir = new File(workingDirPath, dirPath);
            }
            if (!dir.isDirectory()) continue;
            dirs.add(dir);
        }
        ArrayList arrayList = dirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NodePathManager", "parsePathsFromNodePathEnvVariable"));
        }
        return arrayList;
    }
}

