/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.codeInsight;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.reference.NodeFileModulePsiReferenceBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.nodejs.NodeModuleManager;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonFileModulePsiReference
extends NodeFileModulePsiReferenceBase {
    public NonFileModulePsiReference(@NotNull PsiElement literalExpression, @NotNull String requiredModuleName) {
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/jetbrains/nodejs/codeInsight/NonFileModulePsiReference", "<init>"));
        }
        if (requiredModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requiredModuleName", "com/jetbrains/nodejs/codeInsight/NonFileModulePsiReference", "<init>"));
        }
        super(literalExpression, requiredModuleName);
    }

    @Nullable
    public ResolvedModuleInfo resolveModule() {
        ResolvedModuleInfo deref;
        VirtualFile requester;
        NodeModuleManager nodeModuleManager = NodeModuleManager.getInstance(this.myPsiElement.getProject());
        ResolvedModuleInfo info = nodeModuleManager.resolveModule(this.myRequiredModuleName, requester = this.getContainingFile());
        if (info != null && (deref = this.dereferenceIfOutsideOfProject(info)) != null) {
            info = deref;
        }
        return info;
    }

    @Nullable
    private ResolvedModuleInfo dereferenceIfOutsideOfProject(@NotNull ResolvedModuleInfo info) {
        VirtualFile canonicalModule;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/nodejs/codeInsight/NonFileModulePsiReference", "dereferenceIfOutsideOfProject"));
        }
        VirtualFile root = info.getModuleSourceRoot();
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myPsiElement.getProject());
        if (fileIndex.getModuleForFile(root, false) != null) {
            return null;
        }
        VirtualFile canonicalRoot = root.getCanonicalFile();
        if (canonicalRoot == null || canonicalRoot.equals(root)) {
            return null;
        }
        if (fileIndex.getModuleForFile(canonicalRoot, false) == null) {
            return null;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)info.getModuleMainFile(), (VirtualFile)info.getModuleSourceRoot());
        if (relativePath != null && (canonicalModule = canonicalRoot.findFileByRelativePath(relativePath)) != null) {
            return new ResolvedModuleInfo(canonicalRoot, canonicalModule, info.getType());
        }
        return null;
    }

    @NotNull
    protected CompletionModuleInfo[] getModuleInfos(VirtualFile requester) {
        NodeModuleManager moduleManager = NodeModuleManager.getInstance(this.myPsiElement.getProject());
        Collection<CompletionModuleInfo> variants = moduleManager.collectVisibleNodeModules(requester);
        CompletionModuleInfo[] completionModuleInfoArray = variants.toArray(new CompletionModuleInfo[variants.size()]);
        if (completionModuleInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/codeInsight/NonFileModulePsiReference", "getModuleInfos"));
        }
        return completionModuleInfoArray;
    }
}

