/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.codeInsight.modules;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JsModulesSuggester;
import com.intellij.lang.javascript.modules.ModuleFixCreator;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.NodeJSModulesSearcher;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.util.ArrayUtil;
import com.jetbrains.nodejs.codeInsight.modules.ImportNodeJsModuleFix;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class NodeJsModulesSuggester
implements JsModulesSuggester {
    @NotNull
    private final LocalInspectionToolSession mySession;
    @NotNull
    private final ModuleReferenceInfo myModuleReferenceInfo;
    @NotNull
    private final PsiElement myNode;
    @NotNull
    private final List<Pair<PsiElement, List<LocalQuickFix>>> myResult;

    public NodeJsModulesSuggester(@NotNull LocalInspectionToolSession session, @NotNull ModuleReferenceInfo moduleReferenceInfo, @NotNull PsiElement node) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/nodejs/codeInsight/modules/NodeJsModulesSuggester", "<init>"));
        }
        if (moduleReferenceInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReferenceInfo", "com/jetbrains/nodejs/codeInsight/modules/NodeJsModulesSuggester", "<init>"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/nodejs/codeInsight/modules/NodeJsModulesSuggester", "<init>"));
        }
        this.mySession = session;
        this.myModuleReferenceInfo = moduleReferenceInfo;
        this.myNode = node;
        this.myResult = new ArrayList<Pair<PsiElement, List<LocalQuickFix>>>();
    }

    public boolean isResolvedGlobally(@NotNull ResolveResult result, Set<VirtualFile> predefinedFiles) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/nodejs/codeInsight/modules/NodeJsModulesSuggester", "isResolvedGlobally"));
        }
        return NodeModuleUtil.isResolvedGloballyCommonJS((ResolveResult)result, predefinedFiles, (LocalInspectionToolSession)this.mySession);
    }

    public List<Pair<PsiElement, List<LocalQuickFix>>> getFixes() {
        return this.myResult;
    }

    public void findFixes(ResolveResult[] resolveResults, @NotNull Set<VirtualFile> predefinedFiles) {
        if (predefinedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "predefinedFiles", "com/jetbrains/nodejs/codeInsight/modules/NodeJsModulesSuggester", "findFixes"));
        }
        NodeJSModulesSearcher searcher = new NodeJSModulesSearcher(this.mySession, this.myModuleReferenceInfo, this.myNode, resolveResults, predefinedFiles);
        List descriptors = searcher.find();
        if (descriptors.isEmpty()) {
            return;
        }
        String quoteString = JSCodeStyleSettings.getQuote((PsiElement)this.myNode);
        ArrayList<ImportNodeJsModuleFix> firstWord = new ArrayList<ImportNodeJsModuleFix>();
        for (ModuleFixCreator.FixDescriptor descriptor : descriptors) {
            if (!ModuleFixCreator.ModuleType.nodejs.equals((Object)descriptor.getModuleType())) continue;
            firstWord.add(new ImportNodeJsModuleFix(this.myNode, descriptor, quoteString));
        }
        this.myResult.add((Pair<PsiElement, List<LocalQuickFix>>)Pair.create((Object)this.myNode, firstWord));
        if (this.myModuleReferenceInfo.haveTail()) {
            Project project = this.myNode.getProject();
            List tailRef = this.myModuleReferenceInfo.getTailRef();
            ArrayList<String> tail = new ArrayList<String>();
            for (JSReferenceExpression aTailRef : tailRef) {
                ArrayList<ImportNodeJsModuleFix> list = new ArrayList<ImportNodeJsModuleFix>(firstWord);
                tail.add(aTailRef.getReferenceName());
                for (ModuleFixCreator.FixDescriptor descriptor : descriptors) {
                    if (!ModuleFixCreator.ModuleType.nodejs.equals((Object)descriptor.getModuleType())) continue;
                    descriptor = new ModuleFixCreator.FixDescriptor(descriptor).withTail(SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)aTailRef), ArrayUtil.toStringArray(tail));
                    list.add(new ImportNodeJsModuleFix((PsiElement)aTailRef, descriptor, quoteString));
                }
                this.myResult.add((Pair<PsiElement, List<LocalQuickFix>>)Pair.create((Object)aTailRef, list));
            }
        }
    }

    public boolean isEmpty() {
        return this.myResult.isEmpty();
    }
}

