/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.debug;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configuration.EmptyRunProfileState;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.nodeJs.NodeDebugProgramRunnerKt;
import com.jetbrains.nodeJs.NodeJSDebuggableConfiguration;
import com.jetbrains.nodejs.debug.NodeJsRemoteDebugSettingsEditor;
import java.net.InetSocketAddress;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsRemoteDebugConfiguration
extends RunConfigurationBase
implements RunConfigurationWithSuppressedDefaultRunAction,
NodeJSDebuggableConfiguration {
    private static final String STATE_TAG_NAME = "node-js-remote-debug";
    private NodeJSRemoteDebugState state = new NodeJSRemoteDebugState();

    public NodeJsRemoteDebugConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory, "NodeJS");
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        NodeJsRemoteDebugSettingsEditor nodeJsRemoteDebugSettingsEditor = new NodeJsRemoteDebugSettingsEditor();
        if (nodeJsRemoteDebugSettingsEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/debug/NodeJsRemoteDebugConfiguration", "getConfigurationEditor"));
        }
        return nodeJsRemoteDebugSettingsEditor;
    }

    public String getHost() {
        return this.state.host;
    }

    public int getPort() {
        return this.state.port;
    }

    @NotNull
    public InetSocketAddress computeDebugAddress(RunProfileState state) {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.getHost(), this.getPort());
        if (inetSocketAddress == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/debug/NodeJsRemoteDebugConfiguration", "computeDebugAddress"));
        }
        return inetSocketAddress;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (socketAddress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "socketAddress", "com/jetbrains/nodejs/debug/NodeJsRemoteDebugConfiguration", "createDebugProcess"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/nodejs/debug/NodeJsRemoteDebugConfiguration", "createDebugProcess"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/debug/NodeJsRemoteDebugConfiguration", "createDebugProcess"));
        }
        XDebugProcess xDebugProcess = NodeDebugProgramRunnerKt.createDebugProcess((NodeJSDebuggableConfiguration)this, (InetSocketAddress)socketAddress, (XDebugSession)session, (ExecutionResult)executionResult, (boolean)false);
        if (xDebugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/debug/NodeJsRemoteDebugConfiguration", "createDebugProcess"));
        }
        return xDebugProcess;
    }

    public RunConfiguration clone() {
        NodeJsRemoteDebugConfiguration clone = (NodeJsRemoteDebugConfiguration)super.clone();
        clone.state = new NodeJSRemoteDebugState();
        XmlSerializerUtil.copyBean((Object)this.state, (Object)clone.state);
        return clone;
    }

    public void setPort(int port) {
        this.state.port = port;
    }

    public void setHost(String host) {
        this.state.host = host;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/nodejs/debug/NodeJsRemoteDebugConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/nodejs/debug/NodeJsRemoteDebugConfiguration", "getState"));
        }
        return EmptyRunProfileState.INSTANCE;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.state = new NodeJSRemoteDebugState();
        Element stateElement = element.getChild(STATE_TAG_NAME);
        if (stateElement != null) {
            XmlSerializer.deserializeInto((Object)this.state, (Element)stateElement);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        element.addContent(XmlSerializer.serialize((Object)this.state, (SerializationFilter)new SkipDefaultValuesSerializationFilters()));
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
    }

    @Tag(value="node-js-remote-debug")
    public static class NodeJSRemoteDebugState {
        @Attribute
        public String host = "127.0.0.1";
        @Attribute(value="debug-port")
        public int port = 5858;
    }
}

