/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.doc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.doc.ModuleDoc;
import com.jetbrains.nodejs.doc.ModuleMethodDoc;
import com.jetbrains.nodejs.doc.ModuleMethodParamDoc;
import com.jetbrains.nodejs.doc.ModulePropertyDoc;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDocParser {
    private static final Logger LOG = Logger.getInstance(ModuleDoc.class);
    private static final String TEXT_RAW = "textRaw";
    private static final String NAME = "name";
    private static final String STABILITY = "stability";
    private static final String STABILITY_TEXT = "stabilityText";
    private static final String DESCRIPTION = "desc";
    private static final String SIGNATURES = "signatures";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ModuleDoc parseFrom(@NotNull File jsonFile) {
        ModuleDoc moduleDoc;
        if (jsonFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonFile", "com/jetbrains/nodejs/doc/ModuleDocParser", "parseFrom"));
        }
        if (!jsonFile.isFile()) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(jsonFile), 32768), StandardCharsets.UTF_8);
        try {
            JsonParser parser = new JsonParser();
            JsonElement topElement = parser.parse((Reader)reader);
            moduleDoc = ModuleDocParser.convert(topElement);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    LOG.warn("Can't close", (Throwable)e);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.warn("Can't parse " + jsonFile.getAbsolutePath(), (Throwable)e);
                return null;
            }
        }
        try {
            ((Reader)reader).close();
        }
        catch (IOException e) {
            LOG.warn("Can't close", (Throwable)e);
        }
        return moduleDoc;
    }

    @Nullable
    private static ModuleDoc convert(@NotNull JsonElement topElement) throws IOException {
        if (topElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topElement", "com/jetbrains/nodejs/doc/ModuleDocParser", "convert"));
        }
        JsonObject topObject = topElement.getAsJsonObject();
        JsonArray array = topObject.getAsJsonArray("modules");
        Iterator iterator = array.iterator();
        if (iterator.hasNext()) {
            JsonElement element = (JsonElement)iterator.next();
            return ModuleDocParser.covertModuleObject(element.getAsJsonObject());
        }
        return null;
    }

    @Nullable
    private static ModuleDoc covertModuleObject(@NotNull JsonObject moduleObject) {
        if (moduleObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleObject", "com/jetbrains/nodejs/doc/ModuleDocParser", "covertModuleObject"));
        }
        String textRaw = ModuleDocParser.getStringProperty(moduleObject, TEXT_RAW);
        String name = ModuleDocParser.getStringProperty(moduleObject, NAME);
        Integer stability = ModuleDocParser.getIntegerProperty(moduleObject, STABILITY);
        String stabilityText = ModuleDocParser.getStringProperty(moduleObject, STABILITY_TEXT);
        String description = ModuleDocParser.getStringProperty(moduleObject, DESCRIPTION);
        List<ModulePropertyDoc> properties = ModuleDocParser.parseProperties(moduleObject);
        List<ModuleMethodDoc> methods = ModuleDocParser.parseMethods(moduleObject);
        return new ModuleDoc(name, textRaw, stability, stabilityText, description, properties, methods);
    }

    @NotNull
    private static List<ModulePropertyDoc> parseProperties(@NotNull JsonObject moduleObject) {
        if (moduleObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleObject", "com/jetbrains/nodejs/doc/ModuleDocParser", "parseProperties"));
        }
        JsonElement propertiesElement = moduleObject.get("properties");
        if (propertiesElement == null) {
            List<ModulePropertyDoc> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/doc/ModuleDocParser", "parseProperties"));
            }
            return list;
        }
        JsonArray propertiesArray = propertiesElement.getAsJsonArray();
        ArrayList properties = ContainerUtil.newArrayList();
        for (JsonElement propertyElement : propertiesArray) {
            ModulePropertyDoc property = ModuleDocParser.parseProperty(propertyElement.getAsJsonObject());
            if (property == null) continue;
            properties.add(property);
        }
        ArrayList arrayList = properties;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/doc/ModuleDocParser", "parseProperties"));
        }
        return arrayList;
    }

    @Nullable
    private static ModulePropertyDoc parseProperty(@NotNull JsonObject propertyObject) {
        if (propertyObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyObject", "com/jetbrains/nodejs/doc/ModuleDocParser", "parseProperty"));
        }
        String textRaw = ModuleDocParser.getStringProperty(propertyObject, TEXT_RAW);
        String name = ModuleDocParser.getStringProperty(propertyObject, NAME);
        String description = ModuleDocParser.getStringProperty(propertyObject, DESCRIPTION);
        if (name == null) {
            return null;
        }
        return new ModulePropertyDoc(name, textRaw, description);
    }

    @NotNull
    private static List<ModuleMethodDoc> parseMethods(@NotNull JsonObject moduleObject) {
        if (moduleObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleObject", "com/jetbrains/nodejs/doc/ModuleDocParser", "parseMethods"));
        }
        JsonElement methodsElement = moduleObject.get("methods");
        if (methodsElement == null) {
            List<ModuleMethodDoc> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/doc/ModuleDocParser", "parseMethods"));
            }
            return list;
        }
        JsonArray methodsArray = methodsElement.getAsJsonArray();
        ArrayList methods = ContainerUtil.newArrayListWithCapacity((int)methodsArray.size());
        for (JsonElement methodElement : methodsArray) {
            ModuleMethodDoc method = ModuleDocParser.parseMethod(methodElement.getAsJsonObject());
            if (method == null) continue;
            methods.add(method);
        }
        ArrayList arrayList = methods;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/doc/ModuleDocParser", "parseMethods"));
        }
        return arrayList;
    }

    @Nullable
    private static ModuleMethodDoc parseMethod(@NotNull JsonObject methodObject) {
        if (methodObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodObject", "com/jetbrains/nodejs/doc/ModuleDocParser", "parseMethod"));
        }
        String textRaw = ModuleDocParser.getStringProperty(methodObject, TEXT_RAW);
        String name = ModuleDocParser.getStringProperty(methodObject, NAME);
        String description = ModuleDocParser.getStringProperty(methodObject, DESCRIPTION);
        List<ModuleMethodParamDoc> params = Collections.emptyList();
        JsonElement signaturesElement = methodObject.get(SIGNATURES);
        if (signaturesElement != null) {
            JsonArray signaturesArray = signaturesElement.getAsJsonArray();
            if (signaturesArray.size() > 1) {
                LOG.warn("Multiple signatures discovered");
            }
            if (signaturesArray.size() > 0) {
                JsonElement signatureElement = (JsonElement)signaturesArray.iterator().next();
                JsonObject signatureObject = signatureElement.getAsJsonObject();
                params = ModuleDocParser.parseSignature(signatureObject);
            }
        }
        if (name != null) {
            return new ModuleMethodDoc(name, textRaw, description, params);
        }
        return null;
    }

    @NotNull
    private static List<ModuleMethodParamDoc> parseSignature(@NotNull JsonObject signatureObject) {
        if (signatureObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureObject", "com/jetbrains/nodejs/doc/ModuleDocParser", "parseSignature"));
        }
        JsonArray paramsArray = signatureObject.getAsJsonArray("params");
        ArrayList params = ContainerUtil.newArrayListWithCapacity((int)paramsArray.size());
        for (JsonElement paramElement : paramsArray) {
            JsonObject paramObject = paramElement.getAsJsonObject();
            String name = ModuleDocParser.getStringProperty(paramObject, NAME);
            boolean optional = ModuleDocParser.getBooleanProperty(paramObject, "optional", false);
            if (name != null) {
                params.add(new ModuleMethodParamDoc(name, optional));
                continue;
            }
            LOG.warn("method.signature.param.name is null");
        }
        ArrayList arrayList = params;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/doc/ModuleDocParser", "parseSignature"));
        }
        return arrayList;
    }

    @Nullable
    private static String getStringProperty(@NotNull JsonObject obj, @NotNull String key) {
        JsonPrimitive p;
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/jetbrains/nodejs/doc/ModuleDocParser", "getStringProperty"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/nodejs/doc/ModuleDocParser", "getStringProperty"));
        }
        JsonElement stringElement = obj.get(key);
        if (stringElement != null && stringElement.isJsonPrimitive() && (p = stringElement.getAsJsonPrimitive()).isString()) {
            return p.getAsString();
        }
        return null;
    }

    @Nullable
    private static Integer getIntegerProperty(@NotNull JsonObject obj, @NotNull String key) {
        JsonPrimitive p;
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/jetbrains/nodejs/doc/ModuleDocParser", "getIntegerProperty"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/nodejs/doc/ModuleDocParser", "getIntegerProperty"));
        }
        JsonElement integerElement = obj.get(key);
        if (integerElement != null && integerElement.isJsonPrimitive() && (p = integerElement.getAsJsonPrimitive()).isNumber()) {
            Number n = p.getAsNumber();
            return n.intValue();
        }
        return null;
    }

    private static boolean getBooleanProperty(@NotNull JsonObject obj, @NotNull String key, boolean defaultValue) {
        JsonPrimitive p;
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/jetbrains/nodejs/doc/ModuleDocParser", "getBooleanProperty"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/nodejs/doc/ModuleDocParser", "getBooleanProperty"));
        }
        JsonElement boolElement = obj.get(key);
        if (boolElement != null && boolElement.isJsonPrimitive() && (p = boolElement.getAsJsonPrimitive()).isBoolean()) {
            return p.getAsBoolean();
        }
        return defaultValue;
    }

    public static void main(String[] args) {
        File file = new File("/home/segrey/work/idea-master/system/webstorm/extLibs/nodejs-v0.11.4-src/core-modules-sources/doc/api/http.json");
        ModuleDoc documentation = ModuleDocParser.parseFrom(file);
        System.out.println(documentation);
    }
}

