/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.doc;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.doc.NodeDoc;
import com.jetbrains.nodejs.doc.NodeDocSplitter;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Semaphore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeDocManager {
    public static final Logger LOG = Logger.getInstance(NodeDocManager.class);
    private static final NodeDocManager INSTANCE = new NodeDocManager();

    @NotNull
    public NodeDoc getDoc(@NotNull Project project, @NotNull SemVer nodeVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/doc/NodeDocManager", "getDoc"));
        }
        if (nodeVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeVersion", "com/jetbrains/nodejs/doc/NodeDocManager", "getDoc"));
        }
        File docDir = NodeDocManager.getDocDir(nodeVersion);
        this.downloadIfNeeded(project, nodeVersion, docDir);
        NodeDoc nodeDoc = new NodeDoc(nodeVersion, docDir);
        if (nodeDoc == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/doc/NodeDocManager", "getDoc"));
        }
        return nodeDoc;
    }

    @NotNull
    private static File getDocDir(@NotNull SemVer nodeVersion) {
        if (nodeVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeVersion", "com/jetbrains/nodejs/doc/NodeDocManager", "getDocDir"));
        }
        File rootDir = new File(new File(PathManager.getSystemPath(), "extLibs"), "nodejs" + File.separator + "documentation");
        File file = new File(rootDir, nodeVersion.getParsedVersion());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/doc/NodeDocManager", "getDocDir"));
        }
        return file;
    }

    public void downloadIfNeeded(@NotNull Project project, @NotNull SemVer nodeVersion, @NotNull File docDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadIfNeeded"));
        }
        if (nodeVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeVersion", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadIfNeeded"));
        }
        if (docDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docDir", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadIfNeeded"));
        }
        File allDocJson = new File(docDir, "all.json");
        if (!allDocJson.isFile()) {
            NodeDocManager.downloadWithProgressSync(project, nodeVersion, docDir, allDocJson);
        }
    }

    private static void downloadWithProgressSync(@NotNull Project project, @NotNull SemVer nodeVersion, @NotNull File docDir, File allDocJson) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadWithProgressSync"));
        }
        if (nodeVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeVersion", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadWithProgressSync"));
        }
        if (docDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docDir", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadWithProgressSync"));
        }
        Semaphore semaphore = new Semaphore(0, true);
        NodeDocManager.downloadWithProgressAsync(project, nodeVersion, docDir, allDocJson, semaphore);
        try {
            semaphore.acquire();
        }
        catch (InterruptedException ignored) {
            Thread.interrupted();
        }
    }

    private static void downloadWithProgressAsync(@NotNull Project project, final @NotNull SemVer nodeVersion, final @NotNull File docDir, final @NotNull File allDocJson, final @Nullable Semaphore semaphore) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadWithProgressAsync"));
        }
        if (nodeVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeVersion", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadWithProgressAsync"));
        }
        if (docDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docDir", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadWithProgressAsync"));
        }
        if (allDocJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDocJson", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadWithProgressAsync"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/doc/NodeDocManager", "lambda$downloadWithProgressAsync$0"));
            }
            if (nodeVersion == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeVersion", "com/jetbrains/nodejs/doc/NodeDocManager", "lambda$downloadWithProgressAsync$0"));
            }
            if (docDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docDir", "com/jetbrains/nodejs/doc/NodeDocManager", "lambda$downloadWithProgressAsync$0"));
            }
            if (allDocJson == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDocJson", "com/jetbrains/nodejs/doc/NodeDocManager", "lambda$downloadWithProgressAsync$0"));
            }
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Node.js Documentation", false, null){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/doc/NodeDocManager$1", "run"));
                    }
                    try {
                        NodeDocManager.downloadAllDocJson(nodeVersion, docDir, allDocJson);
                        new NodeDocSplitter(allDocJson, docDir).split();
                    }
                    catch (IOException e) {
                        LOG.warn("Cannot download Node.js " + nodeVersion.getParsedVersion() + " documentation", (Throwable)e);
                    }
                    finally {
                        if (semaphore != null) {
                            semaphore.release();
                        }
                    }
                }
            });
        });
    }

    private static void downloadAllDocJson(@NotNull SemVer nodeVersion, @NotNull File docDir, @NotNull File allDocJson) throws IOException {
        if (nodeVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeVersion", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadAllDocJson"));
        }
        if (docDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docDir", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadAllDocJson"));
        }
        if (allDocJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDocJson", "com/jetbrains/nodejs/doc/NodeDocManager", "downloadAllDocJson"));
        }
        long startTime = System.nanoTime();
        FileUtil.delete((File)docDir);
        if (!FileUtil.createDirectory((File)docDir)) {
            throw new IOException("Cannot create directory for Node.js documentation " + docDir.getAbsolutePath());
        }
        String parsedVersion = nodeVersion.getParsedVersion();
        String url = "http://nodejs.org/dist/v" + parsedVersion + "/docs/api/all.json";
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        progress.setText("Getting Node.js " + parsedVersion + " documentation" + "${content-length}" + " ...");
        DownloadUtil.downloadAtomically((ProgressIndicator)progress, (String)url, (File)allDocJson);
        long duration = System.nanoTime() - startTime;
        LOG.info(String.format("Node.js %s documentation %s downloaded in %.2f ms", parsedVersion, url, (double)duration / 1000000.0));
    }

    public static NodeDocManager getInstance() {
        return INSTANCE;
    }
}

