/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.doc;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeDocSplitter {
    private static final Logger LOG = Logger.getInstance(NodeDocSplitter.class);
    private final File myAllDocJson;
    private final File myDocDir;

    public NodeDocSplitter(@NotNull File allDocJson, @NotNull File docDir) throws IOException {
        if (allDocJson == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allDocJson", "com/jetbrains/nodejs/doc/NodeDocSplitter", "<init>"));
        }
        if (docDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "docDir", "com/jetbrains/nodejs/doc/NodeDocSplitter", "<init>"));
        }
        this.myAllDocJson = allDocJson;
        this.myDocDir = docDir;
    }

    public void split() throws IOException {
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(this.myAllDocJson), 524288), StandardCharsets.UTF_8));){
            jsonReader.setLenient(false);
            this.doSplit(jsonReader);
        }
    }

    private void doSplit(@NotNull JsonReader jsonReader) throws IOException {
        if (jsonReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonReader", "com/jetbrains/nodejs/doc/NodeDocSplitter", "doSplit"));
        }
        JsonToken peekToken = jsonReader.peek();
        if (peekToken != JsonToken.BEGIN_OBJECT) {
            LOG.warn("[Malformed structure] top level element is expected to be an object. File: " + this.myAllDocJson.getAbsolutePath());
            return;
        }
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String name = jsonReader.nextName();
            if ("modules".equals(name)) {
                this.extractModules(jsonReader);
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractModules(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/doc/NodeDocSplitter", "extractModules"));
        }
        File tmpDir = FileUtil.createTempDirectory((File)this.myDocDir, (String)"tmp-modules", null, (boolean)false);
        if (reader.peek() != JsonToken.BEGIN_ARRAY) {
            LOG.warn("[Malformed structure] 'modules' is expected to be an array. File: " + this.myAllDocJson.getAbsolutePath());
            return;
        }
        reader.beginArray();
        int moduleId = 1;
        while (reader.hasNext()) {
            File tmpFile = new File(tmpDir, moduleId++ + ".json");
            JsonWriter jsonWriter = new JsonWriter((Writer)new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(tmpFile, false), 32768)));
            jsonWriter.setIndent("  ");
            jsonWriter.setLenient(false);
            try {
                NodeDocSplitter.copyCurrentElement(reader, jsonWriter);
            }
            finally {
                jsonWriter.close();
            }
            String moduleName = NodeDocSplitter.extractModuleName(tmpFile);
            if (moduleName == null) {
                LOG.warn("Cannot extract module name");
                continue;
            }
            File destFile = new File(this.myDocDir, moduleName + ".json");
            if (destFile.exists()) {
                LOG.warn("File already exists " + destFile.getAbsolutePath());
                continue;
            }
            FileUtil.rename((File)tmpFile, (File)destFile);
        }
        reader.endArray();
    }

    @Nullable
    private static String extractModuleName(@NotNull File moduleFile) throws IOException {
        if (moduleFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleFile", "com/jetbrains/nodejs/doc/NodeDocSplitter", "extractModuleName"));
        }
        try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(moduleFile), 131072), StandardCharsets.UTF_8));){
            jsonReader.setLenient(false);
            String string = NodeDocSplitter.doExtractModuleName(jsonReader);
            return string;
        }
    }

    @Nullable
    private static String doExtractModuleName(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/doc/NodeDocSplitter", "doExtractModuleName"));
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            LOG.warn("[Malformed structure] module is expected to be an object.");
            return null;
        }
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("name".equals(name)) {
                return reader.nextString();
            }
            reader.skipValue();
        }
        reader.endObject();
        return null;
    }

    private static void copyCurrentElement(@NotNull JsonReader reader, @NotNull JsonWriter writer) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/doc/NodeDocSplitter", "copyCurrentElement"));
        }
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "com/jetbrains/nodejs/doc/NodeDocSplitter", "copyCurrentElement"));
        }
        Stack<JsonToken> stack = new Stack<JsonToken>();
        do {
            String str;
            JsonToken token;
            JsonToken peekToken;
            if ((peekToken = reader.peek()) == JsonToken.BEGIN_OBJECT) {
                stack.push(peekToken);
                reader.beginObject();
                writer.beginObject();
                continue;
            }
            if (peekToken == JsonToken.END_OBJECT) {
                token = (JsonToken)stack.pop();
                if (token != JsonToken.BEGIN_OBJECT) {
                    throw new IOException(JsonToken.BEGIN_OBJECT + " was expected, but " + token + " was found");
                }
                reader.endObject();
                writer.endObject();
                continue;
            }
            if (peekToken == JsonToken.BEGIN_ARRAY) {
                stack.push(peekToken);
                reader.beginArray();
                writer.beginArray();
                continue;
            }
            if (peekToken == JsonToken.END_ARRAY) {
                token = (JsonToken)stack.pop();
                if (token != JsonToken.BEGIN_ARRAY) {
                    throw new IOException(JsonToken.BEGIN_ARRAY + " was expected, but " + token + " was found");
                }
                reader.endArray();
                writer.endArray();
                continue;
            }
            if (peekToken == JsonToken.BOOLEAN) {
                writer.value(reader.nextBoolean());
                continue;
            }
            if (peekToken == JsonToken.NULL) {
                reader.nextNull();
                writer.nullValue();
                continue;
            }
            if (peekToken == JsonToken.NUMBER) {
                str = reader.nextString();
                try {
                    long n = Long.parseLong(str);
                    writer.value(n);
                }
                catch (NumberFormatException ignoredLong) {
                    try {
                        double d = Double.parseDouble(str);
                        writer.value(d);
                    }
                    catch (NumberFormatException ignored) {
                        writer.value(str);
                    }
                }
                continue;
            }
            if (peekToken == JsonToken.NAME) {
                String name = reader.nextName();
                writer.name(name);
                continue;
            }
            if (peekToken == JsonToken.STRING) {
                str = reader.nextString();
                writer.value(str);
                continue;
            }
            if (peekToken != JsonToken.END_DOCUMENT) continue;
            throw new IOException("Unexpected end of document");
        } while (!stack.isEmpty());
    }

    private static class TmpData {
        private TmpData() {
        }
    }
}

