/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.doc;

import com.intellij.javascript.JavaScriptReferenceContributor;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.codeInsight.NonFileModulePsiReference;
import com.jetbrains.nodejs.doc.NodeDocManager;
import com.jetbrains.nodejs.library.NodeJsCoreLibraryConfigurator;
import com.jetbrains.nodejs.packageJson.NodeJsPackageDocUtil;
import com.jetbrains.nodejs.packageJson.NodeJsPackageDocumentation;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeDocumentationProvider
implements DocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String result = null;
        if (element != null) {
            result = NodeDocumentationProvider.doGenerateDoc(element);
        }
        if (result == null && originalElement != null) {
            result = NodeDocumentationProvider.doGenerateDoc(originalElement);
        }
        return result;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    @Nullable
    private static String doGenerateDoc(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/doc/NodeDocumentationProvider", "doGenerateDoc"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSLiteralExpression) {
            element = parent;
        }
        if (JavaScriptReferenceContributor.REQUIRE_ARG_PLACE.accepts((Object)element)) {
            return NodeDocumentationProvider.doGenerateModuleDoc((JSLiteralExpression)element);
        }
        return null;
    }

    @Nullable
    private static String doGenerateModuleDoc(@NotNull JSLiteralExpression literalExpression) {
        PsiReference[] refs;
        if (literalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "literalExpression", "com/jetbrains/nodejs/doc/NodeDocumentationProvider", "doGenerateModuleDoc"));
        }
        for (PsiReference ref : refs = literalExpression.getReferences()) {
            NonFileModulePsiReference requireRef;
            ResolvedModuleInfo info;
            if (!(ref instanceof NonFileModulePsiReference) || (info = (requireRef = (NonFileModulePsiReference)ref).resolveModule()) == null) continue;
            ModuleType type = info.getType();
            if (type == ModuleType.CORE_MODULE) {
                return NodeDocumentationProvider.getCoreModuleDocumentation(literalExpression.getProject(), info.getName());
            }
            return NodeDocumentationProvider.getDocumentationFromReadmeMd(info.getModuleSourceRoot());
        }
        return null;
    }

    @Nullable
    private static String getCoreModuleDocumentation(@NotNull Project project, @NotNull String coreModuleName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/doc/NodeDocumentationProvider", "getCoreModuleDocumentation"));
        }
        if (coreModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coreModuleName", "com/jetbrains/nodejs/doc/NodeDocumentationProvider", "getCoreModuleDocumentation"));
        }
        NodeJsCoreLibraryConfigurator configurator = NodeJsCoreLibraryConfigurator.getInstance(project);
        SemVer nodeVersion = configurator.getConfiguredCoreLibraryVersion();
        if (nodeVersion != null) {
            NodeDocManager.getInstance().getDoc(project, nodeVersion);
        }
        return null;
    }

    @Nullable
    private static String getDocumentationFromReadmeMd(@NotNull VirtualFile sourceRoot) {
        if (sourceRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceRoot", "com/jetbrains/nodejs/doc/NodeDocumentationProvider", "getDocumentationFromReadmeMd"));
        }
        NodeJsPackageDocumentation documentation = NodeJsPackageDocUtil.createByPackageDir(sourceRoot, true);
        if (documentation != null) {
            return documentation.getFullDocHtml();
        }
        return null;
    }
}

