/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.NodeLocalVersionsManager;
import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.util.PathMappingSettings;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeRemoteContext {
    private final String myRemoteInterpreterPath;
    @NotNull
    private final String myInterpreterId;
    private final NodeJSRemoteInterpreterManager myManager;
    private final RemoteSdkAdditionalData myRemoteSdkAdditionalData;
    private final PathMappingSettings myMappings;
    private final String myRemoteWorkingDirectory;

    private NodeRemoteContext(@NotNull Project project, @NotNull String interpreterId, @Nullable String localWorkingDirectory, NodeJSRemoteInterpreterManager manager) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/execution/NodeRemoteContext", "<init>"));
        }
        if (interpreterId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterId", "com/jetbrains/nodejs/execution/NodeRemoteContext", "<init>"));
        }
        this.myInterpreterId = interpreterId;
        this.myManager = manager;
        this.myRemoteSdkAdditionalData = this.myManager.getRemoteSdkAdditionalData(project, interpreterId);
        this.myMappings = this.myManager.setupMappings(project, this.myRemoteSdkAdditionalData);
        this.myRemoteInterpreterPath = this.myRemoteSdkAdditionalData.getInterpreterPath();
        if (localWorkingDirectory != null) {
            String localWorking;
            String path = StringUtil.notNullize((String)localWorkingDirectory);
            String string = localWorking = !FileUtil.isAbsolute((String)path) ? new File(project.getBasePath(), path).getAbsolutePath() : path;
            if (!this.myMappings.canReplaceLocal(localWorking)) {
                throw new ExecutionException("Can not map working directory to remote folder");
            }
            this.myRemoteWorkingDirectory = this.myMappings.convertToRemote(localWorking);
        } else {
            this.myRemoteWorkingDirectory = this.myRemoteSdkAdditionalData.getHelpersPath();
        }
    }

    @Nullable
    public static NodeRemoteContext createContext(@NotNull Project project, @NotNull String interpreterId, @Nullable String localWorkingDirectory, @NotNull NoPluginReaction reaction) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/execution/NodeRemoteContext", "createContext"));
        }
        if (interpreterId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterId", "com/jetbrains/nodejs/execution/NodeRemoteContext", "createContext"));
        }
        if (reaction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reaction", "com/jetbrains/nodejs/execution/NodeRemoteContext", "createContext"));
        }
        if (!NodeLocalVersionsManager.isRemote((String)interpreterId)) {
            return null;
        }
        NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
        if (manager == null) {
            if (NoPluginReaction.message.equals((Object)reaction)) {
                NodeUIUtil.balloonInfo((Project)project, (String)NodeJSRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage(), null, (MessageType)MessageType.ERROR);
            }
            if (NoPluginReaction.exception.equals((Object)reaction)) {
                throw new ExecutionException(NodeJSRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage());
            }
            return null;
        }
        return new NodeRemoteContext(project, interpreterId, localWorkingDirectory, manager);
    }

    public NodeJSRemoteInterpreterManager getManager() {
        return this.myManager;
    }

    public RemoteSdkAdditionalData getRemoteSdkAdditionalData() {
        return this.myRemoteSdkAdditionalData;
    }

    public String getRemoteWorkingDirectory() {
        return this.myRemoteWorkingDirectory;
    }

    public String getRemoteInterpreterPath() {
        return this.myRemoteInterpreterPath;
    }

    @NotNull
    public String getInterpreterId() {
        String string = this.myInterpreterId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/execution/NodeRemoteContext", "getInterpreterId"));
        }
        return string;
    }

    public String getMappingFor(@NotNull String localPath) throws ExecutionException {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/jetbrains/nodejs/execution/NodeRemoteContext", "getMappingFor"));
        }
        if (!this.myMappings.canReplaceLocal(localPath)) {
            throw new ExecutionException("Can not find mapping for " + localPath);
        }
        return this.myMappings.convertToRemote(localPath);
    }

    public static enum NoPluginReaction {
        exception,
        message,
        ignore;

    }
}

