/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.library;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.library.NodeJsCoreModulesCatalog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import com.jetbrains.nodejs.execution.NodeRemoteContext;
import com.jetbrains.nodejs.library.NodeJsCoreLibraryConfigurator;
import com.jetbrains.nodejs.util.NodeJsCodeLocator;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.v8.StandaloneHeadlessV8VmKt;
import org.jetbrains.v8.V8Vm;

public class NodeJsCoreSourcesFetchSession {
    private static final Logger LOG = NodeJsCoreLibraryConfigurator.LOG;
    private static final String CONTENT_SUFFIX = "});";
    private final Project myProject;
    private final NodeJsInterpreter myInterpreter;
    private final File myOutputDir;
    private final NodeRemoteContext myRemoteContext;
    private File myWorkingDirectory;
    private String myRemoteFile;

    public NodeJsCoreSourcesFetchSession(@NotNull Project project, @NotNull NodeJsInterpreter interpreter, @NotNull File outputDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "<init>"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "<init>"));
        }
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputDir", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "<init>"));
        }
        this.myProject = project;
        this.myInterpreter = interpreter;
        this.myOutputDir = outputDir;
        this.myRemoteContext = NodeJsCoreSourcesFetchSession.createRemoteContext(project, interpreter);
    }

    @Nullable
    private static NodeRemoteContext createRemoteContext(@NotNull Project project, @NotNull NodeJsInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "createRemoteContext"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "createRemoteContext"));
        }
        NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)interpreter);
        if (remoteInterpreter == null) {
            return null;
        }
        try {
            return NodeRemoteContext.createContext(project, remoteInterpreter.getRemoteUrl(), null, NodeRemoteContext.NoPluginReaction.message);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public void fetchSourcesSync() throws IOException, ExecutionException {
        KillableColoredProcessHandler processHandler;
        long startNanoTime = System.nanoTime();
        int debugPort = NetUtils.findAvailableSocketPort();
        GeneralCommandLine commandLine = this.createCommandLine(debugPort);
        LOG.info("Running " + commandLine.getCommandLineString());
        NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)this.myInterpreter);
        if (remoteInterpreter != null) {
            NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
            if (manager == null) {
                throw new ExecutionException(NodeJSRemoteInterpreterManager.noRemoteNodeInterpreterPluginMessage());
            }
            try {
                processHandler = manager.createProcessHandler(this.myProject, commandLine, remoteInterpreter.getRemoteUrl(), debugPort, -1);
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
        } else {
            processHandler = new KillableColoredProcessHandler(commandLine);
        }
        MyProcessListener listener = new MyProcessListener();
        processHandler.addProcessListener((ProcessListener)listener);
        processHandler.startNotify();
        listener.awaitReady();
        this.attachDebuggerSync(debugPort);
        NodeJsCoreSourcesFetchSession.terminateSync((OSProcessHandler)processHandler);
        if (this.myRemoteContext != null) {
            this.myRemoteContext.getManager().getFileTransfer(this.myProject, this.myRemoteContext.getRemoteSdkAdditionalData()).deleteRemote(this.myRemoteFile);
        } else {
            FileUtil.delete((File)this.myWorkingDirectory);
        }
        LOG.info("Done in " + TimeoutUtil.getDurationMillis((long)startNanoTime) + " ms, located in " + this.myOutputDir.getAbsolutePath());
    }

    private static void terminateSync(@NotNull OSProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "terminateSync"));
        }
        ScriptRunnerUtil.terminateProcessHandler((ProcessHandler)processHandler, (long)2000L, null);
    }

    private void attachDebuggerSync(int debugPort) throws IOException, ExecutionException {
        InetSocketAddress address = new InetSocketAddress(InetAddress.getLoopbackAddress(), debugPort);
        Promise vmPromise = StandaloneHeadlessV8VmKt.createStandaloneHeadlessV8Vm((InetSocketAddress)address);
        final CountDownLatch latch = new CountDownLatch(1);
        Ref errorRef = Ref.create();
        Consumer errorConsumer = error -> {
            errorRef.set((Object)(error != null ? error : new Throwable("undefined error")));
            latch.countDown();
        };
        final ArrayList scripts = ContainerUtil.newArrayList();
        vmPromise.rejected(errorConsumer).processed(vm -> {
            if (vm == null) {
                LOG.info("Cannot connect to V8 VM, see detailed error message");
                return;
            }
            LOG.info("Connected to V8 VM " + vm.getVmVersion());
            StandaloneHeadlessV8VmKt.listScripts((V8Vm)vm).rejected(errorConsumer).processed((Consumer)new Consumer<List<? extends Pair<String, String>>>(){

                public void consume(List<? extends Pair<String, String>> result) {
                    if (result != null) {
                        LOG.info("listed " + result.size() + " scripts");
                        scripts.addAll(result);
                        latch.countDown();
                    } else {
                        LOG.info("Cannot list scripts, see detailed error message");
                    }
                }
            });
        });
        try {
            boolean success = latch.await(120L, TimeUnit.SECONDS);
            if (!success) {
                throw new ExecutionException("Failed to fetch node core modules: timed out");
            }
        }
        catch (InterruptedException e) {
            throw new ExecutionException("Failed to fetch node core modules: interrupted");
        }
        Throwable error2 = (Throwable)errorRef.get();
        if (error2 != null) {
            throw new ExecutionException("Failed to fetch node core modules", error2);
        }
        for (Pair script : scripts) {
            String filename = (String)script.getFirst();
            if (!NodeJsCoreSourcesFetchSession.shouldSaveScript(filename)) continue;
            File outFile = new File(this.myOutputDir, (String)script.first);
            String content = NodeJsCoreSourcesFetchSession.refine((String)script.second);
            FileUtil.writeToFile((File)outFile, (String)content);
        }
    }

    private static boolean shouldSaveScript(@NotNull String filename) {
        if (filename == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filename", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "shouldSaveScript"));
        }
        if (StringUtil.containsChar((String)filename, (char)'/') || StringUtil.containsChar((String)filename, (char)'\\')) {
            return false;
        }
        String moduleName = FileUtil.getNameWithoutExtension((String)filename);
        if (NodeJsCoreModulesCatalog.INSTANCE.isIncludedCoreModule(moduleName)) {
            return true;
        }
        return !filename.startsWith("_");
    }

    private static String refine(@NotNull String source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "refine"));
        }
        String prefix = NodeJsCoreSourcesFetchSession.findPrefixToRemove(source = source.trim());
        if (prefix != null && source.endsWith(CONTENT_SUFFIX)) {
            return source.substring(prefix.length(), source.length() - CONTENT_SUFFIX.length());
        }
        return source;
    }

    @Nullable
    private static String findPrefixToRemove(@NotNull String source) {
        char ch;
        int lastPrefixCharInd;
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "findPrefixToRemove"));
        }
        String start = "(function (";
        if (!source.startsWith(start)) {
            return null;
        }
        int paramsStartInd = start.length();
        int paramsEndInd = source.indexOf(")", paramsStartInd);
        if (paramsEndInd == -1) {
            return null;
        }
        String params = source.substring(paramsStartInd, paramsEndInd);
        if (!params.contains("require")) {
            return null;
        }
        int openBraceInd = source.indexOf(123, paramsEndInd + 1);
        if (openBraceInd == -1) {
            return null;
        }
        if (!source.substring(paramsEndInd + 1, openBraceInd).trim().isEmpty()) {
            return null;
        }
        for (lastPrefixCharInd = openBraceInd + 1; lastPrefixCharInd < source.length() && (ch = source.charAt(lastPrefixCharInd)) != '\n'; ++lastPrefixCharInd) {
            if (Character.isWhitespace(ch)) continue;
            --lastPrefixCharInd;
            break;
        }
        if (lastPrefixCharInd >= source.length()) {
            return null;
        }
        return source.substring(0, lastPrefixCharInd + 1);
    }

    @NotNull
    private GeneralCommandLine createCommandLine(int debugPort) throws IOException, ExecutionException {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        if (this.myRemoteContext == null) {
            this.myWorkingDirectory = NodeJsCoreSourcesFetchSession.createWorkingDirectory();
            commandLine.setWorkDirectory(this.myWorkingDirectory.getAbsolutePath());
        } else {
            commandLine.setWorkDirectory(this.myRemoteContext.getRemoteWorkingDirectory());
        }
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        String exePath = this.myRemoteContext != null ? this.myRemoteContext.getRemoteInterpreterPath() : NodeJsLocalInterpreter.cast((NodeJsInterpreter)this.myInterpreter).getInterpreterSystemDependentPath();
        commandLine.setExePath(exePath);
        commandLine.setRedirectErrorStream(true);
        commandLine.addParameter("--debug=" + debugPort);
        File script = NodeJsCodeLocator.getFileRelativeToJsDir("node-core-modules/node-core-modules-loader.js");
        if (this.myRemoteContext != null) {
            NodeFileTransfer transfer = this.myRemoteContext.getManager().getFileTransfer(this.myProject, this.myRemoteContext.getRemoteSdkAdditionalData());
            this.myRemoteFile = transfer.copyToRemoteTmpFile(this.myRemoteContext.getRemoteWorkingDirectory(), "node-core-modules-loader.js", FileUtil.loadFile((File)script));
            commandLine.addParameter(this.myRemoteFile);
        } else {
            commandLine.addParameter(script.getAbsolutePath());
        }
        commandLine.addParameters((List)NodeJsCoreModulesCatalog.INSTANCE.getPublicCoreModules());
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "createCommandLine"));
        }
        return generalCommandLine;
    }

    @NotNull
    private static File createWorkingDirectory() throws IOException {
        File file = FileUtil.createTempDirectory((String)"intellij-node-core-modules-", null, (boolean)true);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession", "createWorkingDirectory"));
        }
        return file;
    }

    private static class MyProcessListener
    extends ProcessAdapter {
        private static final String READY_MESSAGE = "@debugger: core modules loaded, ready for communication";
        private final StringBuffer myStdOutBuffer = new StringBuffer();
        private final CountDownLatch myReadyLatch = new CountDownLatch(1);

        private MyProcessListener() {
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            if (outputType == ProcessOutputTypes.STDOUT) {
                String text = StringUtil.notNullize((String)event.getText());
                if (this.myReadyLatch.getCount() == 0L) {
                    MyProcessListener.logOutput(text);
                } else {
                    this.myStdOutBuffer.append(text);
                    if (this.isReady()) {
                        this.myReadyLatch.countDown();
                        MyProcessListener.logOutput(this.myStdOutBuffer.toString());
                    }
                }
            }
        }

        private static void logOutput(@NotNull String stdout) {
            if (stdout == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stdout", "com/jetbrains/nodejs/library/NodeJsCoreSourcesFetchSession$MyProcessListener", "logOutput"));
            }
            LOG.info("[stdout] " + StringUtil.trimEnd((String)stdout, (String)"\n"));
        }

        public void processTerminated(ProcessEvent event) {
            LOG.info("Process terminated with exit code " + event.getExitCode());
        }

        private boolean isReady() {
            return this.myStdOutBuffer.indexOf(READY_MESSAGE) >= 0;
        }

        public boolean awaitReady() throws ExecutionException {
            try {
                boolean ready = this.myReadyLatch.await(60L, TimeUnit.SECONDS);
                if (!ready) {
                    throw new ExecutionException("Cannot fetch core modules: timed out");
                }
                if (!this.isReady()) {
                    throw new AssertionError((Object)"Not ready for core modules configuration");
                }
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
            return false;
        }
    }
}

