/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaGlobalSettingsUtil {
    public static final String NODE_PACKAGE_NAME = "mocha";
    private static final String MOCHA_PACKAGE_DIR__KEY = "nodejs.mocha.mocha_node_package_dir";

    public static void storeMochaPackageDir(@NotNull Project project, @NotNull String packageDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaGlobalSettingsUtil", "storeMochaPackageDir"));
        }
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/jetbrains/nodejs/mocha/execution/MochaGlobalSettingsUtil", "storeMochaPackageDir"));
        }
        MochaGlobalSettingsUtil.setProjectSetting(project, MOCHA_PACKAGE_DIR__KEY, packageDir);
    }

    @Nullable
    public static String getMochaPackageDir(@NotNull Project project, @Nullable VirtualFile requester, @Nullable NodeJsInterpreter interpreter, boolean detectIfEmpty) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaGlobalSettingsUtil", "getMochaPackageDir"));
        }
        String packageDir = MochaGlobalSettingsUtil.getProjectSetting(project, MOCHA_PACKAGE_DIR__KEY);
        if (detectIfEmpty && StringUtil.isEmpty((String)packageDir) && (packageDir = MochaGlobalSettingsUtil.findMochaPackageDir(project, requester, interpreter)) != null && StringUtil.isNotEmpty((String)packageDir.trim())) {
            MochaGlobalSettingsUtil.setProjectSetting(project, MOCHA_PACKAGE_DIR__KEY, packageDir);
        }
        return packageDir;
    }

    @Nullable
    private static String findMochaPackageDir(@NotNull Project project, @Nullable VirtualFile requester, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaGlobalSettingsUtil", "findMochaPackageDir"));
        }
        ArrayList modules = ContainerUtil.newArrayList();
        if (requester == null || !requester.isValid()) {
            requester = project.getBaseDir();
        }
        NodeSettings nodeSettings = NodeSettings.create((NodeJsLocalInterpreter)NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreter));
        NodeModuleSearchUtil.findModulesWithName((List)modules, (String)NODE_PACKAGE_NAME, (VirtualFile)requester, (NodeSettings)nodeSettings, (boolean)true);
        for (CompletionModuleInfo module : modules) {
            VirtualFile moduleRoot = module.getVirtualFile();
            if (moduleRoot == null || !moduleRoot.isValid() || !moduleRoot.isDirectory()) continue;
            return FileUtil.toSystemDependentName((String)moduleRoot.getPath());
        }
        return null;
    }

    @Nullable
    private static String getProjectSetting(@NotNull Project project, @NotNull String key) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaGlobalSettingsUtil", "getProjectSetting"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/nodejs/mocha/execution/MochaGlobalSettingsUtil", "getProjectSetting"));
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        return propertiesComponent.getValue(key);
    }

    private static void setProjectSetting(@NotNull Project project, @NotNull String key, @NotNull String value) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaGlobalSettingsUtil", "setProjectSetting"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/nodejs/mocha/execution/MochaGlobalSettingsUtil", "setProjectSetting"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/nodejs/mocha/execution/MochaGlobalSettingsUtil", "setProjectSetting"));
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        propertiesComponent.setValue(key, value);
    }

    @NotNull
    public static List<String> detectAllMochaPackageDirs(@NotNull Project project, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaGlobalSettingsUtil", "detectAllMochaPackageDirs"));
        }
        ArrayList modules = ContainerUtil.newArrayList();
        NodeSettings nodeSettings = NodeSettings.create((NodeJsLocalInterpreter)NodeJsLocalInterpreter.tryCast((NodeJsInterpreter)interpreter));
        VirtualFile requester = project.getBaseDir();
        NodeModuleSearchUtil.findModulesWithName((List)modules, (String)NODE_PACKAGE_NAME, (VirtualFile)requester, (NodeSettings)nodeSettings, (boolean)true);
        ArrayList dirs = ContainerUtil.newArrayList();
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            dirs.add(FileUtil.toSystemDependentName((String)dir.getPath()));
        }
        ArrayList arrayList = dirs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaGlobalSettingsUtil", "detectAllMochaPackageDirs"));
        }
        return arrayList;
    }
}

