/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKindView;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaPatternView
extends MochaTestKindView {
    private final RawCommandLineEditor myPatternComponent;
    private final JPanel myPanel;

    public MochaPatternView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaPatternView", "<init>"));
        }
        this.myPatternComponent = new RawCommandLineEditor();
        this.myPatternComponent.setDialogCaption("File Patterns");
        MochaPatternView.configurePatternEmptyText((JBTextField)ObjectUtils.tryCast((Object)this.myPatternComponent.getTextField(), JBTextField.class));
        FileChooserFactory.getInstance().installFileCompletion(this.myPatternComponent.getTextField(), FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor(), true, (Disposable)project);
        this.myPanel = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent("&Test file patterns:", (JComponent)this.myPatternComponent).getPanel();
    }

    private static void configurePatternEmptyText(@Nullable JBTextField field) {
        if (field != null) {
            field.getEmptyText().setText("Keep empty to enable default mocha logic");
        }
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaPatternView", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void resetFrom(@NotNull MochaRunSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/mocha/execution/MochaPatternView", "resetFrom"));
        }
        this.myPatternComponent.setText(settings.getTestFilePattern());
    }

    @Override
    public void applyTo(@NotNull MochaRunSettings.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/nodejs/mocha/execution/MochaPatternView", "applyTo"));
        }
        builder.setTestFilePattern(this.myPatternComponent.getText());
    }
}

