/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class MochaProcessHandler
extends KillableColoredProcessHandler {
    private static final int TIMEOUT_SEC = 3;
    private static final String FORCE_QUIT_MESSAGE = "\nProcess hasn't been terminated within 3 seconds after the stop attempt. IDE has terminated it forcibly.\n";

    public MochaProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nodejs/mocha/execution/MochaProcessHandler", "<init>"));
        }
        super(commandLine);
    }

    protected void doDestroyProcess() {
        super.doDestroyProcess();
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        alarm.addRequest(() -> {
            if (!this.isProcessTerminated() && this.canKillProcess()) {
                this.notifyTextAvailable(FORCE_QUIT_MESSAGE, ProcessOutputTypes.SYSTEM);
                this.killProcess();
            }
            Disposer.dispose((Disposable)alarm);
        }, TimeUnit.SECONDS.toMillis(3L), ModalityState.any());
    }
}

