/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.mocha.execution.MochaGlobalSettingsUtil;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfigurationEditor;
import com.jetbrains.nodejs.mocha.execution.MochaRunProfileState;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettingsSerializationUtil;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import java.io.File;
import java.net.InetSocketAddress;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class MochaRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration,
PreferableRunConfiguration {
    private MochaRunSettings myRunSettings = new MochaRunSettings.Builder().build();

    protected MochaRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public SettingsEditor<MochaRunConfiguration> getConfigurationEditor() {
        MochaRunConfigurationEditor mochaRunConfigurationEditor = new MochaRunConfigurationEditor(this.getProject());
        if (mochaRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "getConfigurationEditor"));
        }
        return mochaRunConfigurationEditor;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        MochaRunSettings runSettings = MochaRunSettingsSerializationUtil.readFromXml(element);
        this.setRunSettings(runSettings);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        MochaRunSettingsSerializationUtil.writeToXml(element, this.myRunSettings);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "getState"));
        }
        String mochaPackageDir = this.getMochaPackageDirPath();
        return new MochaRunProfileState(this.getProject(), this, environment, mochaPackageDir, this.myRunSettings);
    }

    @NotNull
    private String getMochaPackageDirPath() {
        Project project = this.getProject();
        NodeJsInterpreter interpreter = this.getRunSettings().getInterpreterRef().resolve(project);
        String dir = MochaGlobalSettingsUtil.getMochaPackageDir(project, null, interpreter, true);
        String string = StringUtil.notNullize((String)dir);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "getMochaPackageDirPath"));
        }
        return string;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolve(this.getProject());
        NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        MochaRunConfiguration.validatePath(true, "mocha package", this.getMochaPackageDirPath(), true, false);
        MochaRunConfiguration.validatePath(true, "working directory", this.myRunSettings.getWorkingDir(), true, true);
        if (StringUtil.isEmptyOrSpaces((String)this.myRunSettings.getUi())) {
            throw new RuntimeConfigurationError("Unspecified mocha user interface");
        }
        MochaTestKind testKind = this.myRunSettings.getTestKind();
        if (MochaTestKind.DIRECTORY == testKind) {
            MochaRunConfiguration.validatePath(true, "test directory", this.myRunSettings.getTestDirPath(), false, true);
        } else if (MochaTestKind.PATTERN != testKind && (MochaTestKind.TEST_FILE == testKind || MochaTestKind.SUITE == testKind || MochaTestKind.TEST == testKind)) {
            MochaRunConfiguration.validatePath(false, "test file", this.myRunSettings.getTestFilePath(), true, false);
            if (MochaTestKind.SUITE == testKind && this.myRunSettings.getSuiteNames().isEmpty()) {
                throw new RuntimeConfigurationError("Unspecified suite name");
            }
            if (MochaTestKind.TEST == testKind && this.myRunSettings.getTestNames().isEmpty()) {
                throw new RuntimeConfigurationError("Unspecified test name");
            }
        }
    }

    private static void validatePath(boolean shouldBeDirectory, @NotNull String name, @Nullable String path, boolean shouldBeAbsolute, boolean warnIfNonexistent) throws RuntimeConfigurationException {
        boolean exists;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "validatePath"));
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            throw new RuntimeConfigurationError("Unspecified " + name);
        }
        File file = new File(path);
        if (shouldBeAbsolute && !file.isAbsolute()) {
            throw new RuntimeConfigurationError("No such " + name);
        }
        boolean bl = exists = shouldBeDirectory ? file.isDirectory() : file.isFile();
        if (!exists) {
            if (warnIfNonexistent) {
                throw new RuntimeConfigurationWarning("No such " + name);
            }
            throw new RuntimeConfigurationError("No such " + name);
        }
    }

    public String suggestedName() {
        MochaRunSettings runSettings = this.myRunSettings;
        MochaTestKind testKind = runSettings.getTestKind();
        if (testKind == MochaTestKind.DIRECTORY) {
            return MochaRunConfiguration.getRelativePath(this.getProject(), runSettings.getTestDirPath());
        }
        if (testKind == MochaTestKind.PATTERN) {
            return runSettings.getTestFilePattern();
        }
        if (testKind == MochaTestKind.TEST_FILE) {
            return MochaRunConfiguration.getRelativePath(this.getProject(), runSettings.getTestFilePath());
        }
        if (runSettings.getTestKind() == MochaTestKind.SUITE) {
            return StringUtil.join(runSettings.getSuiteNames(), (String)".");
        }
        if (runSettings.getTestKind() == MochaTestKind.TEST) {
            return StringUtil.join(runSettings.getTestNames(), (String)".");
        }
        return "All Tests";
    }

    @Nullable
    public String getActionName() {
        MochaRunSettings runSettings = this.myRunSettings;
        MochaTestKind testKind = runSettings.getTestKind();
        if (testKind == MochaTestKind.DIRECTORY) {
            return MochaRunConfiguration.getLastPathComponent(runSettings.getTestDirPath());
        }
        if (testKind == MochaTestKind.PATTERN) {
            return runSettings.getTestFilePattern();
        }
        if (testKind == MochaTestKind.TEST_FILE) {
            return MochaRunConfiguration.getLastPathComponent(runSettings.getTestFilePath());
        }
        if (runSettings.getTestKind() == MochaTestKind.SUITE) {
            return StringUtil.notNullize((String)((String)ContainerUtil.getLastItem(runSettings.getSuiteNames())));
        }
        if (runSettings.getTestKind() == MochaTestKind.TEST) {
            return StringUtil.notNullize((String)((String)ContainerUtil.getLastItem(runSettings.getTestNames())));
        }
        return "All Tests";
    }

    @NotNull
    private static String getRelativePath(@NotNull Project project, @NotNull String path) {
        String relativePath;
        VirtualFile root;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "getRelativePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "getRelativePath"));
        }
        VirtualFile file = LocalFileFinder.findFile((String)path);
        if (file != null && file.isValid() && (root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(file)) != null && root.isValid() && StringUtil.isNotEmpty((String)(relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar)))) {
            String string = relativePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "getRelativePath"));
            }
            return string;
        }
        String string = MochaRunConfiguration.getLastPathComponent(path);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "getRelativePath"));
        }
        return string;
    }

    @NotNull
    private static String getLastPathComponent(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "getLastPathComponent"));
        }
        int lastIndex = path.lastIndexOf(47);
        String string = lastIndex >= 0 ? path.substring(lastIndex + 1) : path;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "getLastPathComponent"));
        }
        return string;
    }

    @NotNull
    public MochaRunSettings getRunSettings() {
        MochaRunSettings mochaRunSettings = this.myRunSettings;
        if (mochaRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "getRunSettings"));
        }
        return mochaRunSettings;
    }

    public void setRunSettings(@NotNull MochaRunSettings runSettings) {
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "setRunSettings"));
        }
        this.myRunSettings = runSettings;
    }

    public boolean isPreferredOver(@NotNull RunConfiguration otherRc, @NotNull PsiElement sourceElement) {
        if (otherRc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherRc", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "isPreferredOver"));
        }
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/jetbrains/nodejs/mocha/execution/MochaRunConfiguration", "isPreferredOver"));
        }
        return true;
    }

    public void initializeFields() {
        VirtualFile dir;
        MochaRunSettings.Builder builder = this.myRunSettings.builder();
        if (this.myRunSettings.getUi().isEmpty()) {
            builder.setUi("bdd");
        }
        if (this.myRunSettings.getWorkingDir().trim().isEmpty() && (dir = this.getProject().getBaseDir()) != null) {
            builder.setWorkingDir(dir.getPath()).build();
        }
        if (this.myRunSettings.getTestKind() == MochaTestKind.DIRECTORY && this.myRunSettings.getTestDirPath().trim().isEmpty()) {
            String workingDirPath = FileUtil.toSystemIndependentName((String)this.myRunSettings.getWorkingDir());
            VirtualFile workingDir = LocalFileSystem.getInstance().findFileByPath(workingDirPath);
            if (workingDir != null && workingDir.isValid() && workingDir.isDirectory()) {
                String testDirName;
                String[] testDirNames = new String[]{"test", "spec", "tests", "specs"};
                VirtualFile testDir = null;
                String[] stringArray = testDirNames;
                int n = stringArray.length;
                for (int i = 0; !(i >= n || (testDir = workingDir.findChild(testDirName = stringArray[i])) != null && testDir.isValid() && testDir.isDirectory()); ++i) {
                }
                if (testDir != null) {
                    builder.setTestDirPath(testDir.getPath()).build();
                }
            }
        }
        this.myRunSettings = builder.build();
    }

    @Nullable
    public InetSocketAddress getDebugAddress() throws ExecutionException {
        return null;
    }
}

