/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.ide.BrowserUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.mocha.MochaUtil;
import com.jetbrains.nodejs.mocha.execution.MochaGlobalSettingsUtil;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import com.jetbrains.nodejs.mocha.execution.MochaTestKindView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaRunConfigurationEditor
extends SettingsEditor<MochaRunConfiguration> {
    private final Project myProject;
    private final JPanel myComponent;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final RawCommandLineEditor myNodeOptions;
    private final TextFieldWithBrowseButton myWorkingDirTextFieldWithBrowseButton;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvironmentVariablesTextFieldWithBrowseButton;
    private final TextFieldWithHistoryWithBrowseButton myMochaPackageDirPathTextFieldWithBrowseButton;
    private final TextFieldWithHistory myUiComponent;
    private final RawCommandLineEditor myExtraMochaOptions;
    private final Map<MochaTestKind, JRadioButton> myRadioButtonMap;
    private final Map<MochaTestKind, MochaTestKindView> myTestKindViewMap;
    private final JPanel mySelectedTestKindPanel;
    private final int myLongestLabelWidth;

    public MochaRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "<init>"));
        }
        this.myRadioButtonMap = ContainerUtil.newHashMap();
        this.myTestKindViewMap = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodeOptions = new RawCommandLineEditor();
        this.myNodeOptions.setDialogCaption("Node Options");
        this.myWorkingDirTextFieldWithBrowseButton = MochaRunConfigurationEditor.createWorkingDirTextField(project);
        this.myEnvironmentVariablesTextFieldWithBrowseButton = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.myMochaPackageDirPathTextFieldWithBrowseButton = this.createMochaPackageDirPathTextField(project);
        this.myUiComponent = MochaRunConfigurationEditor.createUiComponent();
        ComponentWithBrowseButton<TextFieldWithHistory> uiComponentWithInfoButton = this.createUiComponentWithInfoButton();
        this.myExtraMochaOptions = new RawCommandLineEditor();
        this.myExtraMochaOptions.setDialogCaption("Extra Mocha Options");
        JPanel testKindPanel = this.createTestKindRadioButtonPanel();
        this.mySelectedTestKindPanel = new JPanel(new BorderLayout());
        this.myLongestLabelWidth = new JLabel((String)"Environment variables:").getPreferredSize().width;
        this.myComponent = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent("Node &interpreter:", (JComponent)this.myNodeInterpreterField).addLabeledComponent("Node &options:", (JComponent)this.myNodeOptions).addLabeledComponent("&Working directory:", (JComponent)this.myWorkingDirTextFieldWithBrowseButton).addLabeledComponent("&Environment variables:", (JComponent)this.myEnvironmentVariablesTextFieldWithBrowseButton).addLabeledComponent("&Mocha package:", (JComponent)this.myMochaPackageDirPathTextFieldWithBrowseButton).addLabeledComponent("&User interface:", (JComponent)SwingHelper.wrapWithoutStretch(uiComponentWithInfoButton)).addLabeledComponent("E&xtra Mocha options:", (JComponent)this.myExtraMochaOptions).addSeparator(8).addComponent((JComponent)testKindPanel).addComponent((JComponent)this.mySelectedTestKindPanel).getPanel();
    }

    @NotNull
    private JPanel createTestKindRadioButtonPanel() {
        JPanel testKindPanel = new JPanel(new FlowLayout(1, JBUI.scale((int)30), 0));
        testKindPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)10, (int)0, (int)0));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final MochaTestKind testKind : MochaTestKind.values()) {
            JRadioButton radioButton = new JRadioButton(UIUtil.removeMnemonic((String)testKind.getName()));
            int index = UIUtil.getDisplayMnemonicIndex((String)testKind.getName());
            if (index != -1) {
                radioButton.setMnemonic(testKind.getName().charAt(index + 1));
                radioButton.setDisplayedMnemonicIndex(index);
            }
            radioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MochaRunConfigurationEditor.this.setTestKind(testKind);
                }
            });
            this.myRadioButtonMap.put(testKind, radioButton);
            testKindPanel.add(radioButton);
            buttonGroup.add(radioButton);
        }
        JPanel jPanel = testKindPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "createTestKindRadioButtonPanel"));
        }
        return jPanel;
    }

    @Nullable
    private MochaTestKind getTestKind() {
        for (Map.Entry<MochaTestKind, JRadioButton> entry : this.myRadioButtonMap.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            return entry.getKey();
        }
        return null;
    }

    private void setTestKind(@NotNull MochaTestKind testKind) {
        if (testKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testKind", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "setTestKind"));
        }
        MochaTestKind selectedTestKind = this.getTestKind();
        if (selectedTestKind != testKind) {
            JRadioButton radioButton = this.myRadioButtonMap.get((Object)testKind);
            radioButton.setSelected(true);
        }
        MochaTestKindView view = this.getTestKindView(testKind);
        MochaRunConfigurationEditor.setCenterBorderLayoutComponent(this.mySelectedTestKindPanel, view.getComponent());
    }

    private static void setCenterBorderLayoutComponent(@NotNull JPanel panel, @NotNull Component child) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "setCenterBorderLayoutComponent"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "setCenterBorderLayoutComponent"));
        }
        Component prevChild = ((BorderLayout)panel.getLayout()).getLayoutComponent("Center");
        if (prevChild != null) {
            panel.remove(prevChild);
        }
        panel.add(child, "Center");
        panel.revalidate();
        panel.repaint();
    }

    @NotNull
    private MochaTestKindView getTestKindView(@NotNull MochaTestKind testKind) {
        if (testKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testKind", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "getTestKindView"));
        }
        MochaTestKindView view = this.myTestKindViewMap.get((Object)testKind);
        if (view == null) {
            view = testKind.createView(this.myProject);
            this.myTestKindViewMap.put(testKind, view);
            JComponent component = view.getComponent();
            if (component.getLayout() instanceof GridBagLayout) {
                component.add(Box.createHorizontalStrut(this.myLongestLabelWidth), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
            }
        }
        MochaTestKindView mochaTestKindView = view;
        if (mochaTestKindView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "getTestKindView"));
        }
        return mochaTestKindView;
    }

    @NotNull
    private ComponentWithBrowseButton<TextFieldWithHistory> createUiComponentWithInfoButton() {
        ComponentWithBrowseButton componentWithBrowseButton = SwingHelper.wrapWithInfoButton((JComponent)this.myUiComponent, (String)"Show description in browser", (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserUtil.browse((String)"http://mochajs.org/#interfaces");
            }
        });
        if (componentWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "createUiComponentWithInfoButton"));
        }
        return componentWithBrowseButton;
    }

    @NotNull
    private TextFieldWithHistoryWithBrowseButton createMochaPackageDirPathTextField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "createMochaPackageDirPathTextField"));
        }
        TextFieldWithHistoryWithBrowseButton packageDirPathComponent = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)packageDirPathComponent.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "lambda$createMochaPackageDirPathTextField$0"));
            }
            List<String> packageDirs = MochaGlobalSettingsUtil.detectAllMochaPackageDirs(project, this.myNodeInterpreterField.getInterpreter());
            Collections.sort(packageDirs);
            return packageDirs;
        });
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)packageDirPathComponent, (String)NodeJSBundle.message("runConfiguration.mocha.package_dir.browse_dialog.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = packageDirPathComponent;
        if (textFieldWithHistoryWithBrowseButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "createMochaPackageDirPathTextField"));
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private static TextFieldWithBrowseButton createWorkingDirTextField(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "createWorkingDirTextField"));
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)NodeJSBundle.message("runConfiguration.mocha.working_dir.browse_dialog.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "createWorkingDirTextField"));
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    private static TextFieldWithHistory createUiComponent() {
        TextFieldWithHistory textFieldWithHistory = new TextFieldWithHistory();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setHistory(MochaUtil.getMochaUiList());
        TextFieldWithHistory textFieldWithHistory2 = textFieldWithHistory;
        if (textFieldWithHistory2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "createUiComponent"));
        }
        return textFieldWithHistory2;
    }

    protected void resetEditorFrom(@NotNull MochaRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "resetEditorFrom"));
        }
        MochaRunSettings runSettings = configuration.getRunSettings();
        this.myNodeInterpreterField.setInterpreterRef(runSettings.getInterpreterRef());
        this.myNodeOptions.setText(runSettings.getNodeOptions());
        this.myWorkingDirTextFieldWithBrowseButton.setText(FileUtil.toSystemDependentName((String)runSettings.getWorkingDir()));
        this.myEnvironmentVariablesTextFieldWithBrowseButton.setData(runSettings.getEnvData());
        NodeJsInterpreter interpreter = runSettings.getInterpreterRef().resolve(this.myProject);
        String mochaPackageDir = MochaGlobalSettingsUtil.getMochaPackageDir(this.myProject, null, interpreter, true);
        mochaPackageDir = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)mochaPackageDir));
        this.myMochaPackageDirPathTextFieldWithBrowseButton.setTextAndAddToHistory(mochaPackageDir);
        this.myUiComponent.setTextAndAddToHistory(runSettings.getUi());
        this.myExtraMochaOptions.setText(runSettings.getExtraMochaOptions());
        this.setTestKind(runSettings.getTestKind());
        MochaTestKindView view = this.getTestKindView(runSettings.getTestKind());
        view.resetFrom(runSettings);
        this.updatePreferredWidth();
    }

    private void updatePreferredWidth() {
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)this.myComponent);
        if (dialogWrapper instanceof SingleConfigurableEditor) {
            this.myNodeInterpreterField.setPreferredWidthToFitText();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myMochaPackageDirPathTextFieldWithBrowseButton);
            SwingHelper.setPreferredWidthToFitText((TextFieldWithBrowseButton)this.myWorkingDirTextFieldWithBrowseButton);
            ApplicationManager.getApplication().invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper), ModalityState.any());
        }
    }

    protected void applyEditorTo(@NotNull MochaRunConfiguration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "applyEditorTo"));
        }
        MochaRunSettings.Builder builder = new MochaRunSettings.Builder();
        NodeJsInterpreterRef interpreterRef = this.myNodeInterpreterField.getInterpreterRef();
        builder.setInterpreterRef(interpreterRef);
        builder.setNodeOptions(this.myNodeOptions.getText());
        builder.setWorkingDir(this.myWorkingDirTextFieldWithBrowseButton.getText());
        builder.setEnvData(this.myEnvironmentVariablesTextFieldWithBrowseButton.getData());
        String mochaNodePackageDir = this.myMochaPackageDirPathTextFieldWithBrowseButton.getText();
        MochaGlobalSettingsUtil.storeMochaPackageDir(this.myProject, mochaNodePackageDir);
        builder.setUi(StringUtil.notNullize((String)this.myUiComponent.getText()));
        builder.setExtraMochaOptions(this.myExtraMochaOptions.getText());
        MochaTestKind testKind = this.getTestKind();
        if (testKind != null) {
            builder.setTestKind(testKind);
            MochaTestKindView view = this.getTestKindView(testKind);
            view.applyTo(builder);
        }
        configuration.setRunSettings(builder.build());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }
}

