/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MochaRunSettings {
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myNodeOptions;
    private final String myWorkingDir;
    private final EnvironmentVariablesData myEnvData;
    private final String myUi;
    private final String myExtraMochaOptions;
    private final MochaTestKind myTestKind;
    private final String myTestDirPath;
    private final boolean myRecursive;
    private final String myTestFilePattern;
    private final String myTestFilePath;
    private final List<String> mySuiteNames;
    private final List<String> myTestNames;

    private MochaRunSettings(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "<init>"));
        }
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myNodeOptions = builder.myNodeOptions;
        this.myWorkingDir = FileUtil.toSystemIndependentName((String)builder.myWorkingDir);
        this.myEnvData = builder.myEnvData;
        this.myUi = builder.myUi;
        this.myExtraMochaOptions = builder.myExtraMochaOptions;
        this.myTestKind = builder.myTestKind;
        this.myTestDirPath = FileUtil.toSystemIndependentName((String)builder.myTestDirPath);
        this.myRecursive = builder.myRecursive;
        this.myTestFilePattern = builder.myTestFilePattern;
        this.myTestFilePath = FileUtil.toSystemIndependentName((String)builder.myTestFilePath);
        this.mySuiteNames = ImmutableList.copyOf((Collection)builder.mySuiteNames);
        this.myTestNames = ImmutableList.copyOf((Collection)builder.myTestNames);
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getNodeOptions() {
        String string = this.myNodeOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "getNodeOptions"));
        }
        return string;
    }

    @NotNull
    public String getWorkingDir() {
        String string = this.myWorkingDir;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "getWorkingDir"));
        }
        return string;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "getEnvData"));
        }
        return environmentVariablesData;
    }

    @NotNull
    public String getUi() {
        String string = this.myUi;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "getUi"));
        }
        return string;
    }

    @NotNull
    public String getExtraMochaOptions() {
        String string = this.myExtraMochaOptions;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "getExtraMochaOptions"));
        }
        return string;
    }

    @NotNull
    public MochaTestKind getTestKind() {
        MochaTestKind mochaTestKind = this.myTestKind;
        if (mochaTestKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "getTestKind"));
        }
        return mochaTestKind;
    }

    @NotNull
    public String getTestDirPath() {
        String string = this.myTestDirPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "getTestDirPath"));
        }
        return string;
    }

    public boolean isRecursive() {
        return this.myRecursive;
    }

    @NotNull
    public String getTestFilePattern() {
        String string = this.myTestFilePattern;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "getTestFilePattern"));
        }
        return string;
    }

    @NotNull
    public String getTestFilePath() {
        String string = this.myTestFilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "getTestFilePath"));
        }
        return string;
    }

    @NotNull
    public List<String> getSuiteNames() {
        List<String> list = this.mySuiteNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "getSuiteNames"));
        }
        return list;
    }

    @NotNull
    public List<String> getTestNames() {
        List<String> list = this.myTestNames;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "getTestNames"));
        }
        return list;
    }

    @NotNull
    public Builder builder() {
        Builder builder = new Builder(this);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "builder"));
        }
        return builder;
    }

    @NotNull
    public static Builder builder(@NotNull MochaRunSettings runSettings) {
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "builder"));
        }
        Builder builder = new Builder(runSettings);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings", "builder"));
        }
        return builder;
    }

    public static class Builder {
        private NodeJsInterpreterRef myInterpreterRef;
        private String myNodeOptions;
        private String myWorkingDir;
        private EnvironmentVariablesData myEnvData;
        private String myUi;
        private String myExtraMochaOptions;
        private MochaTestKind myTestKind;
        private String myTestDirPath;
        private boolean myRecursive;
        private String myTestFilePattern;
        private String myTestFilePath;
        private List<String> mySuiteNames;
        private List<String> myTestNames;

        public Builder() {
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myWorkingDir = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myUi = "";
            this.myExtraMochaOptions = "";
            this.myTestKind = MochaTestKind.DIRECTORY;
            this.myTestDirPath = "";
            this.myRecursive = false;
            this.myTestFilePattern = "";
            this.myTestFilePath = "";
            this.mySuiteNames = ImmutableList.of();
            this.myTestNames = ImmutableList.of();
        }

        public Builder(@NotNull MochaRunSettings runSettings) {
            if (runSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "<init>"));
            }
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myWorkingDir = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myUi = "";
            this.myExtraMochaOptions = "";
            this.myTestKind = MochaTestKind.DIRECTORY;
            this.myTestDirPath = "";
            this.myRecursive = false;
            this.myTestFilePattern = "";
            this.myTestFilePath = "";
            this.mySuiteNames = ImmutableList.of();
            this.myTestNames = ImmutableList.of();
            this.myInterpreterRef = runSettings.getInterpreterRef();
            this.myNodeOptions = runSettings.getNodeOptions();
            this.myWorkingDir = runSettings.getWorkingDir();
            this.myEnvData = runSettings.getEnvData();
            this.myUi = runSettings.getUi();
            this.myExtraMochaOptions = runSettings.getExtraMochaOptions();
            this.myTestKind = runSettings.getTestKind();
            this.myTestDirPath = runSettings.getTestDirPath();
            this.myRecursive = runSettings.isRecursive();
            this.myTestFilePattern = runSettings.getTestFilePattern();
            this.myTestFilePath = runSettings.getTestFilePath();
            this.mySuiteNames = runSettings.getSuiteNames();
            this.myTestNames = runSettings.getTestNames();
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setInterpreterRef"));
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setInterpreterRef"));
            }
            return builder;
        }

        @NotNull
        public Builder setNodeOptions(@NotNull String nodeOptions) {
            if (nodeOptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeOptions", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setNodeOptions"));
            }
            this.myNodeOptions = nodeOptions;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setNodeOptions"));
            }
            return builder;
        }

        @NotNull
        public Builder setWorkingDir(@NotNull String workingDir) {
            if (workingDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setWorkingDir"));
            }
            this.myWorkingDir = workingDir;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setWorkingDir"));
            }
            return builder;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setEnvData"));
            }
            this.myEnvData = envData;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setEnvData"));
            }
            return builder;
        }

        @NotNull
        public Builder setUi(@NotNull String ui) {
            if (ui == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setUi"));
            }
            this.myUi = ui;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setUi"));
            }
            return builder;
        }

        @NotNull
        public Builder setExtraMochaOptions(@NotNull String extraMochaOptions) {
            if (extraMochaOptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraMochaOptions", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setExtraMochaOptions"));
            }
            this.myExtraMochaOptions = extraMochaOptions;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setExtraMochaOptions"));
            }
            return builder;
        }

        @NotNull
        public Builder setTestKind(@NotNull MochaTestKind testKind) {
            if (testKind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testKind", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setTestKind"));
            }
            this.myTestKind = testKind;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setTestKind"));
            }
            return builder;
        }

        @NotNull
        public Builder setTestDirPath(@NotNull String testDirPath) {
            if (testDirPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testDirPath", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setTestDirPath"));
            }
            this.myTestDirPath = testDirPath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setTestDirPath"));
            }
            return builder;
        }

        @NotNull
        public Builder setRecursive(boolean recursive) {
            this.myRecursive = recursive;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setRecursive"));
            }
            return builder;
        }

        @NotNull
        public Builder setTestFilePattern(@NotNull String testFilePattern) {
            if (testFilePattern == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFilePattern", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setTestFilePattern"));
            }
            this.myTestFilePattern = testFilePattern;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setTestFilePattern"));
            }
            return builder;
        }

        @NotNull
        public Builder setTestFilePath(@NotNull String testFilePath) {
            if (testFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testFilePath", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setTestFilePath"));
            }
            this.myTestFilePath = testFilePath;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setTestFilePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setSuiteNames(@NotNull List<String> suiteNames) {
            if (suiteNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suiteNames", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setSuiteNames"));
            }
            this.mySuiteNames = suiteNames;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setSuiteNames"));
            }
            return builder;
        }

        @NotNull
        public Builder setTestNames(@NotNull List<String> testNames) {
            if (testNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testNames", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setTestNames"));
            }
            this.myTestNames = testNames;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "setTestNames"));
            }
            return builder;
        }

        @NotNull
        public MochaRunSettings build() {
            MochaRunSettings mochaRunSettings = new MochaRunSettings(this);
            if (mochaRunSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettings$Builder", "build"));
            }
            return mochaRunSettings;
        }
    }
}

