/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaRunSettingsSerializationUtil {
    private static final String NODE_INTERPRETER__KEY = "node-interpreter";
    private static final String NODE_OPTIONS__KEY = "node-options";
    private static final String WORKING_DIRECTORY__KEY = "working-directory";
    private static final String PASS_PARENT_ENV__KEY = "pass-parent-env";
    private static final String UI__KEY = "ui";
    private static final String EXTRA_MOCHA_OPTIONS__KEY = "extra-mocha-options";
    private static final String TEST_KIND__KEY = "test-kind";
    private static final String TEST_DIRECTORY__KEY = "test-directory";
    private static final String RECURSIVE__KEY = "recursive";
    private static final String TEST_FILE_PATTERN__KEY = "test-pattern";
    private static final String TEST_FILE__KEY = "test-file";
    private static final String TEST_NAMES__KEY = "test-names";
    private static final String TEST_NAME__KEY = "name";

    private MochaRunSettingsSerializationUtil() {
    }

    @NotNull
    public static MochaRunSettings readFromXml(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "readFromXml"));
        }
        MochaRunSettings.Builder builder = new MochaRunSettings.Builder();
        String interpreterRefName = MochaRunSettingsSerializationUtil.readTagNullable(parent, NODE_INTERPRETER__KEY);
        builder.setInterpreterRef(NodeJsInterpreterRef.create((String)StringUtil.notNullize((String)interpreterRefName)));
        String nodeOptions = MochaRunSettingsSerializationUtil.readTag(parent, NODE_OPTIONS__KEY);
        builder.setNodeOptions(nodeOptions);
        String workingDirPath = MochaRunSettingsSerializationUtil.readTag(parent, WORKING_DIRECTORY__KEY);
        builder.setWorkingDir(FileUtil.toSystemDependentName((String)workingDirPath));
        EnvironmentVariablesData envData = EnvironmentVariablesData.readExternal((Element)parent);
        String passParentEnvStr = MochaRunSettingsSerializationUtil.readTag(parent, PASS_PARENT_ENV__KEY);
        if (StringUtil.isNotEmpty((String)passParentEnvStr)) {
            envData = EnvironmentVariablesData.create((Map)envData.getEnvs(), (boolean)Boolean.parseBoolean(passParentEnvStr));
        }
        builder.setEnvData(envData);
        builder.setUi(MochaRunSettingsSerializationUtil.readTag(parent, UI__KEY));
        String extraMochaOptions = MochaRunSettingsSerializationUtil.readTag(parent, EXTRA_MOCHA_OPTIONS__KEY);
        builder.setExtraMochaOptions(extraMochaOptions);
        MochaTestKind testKind = MochaRunSettingsSerializationUtil.deserializeTestKind(MochaRunSettingsSerializationUtil.readTag(parent, TEST_KIND__KEY));
        builder.setTestKind(testKind);
        if (MochaTestKind.DIRECTORY == testKind) {
            String testDirPath = MochaRunSettingsSerializationUtil.readTag(parent, TEST_DIRECTORY__KEY);
            builder.setTestDirPath(FileUtil.toSystemDependentName((String)testDirPath));
            String recursiveStr = MochaRunSettingsSerializationUtil.readTag(parent, RECURSIVE__KEY);
            builder.setRecursive(Boolean.parseBoolean(recursiveStr));
        } else if (MochaTestKind.PATTERN == testKind) {
            builder.setTestFilePattern(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)MochaRunSettingsSerializationUtil.readTag(parent, TEST_FILE_PATTERN__KEY))));
        } else if (MochaTestKind.TEST_FILE == testKind || MochaTestKind.SUITE == testKind || MochaTestKind.TEST == testKind) {
            builder.setTestFilePath(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)MochaRunSettingsSerializationUtil.readTag(parent, TEST_FILE__KEY))));
            if (MochaTestKind.SUITE == testKind) {
                builder.setSuiteNames(MochaRunSettingsSerializationUtil.readTestNames(parent));
            } else if (MochaTestKind.TEST == testKind) {
                builder.setTestNames(MochaRunSettingsSerializationUtil.readTestNames(parent));
            }
        }
        MochaRunSettings mochaRunSettings = builder.build();
        if (mochaRunSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "readFromXml"));
        }
        return mochaRunSettings;
    }

    private static List<String> readTestNames(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "readTestNames"));
        }
        Element testNamesElement = parent.getChild(TEST_NAMES__KEY);
        if (testNamesElement == null) {
            return Collections.emptyList();
        }
        return JDOMExternalizerUtil.getChildrenValueAttributes((Element)testNamesElement, (String)TEST_NAME__KEY);
    }

    @NotNull
    private static MochaTestKind deserializeTestKind(@Nullable String testKindStr) {
        MochaTestKind mochaTestKind;
        try {
            mochaTestKind = MochaTestKind.valueOf(testKindStr);
        }
        catch (Exception ignored) {
            MochaTestKind mochaTestKind2 = MochaTestKind.DIRECTORY;
            if (mochaTestKind2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "deserializeTestKind"));
            }
            return mochaTestKind2;
        }
        if (mochaTestKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "deserializeTestKind"));
        }
        return mochaTestKind;
    }

    @NotNull
    private static String readTag(@NotNull Element parent, @NotNull String tagName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "readTag"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "readTag"));
        }
        String string = StringUtil.notNullize((String)MochaRunSettingsSerializationUtil.readTagNullable(parent, tagName));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "readTag"));
        }
        return string;
    }

    @Nullable
    private static String readTagNullable(@NotNull Element parent, @NotNull String tagName) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "readTagNullable"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "readTagNullable"));
        }
        Element child = parent.getChild(tagName);
        String value = null;
        if (child != null) {
            value = child.getText();
        }
        return value;
    }

    public static void writeToXml(@NotNull Element parent, @NotNull MochaRunSettings runSettings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "writeToXml"));
        }
        if (runSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runSettings", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "writeToXml"));
        }
        NodeJsInterpreterRef interpreterRef = runSettings.getInterpreterRef();
        MochaRunSettingsSerializationUtil.writeTag(parent, NODE_INTERPRETER__KEY, interpreterRef.getReferenceName());
        MochaRunSettingsSerializationUtil.writeTag(parent, NODE_OPTIONS__KEY, runSettings.getNodeOptions());
        String workingDirPath = FileUtil.toSystemIndependentName((String)runSettings.getWorkingDir());
        MochaRunSettingsSerializationUtil.writeTag(parent, WORKING_DIRECTORY__KEY, workingDirPath);
        MochaRunSettingsSerializationUtil.writeTag(parent, PASS_PARENT_ENV__KEY, String.valueOf(runSettings.getEnvData().isPassParentEnvs()));
        EnvironmentVariablesComponent.writeExternal((Element)parent, (Map)runSettings.getEnvData().getEnvs());
        MochaRunSettingsSerializationUtil.writeTag(parent, UI__KEY, runSettings.getUi());
        MochaRunSettingsSerializationUtil.writeTag(parent, EXTRA_MOCHA_OPTIONS__KEY, runSettings.getExtraMochaOptions());
        MochaTestKind testKind = runSettings.getTestKind();
        MochaRunSettingsSerializationUtil.writeTag(parent, TEST_KIND__KEY, testKind.name());
        if (MochaTestKind.DIRECTORY == testKind) {
            MochaRunSettingsSerializationUtil.writeTag(parent, TEST_DIRECTORY__KEY, FileUtil.toSystemIndependentName((String)runSettings.getTestDirPath()));
            MochaRunSettingsSerializationUtil.writeTag(parent, RECURSIVE__KEY, String.valueOf(runSettings.isRecursive()));
        } else if (MochaTestKind.PATTERN == testKind) {
            MochaRunSettingsSerializationUtil.writeTag(parent, TEST_FILE_PATTERN__KEY, FileUtil.toSystemIndependentName((String)runSettings.getTestFilePattern()));
        } else if (MochaTestKind.TEST_FILE == testKind || MochaTestKind.SUITE == testKind || MochaTestKind.TEST == testKind) {
            MochaRunSettingsSerializationUtil.writeTag(parent, TEST_FILE__KEY, FileUtil.toSystemIndependentName((String)runSettings.getTestFilePath()));
            if (MochaTestKind.SUITE == testKind) {
                MochaRunSettingsSerializationUtil.writeTestNames(parent, runSettings.getSuiteNames());
            } else if (MochaTestKind.TEST == testKind) {
                MochaRunSettingsSerializationUtil.writeTestNames(parent, runSettings.getTestNames());
            }
        }
    }

    private static void writeTestNames(@NotNull Element parent, @NotNull List<String> testNames) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "writeTestNames"));
        }
        if (testNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testNames", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "writeTestNames"));
        }
        if (!testNames.isEmpty()) {
            Element testNamesElement = new Element(TEST_NAMES__KEY);
            JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)testNamesElement, (String)TEST_NAME__KEY, testNames);
            parent.addContent(testNamesElement);
        }
    }

    private static void writeTag(@NotNull Element parent, @NotNull String tagName, @NotNull String value) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "writeTag"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "writeTag"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/nodejs/mocha/execution/MochaRunSettingsSerializationUtil", "writeTag"));
        }
        Element element = new Element(tagName);
        element.setText(value);
        parent.addContent(element);
    }
}

