/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.mocha.execution;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.JsTestFileByTestNameIndex;
import com.intellij.javascript.testFramework.exports.ExportsTestFileStructure;
import com.intellij.javascript.testFramework.exports.ExportsTestFileStructureBuilder;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructureBuilder;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MochaTestLocationProvider
implements SMTestLocator {
    private static final String SUITE_PROTOCOL_ID = "suite";
    private static final String TEST_PROTOCOL_ID = "test";
    private static final char SPLIT_CHAR = '.';
    private final String myUi;

    public MochaTestLocationProvider(@NotNull String ui) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "<init>"));
        }
        this.myUi = ui;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "getLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "getLocation"));
        }
        boolean suite = SUITE_PROTOCOL_ID.equals(protocol);
        if (suite || TEST_PROTOCOL_ID.equals(protocol)) {
            Location location = this.getTestLocation(project, path, suite);
            List list = ContainerUtil.createMaybeSingletonList((Object)location);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "getLocation"));
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "getLocation"));
        }
        return list;
    }

    @Nullable
    private Location getTestLocation(@NotNull Project project, @NotNull String locationData, boolean isSuite) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "getTestLocation"));
        }
        if (locationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locationData", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "getTestLocation"));
        }
        List path = EscapeUtils.split((String)locationData, (char)'.');
        if (path.size() < 2) {
            return null;
        }
        PsiElement psiElement = "bdd".equals(this.myUi) ? MochaTestLocationProvider.findJasmineElement(project, path, isSuite) : ("qunit".equals(this.myUi) ? MochaTestLocationProvider.findQUnitElement(project, path, isSuite) : ("exports".equals(this.myUi) ? MochaTestLocationProvider.findExportsElement(project, path) : ("tdd".equals(this.myUi) ? MochaTestLocationProvider.findTddElement(project, path, isSuite) : this.findAppropriateElement(project, path, isSuite))));
        if (psiElement != null) {
            return PsiLocation.fromPsiElement((PsiElement)psiElement);
        }
        return null;
    }

    private PsiElement findAppropriateElement(Project project, @NotNull List<String> path, boolean suite) {
        PsiElement element;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "findAppropriateElement"));
        }
        String lowerCasedUi = this.myUi.toLowerCase(Locale.ENGLISH);
        boolean bdd = false;
        boolean qUnit = false;
        boolean exports = false;
        if (lowerCasedUi.contains("bdd")) {
            bdd = true;
            element = MochaTestLocationProvider.findJasmineElement(project, path, suite);
            if (element != null) {
                return element;
            }
        }
        if (lowerCasedUi.contains("qunit")) {
            qUnit = true;
            element = MochaTestLocationProvider.findQUnitElement(project, path, suite);
            if (element != null) {
                return element;
            }
        }
        if (lowerCasedUi.contains("exports")) {
            exports = true;
            element = MochaTestLocationProvider.findExportsElement(project, path);
            if (element != null) {
                return element;
            }
        }
        if (!bdd && (element = MochaTestLocationProvider.findJasmineElement(project, path, suite)) != null) {
            return element;
        }
        if (!qUnit && (element = MochaTestLocationProvider.findQUnitElement(project, path, suite)) != null) {
            return element;
        }
        if (!exports && (element = MochaTestLocationProvider.findExportsElement(project, path)) != null) {
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement findJasmineElement(Project project, @NotNull List<String> location, boolean suite) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "findJasmineElement"));
        }
        VirtualFile executedFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)location.get(0)));
        JsTestFqn testFqn = new JsTestFqn(JSTestFileType.JASMINE, location.subList(1, location.size()));
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findFiles((JsTestFqn)testFqn, (GlobalSearchScope)scope, (VirtualFile)executedFile);
        for (VirtualFile file : jsTestVirtualFiles) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile)) continue;
            JSFile jsFile = (JSFile)psiFile;
            JasmineFileStructureBuilder builder = JasmineFileStructureBuilder.getInstance();
            JasmineFileStructure jasmineFileStructure = (JasmineFileStructure)builder.fetchCachedTestFileStructure(jsFile);
            PsiElement element = jasmineFileStructure.findPsiElement(testFqn.getNames(), null);
            if (element == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement findQUnitElement(@NotNull Project project, @NotNull List<String> location, boolean suite) {
        String testName;
        String moduleName;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "findQUnitElement"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "findQUnitElement"));
        }
        VirtualFile executedFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)location.get(0)));
        if (suite) {
            moduleName = location.get(1);
            testName = null;
        } else if (location.size() > 2) {
            moduleName = location.get(1);
            testName = location.get(2);
        } else {
            moduleName = "Default Module";
            testName = location.get(1);
        }
        String key = JsTestFileByTestNameIndex.createQUnitKey((String)moduleName, testName);
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findFilesByKey((String)key, (GlobalSearchScope)scope, (VirtualFile)executedFile);
        for (VirtualFile file : jsTestVirtualFiles) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile)) continue;
            JSFile jsFile = (JSFile)psiFile;
            QUnitFileStructureBuilder builder = QUnitFileStructureBuilder.getInstance();
            QUnitFileStructure qunitFileStructure = (QUnitFileStructure)builder.fetchCachedTestFileStructure(jsFile);
            PsiElement element = qunitFileStructure.findPsiElement(moduleName, testName);
            if (element == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static PsiElement findExportsElement(@NotNull Project project, @NotNull List<String> location) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "findExportsElement"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "findExportsElement"));
        }
        JSFile file = MochaTestLocationProvider.findJSFile(project, location);
        if (file == null) {
            return null;
        }
        ExportsTestFileStructure structure = (ExportsTestFileStructure)ExportsTestFileStructureBuilder.getInstance().fetchCachedTestFileStructure(file);
        List<String> path = location.subList(1, location.size());
        return structure.findPsiElement(path);
    }

    @Nullable
    private static PsiElement findTddElement(@NotNull Project project, @NotNull List<String> location, boolean suite) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "findTddElement"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "findTddElement"));
        }
        VirtualFile executedFile = LocalFileSystem.getInstance().findFileByPath(location.get(0));
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        List<String> names = location.subList(1, location.size());
        JsTestFqn testFqn = new JsTestFqn(JSTestFileType.TDD, names);
        List jsTestVirtualFiles = JsTestFileByTestNameIndex.findFiles((JsTestFqn)testFqn, (GlobalSearchScope)scope, (VirtualFile)executedFile);
        for (VirtualFile file : jsTestVirtualFiles) {
            String testName;
            List<String> suiteNames;
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (!(psiFile instanceof JSFile)) continue;
            JSFile jsFile = (JSFile)psiFile;
            MochaTddFileStructure structure = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
            PsiElement element = structure.findPsiElement(suiteNames = suite ? names : names.subList(0, names.size() - 1), testName = suite ? null : (String)ContainerUtil.getLastItem(names));
            if (element == null || !element.isValid()) continue;
            return element;
        }
        return null;
    }

    @Nullable
    private static JSFile findJSFile(@NotNull Project project, @NotNull List<String> location) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "findJSFile"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/nodejs/mocha/execution/MochaTestLocationProvider", "findJSFile"));
        }
        String filePath = location.get(0);
        if (StringUtil.isEmptyOrSpaces((String)filePath)) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (file == null || !file.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        return (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class);
    }
}

