/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.actionSystem.AnAction;
import com.jetbrains.nodeJs.NodeDebugProgramRunnerKt;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitExecutionUtils;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestLocationProvider;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import com.jetbrains.nodejs.util.NodeJsCodeLocator;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class NodeunitRunProfileState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private final ExecutionEnvironment myEnvironment;
    private final NodeunitSettings mySettings;

    protected NodeunitRunProfileState(@NotNull ExecutionEnvironment environment, @NotNull NodeunitSettings settings) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunProfileState", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunProfileState", "<init>"));
        }
        this.myEnvironment = environment;
        this.mySettings = settings;
    }

    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        NodeJsInterpreter interpreter = this.mySettings.getInterpreterRef().resolve(this.myEnvironment.getProject());
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.castAndValidate((NodeJsInterpreter)interpreter);
        ProcessHandler processHandler = this.startProcess(localInterpreter, debugPort);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        File workingDir = new File(this.mySettings.getWorkingDirectory());
        NodeunitTestLocationProvider locator = new NodeunitTestLocationProvider(workingDir);
        ConsoleView consoleView = NodeunitExecutionUtils.createConsole(processHandler, this.myEnvironment, locator);
        consoleView.addMessageFilter((Filter)new NodeStackTraceFilter(this.myEnvironment.getProject(), workingDir));
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myEnvironment.getProject(), workingDir));
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler);
        executionResult.setRestartActions(new AnAction[]{new ToggleAutoTestAction()});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunProfileState", "execute"));
        }
        return defaultExecutionResult;
    }

    @NotNull
    private ProcessHandler startProcess(@NotNull NodeJsLocalInterpreter interpreter, int debugPort) throws ExecutionException {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunProfileState", "startProcess"));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        this.mySettings.getEnvData().configureCommandLine(commandLine, true);
        commandLine.withWorkDirectory(this.mySettings.getWorkingDirectory());
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        NodeCommandLineUtil.addDebugParameters((GeneralCommandLine)commandLine, (int)debugPort);
        File mainFile = NodeunitRunProfileState.getNodeunitMainFile();
        commandLine.addParameter(mainFile.getAbsolutePath());
        commandLine.addParameter(this.mySettings.getNodeunitPackageDir());
        NodeunitTestType testType = this.mySettings.getTestType();
        if (testType == NodeunitTestType.DIRECTORY) {
            commandLine.addParameter(this.mySettings.getDirectory());
        } else {
            commandLine.addParameter(this.mySettings.getJsFile());
        }
        ProcessHandler processHandler = NodeDebugProgramRunnerKt.createProcessHandler((GeneralCommandLine)commandLine);
        if (processHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunProfileState", "startProcess"));
        }
        return processHandler;
    }

    @NotNull
    public static File getNodeunitMainFile() throws ExecutionException {
        File file;
        String relativePath = "nodeunit/nodeunit-intellij-starter.js";
        try {
            file = NodeJsCodeLocator.getFileRelativeToJsDir(relativePath);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot find " + relativePath, (Throwable)e);
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunProfileState", "getNodeunitMainFile"));
        }
        return file;
    }
}

