/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import org.jetbrains.annotations.NotNull;

public class NodeunitSettings {
    private final NodeJsInterpreterRef myInterpreterRef;
    private final EnvironmentVariablesData myEnvData;
    private final String myNodeunitPackageDir;
    private final String myWorkingDirectory;
    private final NodeunitTestType myTestType;
    private final String myDirectory;
    private final String myJsFile;
    private final String myTestName;

    public NodeunitSettings(@NotNull Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings", "<init>"));
        }
        this.myInterpreterRef = builder.myInterpreterRef;
        this.myEnvData = builder.myEnvData;
        this.myNodeunitPackageDir = FileUtil.toSystemIndependentName((String)builder.myNodeunitPackageDir);
        this.myWorkingDirectory = FileUtil.toSystemIndependentName((String)builder.myWorkingDirectory);
        this.myTestType = builder.myTestType;
        this.myDirectory = FileUtil.toSystemIndependentName((String)builder.myDirectory);
        this.myJsFile = FileUtil.toSystemIndependentName((String)builder.myJsFile);
        this.myTestName = builder.myTestName;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings", "getInterpreterRef"));
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings", "getEnvData"));
        }
        return environmentVariablesData;
    }

    @NotNull
    public String getNodeunitPackageDir() {
        String string = this.myNodeunitPackageDir;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings", "getNodeunitPackageDir"));
        }
        return string;
    }

    @NotNull
    public String getWorkingDirectory() {
        String string = this.myWorkingDirectory;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings", "getWorkingDirectory"));
        }
        return string;
    }

    @NotNull
    public NodeunitTestType getTestType() {
        NodeunitTestType nodeunitTestType = this.myTestType;
        if (nodeunitTestType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings", "getTestType"));
        }
        return nodeunitTestType;
    }

    @NotNull
    public String getDirectory() {
        String string = this.myDirectory;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings", "getDirectory"));
        }
        return string;
    }

    @NotNull
    public String getJsFile() {
        String string = this.myJsFile;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings", "getJsFile"));
        }
        return string;
    }

    @NotNull
    public String getTestName() {
        String string = this.myTestName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings", "getTestName"));
        }
        return string;
    }

    @NotNull
    public Builder builder() {
        Builder builder = new Builder(this);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings", "builder"));
        }
        return builder;
    }

    public static class Builder {
        private NodeJsInterpreterRef myInterpreterRef;
        private EnvironmentVariablesData myEnvData;
        private String myNodeunitPackageDir;
        private String myWorkingDirectory;
        private NodeunitTestType myTestType;
        private String myDirectory;
        private String myJsFile;
        private String myTestName;

        public Builder() {
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNodeunitPackageDir = "";
            this.myWorkingDirectory = "";
            this.myTestType = NodeunitTestType.JS_FILE;
            this.myDirectory = "";
            this.myJsFile = "";
            this.myTestName = "";
        }

        public Builder(@NotNull NodeunitSettings settings) {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "<init>"));
            }
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNodeunitPackageDir = "";
            this.myWorkingDirectory = "";
            this.myTestType = NodeunitTestType.JS_FILE;
            this.myDirectory = "";
            this.myJsFile = "";
            this.myTestName = "";
            this.myInterpreterRef = settings.getInterpreterRef();
            this.myEnvData = settings.getEnvData();
            this.myNodeunitPackageDir = settings.getNodeunitPackageDir();
            this.myWorkingDirectory = settings.getWorkingDirectory();
            this.myTestType = settings.getTestType();
            this.myDirectory = settings.getDirectory();
            this.myJsFile = settings.getJsFile();
            this.myTestName = settings.getTestName();
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreterRef", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setInterpreterRef"));
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setInterpreterRef"));
            }
            return builder;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envData", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setEnvData"));
            }
            this.myEnvData = envData;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setEnvData"));
            }
            return builder;
        }

        @NotNull
        public Builder setNodeunitPackageDir(@NotNull String nodeunitPackageDir) {
            if (nodeunitPackageDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeunitPackageDir", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setNodeunitPackageDir"));
            }
            this.myNodeunitPackageDir = nodeunitPackageDir;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setNodeunitPackageDir"));
            }
            return builder;
        }

        @NotNull
        public Builder setTestType(@NotNull NodeunitTestType testType) {
            if (testType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testType", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setTestType"));
            }
            this.myTestType = testType;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setTestType"));
            }
            return builder;
        }

        @NotNull
        public Builder setWorkingDirectory(@NotNull String workingDirectory) {
            if (workingDirectory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirectory", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setWorkingDirectory"));
            }
            this.myWorkingDirectory = workingDirectory;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setWorkingDirectory"));
            }
            return builder;
        }

        @NotNull
        public Builder setDirectory(@NotNull String directory) {
            if (directory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setDirectory"));
            }
            this.myDirectory = directory;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setDirectory"));
            }
            return builder;
        }

        @NotNull
        public Builder setJsFilePath(@NotNull String jsFile) {
            if (jsFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setJsFilePath"));
            }
            this.myJsFile = jsFile;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setJsFilePath"));
            }
            return builder;
        }

        @NotNull
        public Builder setTest(@NotNull String testName) {
            if (testName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testName", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setTest"));
            }
            this.myTestName = testName;
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "setTest"));
            }
            return builder;
        }

        @NotNull
        public NodeunitSettings build() {
            NodeunitSettings nodeunitSettings = new NodeunitSettings(this);
            if (nodeunitSettings == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitSettings$Builder", "build"));
            }
            return nodeunitSettings;
        }
    }
}

