/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.testFramework.exports.ExportsTestFileStructure;
import com.intellij.javascript.testFramework.exports.ExportsTestFileStructureBuilder;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeunitTestLocationProvider
implements SMTestLocator {
    private static final Logger LOG = Logger.getInstance(NodeunitTestLocationProvider.class);
    private static final String PROTOCOL = "nodeunit";
    private final File myWorkingDirectory;

    public NodeunitTestLocationProvider(@NotNull File workingDirectory) {
        if (workingDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDirectory", "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider", "<init>"));
        }
        this.myWorkingDirectory = workingDirectory;
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocol", "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider", "getLocation"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider", "getLocation"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider", "getLocation"));
        }
        if (!PROTOCOL.equals(protocol)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider", "getLocation"));
            }
            return list;
        }
        List<String> parts = NodeunitTestLocationProvider.decodePath(path);
        if (parts.isEmpty()) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider", "getLocation"));
            }
            return list;
        }
        JSFile jsFile = this.findJSFile(project, parts.get(0));
        if (jsFile == null) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider", "getLocation"));
            }
            return list;
        }
        ExportsTestFileStructure structure = (ExportsTestFileStructure)ExportsTestFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        PsiElement testPsiElement = structure.findPsiElement(parts.subList(1, parts.size()));
        PsiElement navResult = (PsiElement)ObjectUtils.notNull((Object)testPsiElement, (Object)jsFile);
        Location psiLocation = PsiLocation.fromPsiElement((PsiElement)navResult);
        List<Location> list = Collections.singletonList(psiLocation);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider", "getLocation"));
        }
        return list;
    }

    @Nullable
    private JSFile findJSFile(@NotNull Project project, @NotNull String moduleName) {
        File file;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider", "findJSFile"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider", "findJSFile"));
        }
        if (!moduleName.endsWith(".js")) {
            moduleName = moduleName + ".js";
        }
        if ((file = new File(this.myWorkingDirectory, moduleName)).isFile()) {
            VirtualFile jsVFile = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (jsVFile == null || !jsVFile.exists()) {
                jsVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            }
            if (jsVFile != null && jsVFile.exists()) {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                PsiFile psiFile = psiManager.findFile(jsVFile);
                return (JSFile)ObjectUtils.tryCast((Object)psiFile, JSFile.class);
            }
        }
        return null;
    }

    private static List<String> decodePath(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/nodejs/nodeunit/execution/NodeunitTestLocationProvider", "decodePath"));
        }
        ArrayList path = ContainerUtil.newArrayList();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == ':') {
                char nextChar;
                int j = i + 1;
                boolean ok = false;
                if (j < s.length() && ((nextChar = s.charAt(j)) == ',' || nextChar == ':')) {
                    builder.append(nextChar);
                    ++i;
                    ok = true;
                }
                if (ok) continue;
                LOG.warn("Found malformed nodeunit locationHint data '" + s + "' at index " + i + ".");
                return Collections.emptyList();
            }
            if (ch == ',') {
                path.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            builder.append(ch);
        }
        path.add(builder.toString());
        return path;
    }
}

