/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ObjectUtils;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.ui.Context;
import com.jetbrains.nodejs.nodeunit.execution.ui.SettingsController;
import com.jetbrains.nodejs.nodeunit.execution.ui.SettingsControllerFactory;
import com.jetbrains.nodejs.util.RelativePathUIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

class DirectorySettingsController
implements SettingsController {
    public static final SettingsControllerFactory FACTORY = new SettingsControllerFactory(){

        @Override
        @NotNull
        public SettingsController createSettingsController(@NotNull Context context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/nodejs/nodeunit/execution/ui/DirectorySettingsController$1", "createSettingsController"));
            }
            DirectorySettingsController directorySettingsController = new DirectorySettingsController(context);
            if (directorySettingsController == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/DirectorySettingsController$1", "createSettingsController"));
            }
            return directorySettingsController;
        }
    };
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final TextFieldWithBrowseButton myDirectoryTextFieldWithBrowseButton;

    public DirectorySettingsController(@NotNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/nodejs/nodeunit/execution/ui/DirectorySettingsController", "<init>"));
        }
        this.myPanel = new JPanel(new GridBagLayout());
        JBLabel directoryLabel = new JBLabel("Directory:");
        directoryLabel.setAnchor(context.getAnchor());
        this.myPanel.add((Component)directoryLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 0, 0, 10), 0, 0));
        JTextField workingDirectory = (JTextField)ObjectUtils.assertNotNull((Object)context.getWorkingDirectory());
        FileChooserDescriptor directoryDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myDirectoryTextFieldWithBrowseButton = RelativePathUIUtil.createRelativePathTextFieldAndTrackBaseDirChanges(context.getProject(), directoryDescriptor, workingDirectory.getDocument());
        this.myDirectoryTextFieldWithBrowseButton.addBrowseFolderListener("Select a directory with tests", null, context.getProject(), directoryDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myPanel.add((Component)this.myDirectoryTextFieldWithBrowseButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 0, 0, 0), 0, 0));
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/DirectorySettingsController", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void resetFrom(@NotNull NodeunitSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/nodeunit/execution/ui/DirectorySettingsController", "resetFrom"));
        }
        this.myDirectoryTextFieldWithBrowseButton.setText(settings.getDirectory());
    }

    @Override
    public void applyTo(@NotNull NodeunitSettings.Builder settingsBuilder) {
        if (settingsBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsBuilder", "com/jetbrains/nodejs/nodeunit/execution/ui/DirectorySettingsController", "applyTo"));
        }
        settingsBuilder.setDirectory(this.myDirectoryTextFieldWithBrowseButton.getText());
    }
}

