/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitRunConfiguration;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.ui.Context;
import com.jetbrains.nodejs.nodeunit.execution.ui.RootSettingsController;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NodeunitSettingsEditor
extends SettingsEditor<NodeunitRunConfiguration> {
    @NotNull
    private final RootSettingsController myRoot;

    public NodeunitSettingsEditor(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/nodeunit/execution/ui/NodeunitSettingsEditor", "<init>"));
        }
        this.myRoot = new RootSettingsController(new Context(project));
    }

    protected void resetEditorFrom(@NotNull NodeunitRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/nodeunit/execution/ui/NodeunitSettingsEditor", "resetEditorFrom"));
        }
        NodeunitSettings settings = runConfiguration.getSettings();
        this.myRoot.resetFrom(settings);
    }

    protected void applyEditorTo(@NotNull NodeunitRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/nodeunit/execution/ui/NodeunitSettingsEditor", "applyEditorTo"));
        }
        NodeunitSettings.Builder builder = new NodeunitSettings.Builder();
        this.myRoot.applyTo(builder);
        runConfiguration.setSettings(builder.build());
    }

    @NotNull
    protected JComponent createEditor() {
        JComponent jComponent = this.myRoot.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/nodeunit/execution/ui/NodeunitSettingsEditor", "createEditor"));
        }
        return jComponent;
    }
}

