/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packageJson;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.packages.NpmRegistryService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsPackageDocumentation {
    private final String myPackageName;
    private final String myDescription;
    private final String myReadmeHtml;

    public NodeJsPackageDocumentation(@NotNull String packageName, @Nullable String description, @Nullable String readmeHtml) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocumentation", "<init>"));
        }
        this.myPackageName = packageName;
        this.myDescription = description;
        this.myReadmeHtml = readmeHtml;
    }

    @NotNull
    public String getQuickInfoHtml() {
        String string = this.getQuickInfoHtml(this.myDescription);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocumentation", "getQuickInfoHtml"));
        }
        return string;
    }

    @NotNull
    private String getQuickInfoHtml(@Nullable String description) {
        List<Pair<String, SemVer>> tags = NpmRegistryService.getInstance().getCachedPackageDistTags(this.myPackageName);
        if (tags != null) {
            SemVer latest = null;
            for (Pair<String, SemVer> tag : tags) {
                if (!((String)tag.getFirst()).equals("latest")) continue;
                latest = (SemVer)tag.getSecond();
                break;
            }
            String string = NodeJsPackageDocumentation.html(this.myPackageName, true, latest != null ? latest.getRawVersion() : "", description);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocumentation", "getQuickInfoHtml"));
            }
            return string;
        }
        NpmRegistryService.getInstance().asyncUpdatePackageDistTags(this.myPackageName);
        String string = NodeJsPackageDocumentation.html(this.myPackageName, true, null, description);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocumentation", "getQuickInfoHtml"));
        }
        return string;
    }

    @NotNull
    private static String html(@NotNull String packageName, boolean showLatestVersion, @Nullable String latestVersion, @Nullable String description) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocumentation", "html"));
        }
        if (showLatestVersion) {
            if (latestVersion == null) {
                latestVersion = "loading...";
            } else if (StringUtil.isEmptyOrSpaces((String)latestVersion)) {
                latestVersion = "n/a";
            }
            latestVersion = "Latest version: " + latestVersion;
        } else {
            latestVersion = null;
        }
        JBColor latestVersionColor = new JBColor((Color)Gray.get((int)96), (Color)Gray.get((int)160));
        String string = "<table cellspacing='0' cellpadding='0' style='border: none;'> <tr>  <td style='text-align:left'><b>" + StringEscapeUtils.escapeXml((String)packageName) + "</b></td>" + (latestVersion == null ? "" : "  <td style='width:20px'></td>  <td style='text-align:right'>    <div style='color:#" + ColorUtil.toHex((Color)latestVersionColor) + ";'>" + StringEscapeUtils.escapeXml((String)latestVersion) + "    </div>  </td>") + " </tr>" + (StringUtil.isEmptyOrSpaces((String)description) ? "" : " <tr>  <td colspan='3' style='white-space:nowrap'>" + StringEscapeUtils.escapeXml((String)description) + "</td> </tr>") + "</table>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocumentation", "html"));
        }
        return string;
    }

    @NotNull
    private String getBodyHtml() {
        if (this.myReadmeHtml != null) {
            String prefix = "<h1>" + this.myPackageName + "</h1>";
            if (StringUtil.startsWithIgnoreCase((String)this.myReadmeHtml, (String)prefix)) {
                String string = this.getQuickInfoHtml(null) + this.myReadmeHtml.substring(prefix.length());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocumentation", "getBodyHtml"));
                }
                return string;
            }
            String string = this.myReadmeHtml;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocumentation", "getBodyHtml"));
            }
            return string;
        }
        String string = this.getQuickInfoHtml();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocumentation", "getBodyHtml"));
        }
        return string;
    }

    @NotNull
    public String getFullDocHtml() {
        String html = this.getBodyHtml();
        HintHint hintHint = new HintHint((Component)null, new Point(0, 0));
        String string = SwingHelper.buildHtml((String)UIUtil.getCssFontDeclaration((Font)hintHint.getTextFont(), (Color)hintHint.getTextForeground(), (Color)hintHint.getLinkForeground(), (String)hintHint.getUlImg()), (String)html);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/NodeJsPackageDocumentation", "getFullDocHtml"));
        }
        return string;
    }
}

