/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packageJson;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.DispreferLiveTemplates;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.codeinsight.JsonStringPropertyInsertHandler;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.packageJson.popularPackages.PopularNodePackagesProvider;
import com.jetbrains.nodejs.packages.NodePackageBasicInfo;
import com.jetbrains.nodejs.packages.NpmRegistryService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance(PackageJsonCompletionContributor.class);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "fillCompletionVariants"));
        }
        if (PackageJsonUtil.isInsidePackageJsonFile((PsiElement)parameters.getOriginalFile())) {
            PackageJsonCompletionContributor.completeDependencies(parameters, result);
        }
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "invokeAutoPopup"));
        }
        if (PackageJsonUtil.isInsidePackageJsonFile((PsiElement)position) && !Character.isWhitespace(typeChar) && typeChar != ',') {
            PsiElement at = position;
            if (at.getNode().getElementType() == JsonElementTypes.COMMA) {
                at = at.getPrevSibling();
            }
            if (at instanceof PsiWhiteSpace) {
                at = at.getPrevSibling();
            }
            JsonProperty property = at != null ? PackageJsonUtil.findContainingProperty((PsiElement)at) : null;
            return property != null && PackageJsonUtil.isPackageDependencyProperty((JsonProperty)property);
        }
        return false;
    }

    private static void completeDependencies(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "completeDependencies"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "completeDependencies"));
        }
        JsonProperty dependencyProperty = PackageJsonUtil.findContainingProperty((PsiElement)parameters.getPosition());
        if (dependencyProperty != null && PackageJsonUtil.isPackageDependencyProperty((JsonProperty)dependencyProperty)) {
            CompletionSorter sorter = CompletionSorter.emptySorter().weigh((LookupElementWeigher)new DispreferLiveTemplates()).weigh(new LookupElementWeigher("priority"){

                @NotNull
                public Double weigh(@NotNull LookupElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor$1", "weigh"));
                    }
                    PrioritizedLookupElement ple = (PrioritizedLookupElement)ObjectUtils.tryCast((Object)element, PrioritizedLookupElement.class);
                    Double d = ple != null ? ple.getPriority() : 0.0;
                    if (d == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor$1", "weigh"));
                    }
                    return d;
                }
            });
            result = result.withRelevanceSorter(sorter);
            JsonValue nameElement = dependencyProperty.getNameElement();
            if (nameElement.getTextRange().containsOffset(parameters.getOffset())) {
                String prefix = PackageJsonCompletionContributor.findPrefix(parameters, (PsiElement)nameElement);
                result = result.withPrefixMatcher(prefix);
                PackageJsonCompletionContributor.completeDependenciesNames(parameters, result, prefix);
            } else {
                String packageName = StringUtil.unquoteString((String)nameElement.getText());
                PackageJsonCompletionContributor.completeDependenciesVersions(parameters, result, packageName);
            }
        }
    }

    private static void completeDependenciesNames(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull String packageNamePrefix) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "completeDependenciesNames"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "completeDependenciesNames"));
        }
        if (packageNamePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNamePrefix", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "completeDependenciesNames"));
        }
        Set<String> alreadyUsedNames = PackageJsonCompletionContributor.getUsedPackageNames(parameters);
        List<NodePackageBasicInfo> popularPackages = PopularNodePackagesProvider.getInstance().findByPrefix(packageNamePrefix, packageNamePrefix.isEmpty() ? 20 : 10, (Condition<NodePackageBasicInfo>)((Condition)info -> !alreadyUsedNames.contains(info.getName())));
        AtomicInteger priority = new AtomicInteger(0);
        for (NodePackageBasicInfo pkg : popularPackages) {
            PackageJsonCompletionContributor.addPackageInfo(parameters, result, pkg, priority.getAndIncrement());
        }
        if (!packageNamePrefix.isEmpty()) {
            Set popularNames = ContainerUtil.map2Set(popularPackages, NodePackageBasicInfo::getName);
            PackageJsonCompletionContributor.findPackagesInRegistryByPrefix(packageNamePrefix, 10, (Condition<NodePackageBasicInfo>)((Condition)info -> !alreadyUsedNames.contains(info.getName()) && !popularNames.contains(info.getName())), (Consumer<NodePackageBasicInfo>)((Consumer)info -> {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "lambda$completeDependenciesNames$2"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "lambda$completeDependenciesNames$2"));
                }
                PackageJsonCompletionContributor.addPackageInfo(parameters, result, info, priority.getAndIncrement());
            }));
        }
        result.restartCompletionOnAnyPrefixChange();
        result.addLookupAdvertisement("Start typing package name to get more specific results from the official public npm registry");
    }

    private static boolean isInsideStringLiteral(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "isInsideStringLiteral"));
        }
        return parameters.getPosition().getParent() instanceof JsonStringLiteral;
    }

    private static void completeDependenciesVersions(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull String packageName) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "completeDependenciesVersions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "completeDependenciesVersions"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "completeDependenciesVersions"));
        }
        result = result.withPrefixMatcher((PrefixMatcher)new MyPlainPrefixMatcher(PackageJsonCompletionContributor.findPrefix(parameters, parameters.getPosition())));
        List<Pair<String, SemVer>> distTags = PackageJsonCompletionContributor.fetchPackageDistTags(packageName);
        int order = 0;
        String[] versionPrefixes = PackageJsonCompletionContributor.getSortedVersionPrefixes(parameters);
        for (Pair<String, SemVer> tag : distTags) {
            for (String versionPrefix : versionPrefixes) {
                PackageJsonCompletionContributor.addDistTagCompletionItem(parameters, result, versionPrefix, (SemVer)tag.getSecond(), (String)tag.getFirst(), order++);
            }
        }
        if (distTags.size() > 0) {
            result.addLookupAdvertisement("Latest available versions for all distribution tags");
        }
    }

    @NotNull
    private static String[] getSortedVersionPrefixes(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "getSortedVersionPrefixes"));
        }
        Object[] prefixes = new String[]{"^", "~", ""};
        PsiElement position = parameters.getOriginalPosition();
        if (position != null) {
            int ind;
            String currentPrefix;
            String text = StringUtil.trimStart((String)StringUtil.unquoteString((String)position.getText()), (String)"\"");
            String string = currentPrefix = text.isEmpty() ? "^" : text.substring(0, 1);
            if (!currentPrefix.isEmpty() && Character.isDigit(currentPrefix.charAt(0))) {
                currentPrefix = "";
            }
            if ((ind = ArrayUtil.find((Object[])prefixes, (Object)currentPrefix)) > 0) {
                ArrayUtil.rotateRight((Object[])prefixes, (int)0, (int)ind);
            }
        }
        if (prefixes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "getSortedVersionPrefixes"));
        }
        return prefixes;
    }

    private static void addPackageInfo(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, final @NotNull NodePackageBasicInfo info, int priority) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "addPackageInfo"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "addPackageInfo"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "addPackageInfo"));
        }
        String lookupString = info.getName() + " ";
        if (!PackageJsonCompletionContributor.isInsideStringLiteral(parameters)) {
            lookupString = StringUtil.wrapWithDoubleQuote((String)lookupString);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((Object)info, (String)lookupString);
        builder = builder.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(info.getName());
                presentation.setTypeGrayed(true);
                presentation.setTypeText(info.getDescription());
            }
        }).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(info.getName()));
        result.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)priority));
    }

    private static void addDistTagCompletionItem(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, final @NotNull String versionPrefix, @NotNull SemVer version, final @Nullable String distTagName, int order) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "addDistTagCompletionItem"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "addDistTagCompletionItem"));
        }
        if (versionPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionPrefix", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "addDistTagCompletionItem"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "addDistTagCompletionItem"));
        }
        final String value = versionPrefix + version.getRawVersion();
        LookupElementBuilder builder = PackageJsonCompletionContributor.isInsideStringLiteral(parameters) ? LookupElementBuilder.create((Object)version, (String)value) : LookupElementBuilder.create((Object)version, (String)StringUtil.wrapWithDoubleQuote((String)value)).withLookupString(value);
        builder = builder.withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                presentation.setItemText(versionPrefix.isEmpty() ? " " + value : value);
                presentation.setTypeGrayed(true);
                presentation.setTypeText(distTagName);
            }
        }).withInsertHandler((InsertHandler)new JsonStringPropertyInsertHandler(value));
        result.addElement(PrioritizedLookupElement.withPriority((LookupElement)builder.withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE), (double)order));
    }

    private static void findPackagesInRegistryByPrefix(@NotNull String prefix, int limit, @NotNull Condition<NodePackageBasicInfo> filter, @NotNull Consumer<NodePackageBasicInfo> consumer) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "findPackagesInRegistryByPrefix"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "findPackagesInRegistryByPrefix"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "findPackagesInRegistryByPrefix"));
        }
        try {
            NpmRegistryService.getInstance().findPackagesByPrefix(ProgressManager.getInstance().getProgressIndicator(), prefix, limit, filter, consumer);
        }
        catch (ProcessCanceledException e) {
            LOG.info("Fetching '" + prefix + "*' packages from registry cancelled");
        }
        catch (IOException e) {
            LOG.info("Cannot fetch '" + prefix + "*' packages from registry", (Throwable)e);
        }
    }

    @NotNull
    private static List<Pair<String, SemVer>> fetchPackageDistTags(@NotNull String packageName) {
        List list;
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "fetchPackageDistTags"));
        }
        try {
            list = (List)ApplicationUtil.runWithCheckCanceled(() -> {
                if (packageName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "lambda$fetchPackageDistTags$3"));
                }
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                return NpmRegistryService.getInstance().getCachedOrFetchPackageDistTags(packageName, indicator);
            }, (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator()));
        }
        catch (ProcessCanceledException e) {
            LOG.info("Fetching dist-tags for " + packageName + " cancelled");
            List<Pair<String, SemVer>> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "fetchPackageDistTags"));
            }
            return list2;
        }
        catch (Exception e) {
            LOG.info("Cannot fetch dist-tags for " + packageName, (Throwable)e);
            List<Pair<String, SemVer>> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "fetchPackageDistTags"));
            }
            return list3;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "fetchPackageDistTags"));
        }
        return list;
    }

    @NotNull
    private static String findPrefix(@NotNull CompletionParameters parameters, @NotNull PsiElement element) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "findPrefix"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "findPrefix"));
        }
        String name = element.getText();
        int prefixLength = Math.min(name.length(), parameters.getOffset() - element.getTextRange().getStartOffset());
        String string = StringUtil.trimStart((String)StringUtil.unquoteString((String)name.substring(0, prefixLength)), (String)"\"");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "findPrefix"));
        }
        return string;
    }

    @NotNull
    private static Set<String> getUsedPackageNames(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "getUsedPackageNames"));
        }
        PsiElement position = parameters.getPosition();
        JsonProperty currentProperty = PackageJsonUtil.findContainingProperty((PsiElement)position);
        JsonFile file = (JsonFile)ObjectUtils.tryCast((Object)position.getContainingFile(), JsonFile.class);
        if (file == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "getUsedPackageNames"));
            }
            return set;
        }
        List props = PackageJsonUtil.listAllPackageProperties((JsonFile)file);
        HashSet<String> usedNames = new HashSet<String>();
        for (JsonProperty prop : props) {
            if (prop == currentProperty) continue;
            usedNames.add(prop.getName());
        }
        HashSet<String> hashSet = usedNames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor", "getUsedPackageNames"));
        }
        return hashSet;
    }

    public static class MyPlainPrefixMatcher
    extends PrefixMatcher {
        public MyPlainPrefixMatcher(@NotNull String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor$MyPlainPrefixMatcher", "<init>"));
            }
            super(prefix);
        }

        public boolean isStartMatch(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor$MyPlainPrefixMatcher", "isStartMatch"));
            }
            return StringUtil.startsWithIgnoreCase((String)name, (String)this.getPrefix());
        }

        public boolean prefixMatches(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor$MyPlainPrefixMatcher", "prefixMatches"));
            }
            return StringUtil.startsWithIgnoreCase((String)name, (String)this.getPrefix());
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor$MyPlainPrefixMatcher", "cloneWithPrefix"));
            }
            MyPlainPrefixMatcher myPlainPrefixMatcher = new MyPlainPrefixMatcher(prefix);
            if (myPlainPrefixMatcher == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonCompletionContributor$MyPlainPrefixMatcher", "cloneWithPrefix"));
            }
            return myPlainPrefixMatcher;
        }
    }

    public static class DependencyCharFilter
    extends CharFilter {
        @Nullable
        public CharFilter.Result acceptChar(char c, int prefixLength, Lookup lookup) {
            if (!lookup.isCompletion()) {
                return null;
            }
            PsiElement element = lookup.getPsiElement();
            if (element != null && JsonLanguage.INSTANCE.equals(element.getLanguage())) {
                if (StringUtil.containsChar((String)"@/-.^~", (char)c)) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
                if (c == '\"' && element instanceof PsiWhiteSpace) {
                    return CharFilter.Result.ADD_TO_PREFIX;
                }
                if (c == ',') {
                    return prefixLength == 0 ? CharFilter.Result.HIDE_LOOKUP : CharFilter.Result.SELECT_ITEM_AND_FINISH_LOOKUP;
                }
            }
            return null;
        }
    }
}

