/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packageJson;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.HintHint;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.packageJson.NodeJsPackageDocUtil;
import com.jetbrains.nodejs.packageJson.NodeJsPackageDocumentation;
import com.jetbrains.nodejs.packageJson.PackageJsonEntries;
import com.jetbrains.nodejs.packageJson.PackageJsonEntry;
import com.jetbrains.nodejs.packages.NodePackageInfo;
import com.jetbrains.nodejs.packages.NodePackageUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider {
    private static final String URL_PREFIX = "https://www.npmjs.com/package/";

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return originalElement != null ? PackageJsonDocumentationProvider.doGetQuickNavigateInfo(originalElement) : null;
    }

    @Nullable
    private static String doGetQuickNavigateInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/packageJson/PackageJsonDocumentationProvider", "doGetQuickNavigateInfo"));
        }
        JsonProperty property = PackageJsonUtil.findContainingProperty((PsiElement)element);
        if (property != null) {
            PackageJsonEntry entry;
            if (PackageJsonUtil.isTopLevelProperty((JsonProperty)property) && (entry = PackageJsonEntries.findEntryByName(property.getName())) != null) {
                return entry.getShortDescription();
            }
            if (PackageJsonUtil.isPackageDependencyProperty((JsonProperty)property)) {
                String packageName = property.getName();
                VirtualFile packageDir = PackageJsonDocumentationProvider.findInstalledPackageDir((PsiElement)property, packageName);
                if (packageDir != null) {
                    NodeJsPackageDocumentation documentation = NodeJsPackageDocUtil.createByPackageDir(packageDir, false);
                    if (documentation != null) {
                        return documentation.getQuickInfoHtml();
                    }
                } else {
                    NodePackageInfo packageInfo = NodePackageUtil.loadCachedPackageInfo(packageName);
                    if (packageInfo != null) {
                        return new NodeJsPackageDocumentation(packageName, packageInfo.getDescription(), null).getQuickInfoHtml();
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return originalElement != null ? PackageJsonDocumentationProvider.doGetUrlFor(originalElement) : null;
    }

    @Nullable
    private static List<String> doGetUrlFor(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/packageJson/PackageJsonDocumentationProvider", "doGetUrlFor"));
        }
        JsonProperty property = PackageJsonUtil.findContainingProperty((PsiElement)element);
        if (property != null && PackageJsonUtil.isPackageDependencyProperty((JsonProperty)property)) {
            return Collections.singletonList(URL_PREFIX + property.getName());
        }
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        return originalElement != null ? this.doGenerateDoc(originalElement) : null;
    }

    @Nullable
    public String doGenerateDoc(@NotNull PsiElement element) {
        PackageJsonEntry entry;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/packageJson/PackageJsonDocumentationProvider", "doGenerateDoc"));
        }
        JsonProperty property = PackageJsonUtil.findContainingProperty((PsiElement)element);
        if (property != null && PackageJsonUtil.isTopLevelProperty((JsonProperty)property) && (entry = PackageJsonEntries.findEntryByName(property.getName())) != null) {
            return HintUtil.prepareHintText((String)entry.getHtmlFullDescription(), (HintHint)new HintHint());
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof PackageJsonEntry) {
            Project project;
            PackageJsonEntry entry = (PackageJsonEntry)object;
            Project project2 = project = psiManager != null ? psiManager.getProject() : null;
            if (project != null) {
                return PackageJsonDocumentationProvider.generateElement(project, entry);
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement generateElement(@NotNull Project project, @NotNull PackageJsonEntry entry) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/packageJson/PackageJsonDocumentationProvider", "generateElement"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/jetbrains/nodejs/packageJson/PackageJsonDocumentationProvider", "generateElement"));
        }
        String jsonText = "{" + StringUtil.wrapWithDoubleQuote((String)entry.getName()) + ":\"\"}";
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("package.json", (Language)JsonLanguage.INSTANCE, (CharSequence)jsonText);
        PsiElement[] topLevelChildren = psiFile.getChildren();
        JsonObject object = null;
        for (PsiElement child : topLevelChildren) {
            if (!(child instanceof JsonObject)) continue;
            object = (JsonObject)child;
            break;
        }
        if (object == null) {
            return null;
        }
        List properties = object.getPropertyList();
        for (JsonProperty property : properties) {
            if (!entry.getName().equals(property.getName())) continue;
            return property.getNameElement();
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    @Nullable
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        NodePackageInfo packageInfo;
        String packageName = PackageJsonDocumentationProvider.toPackageName(docUrls);
        if (packageName == null) {
            return null;
        }
        VirtualFile packageDir = (VirtualFile)ReadAction.compute(() -> {
            PsiElement elementAtCaret = PackageJsonDocumentationProvider.getElementAtCaret(element);
            return PackageJsonDocumentationProvider.findInstalledPackageDir(elementAtCaret, packageName);
        });
        if (packageDir != null) {
            NodeJsPackageDocumentation documentation = NodeJsPackageDocUtil.createByPackageDir(packageDir, true);
            if (documentation != null) {
                return documentation.getFullDocHtml();
            }
        } else if (project != null && (packageInfo = PackageJsonDocumentationProvider.loadPackageInfo(project, packageName)) != null) {
            return new NodeJsPackageDocumentation(packageName, packageInfo.getDescription(), null).getFullDocHtml();
        }
        return null;
    }

    @Nullable
    private static String toPackageName(@Nullable List<String> docUrls) {
        String url = (String)ContainerUtil.getFirstItem(docUrls);
        if (url != null && url.startsWith(URL_PREFIX)) {
            return url.substring(URL_PREFIX.length());
        }
        return null;
    }

    @Nullable
    private static PsiElement getElementAtCaret(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (PackageJsonUtil.isInsidePackageJsonFile((PsiElement)element)) {
            return element;
        }
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)element.getUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY);
        return pointer != null ? pointer.getElement() : null;
    }

    @Nullable
    private static NodePackageInfo loadPackageInfo(@NotNull Project project, @NotNull String packageName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/packageJson/PackageJsonDocumentationProvider", "loadPackageInfo"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packageJson/PackageJsonDocumentationProvider", "loadPackageInfo"));
        }
        NodePackageInfo packageInfo = NodePackageUtil.loadCachedPackageInfo(packageName);
        if (packageInfo != null) {
            return packageInfo;
        }
        NodeJsLocalInterpreter localInterpreter = PackageJsonDocumentationProvider.getLocalInterpreter(project);
        if (localInterpreter != null) {
            try {
                return NodePackageUtil.loadPackageInfo(localInterpreter, packageName, true, ProgressManager.getInstance().getProgressIndicator());
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static NodeJsLocalInterpreter getLocalInterpreter(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/packageJson/PackageJsonDocumentationProvider", "getLocalInterpreter"));
        }
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance((Project)project).getDefault();
        try {
            return NodeJsLocalInterpreter.castAndValidate((NodeJsInterpreter)interpreter);
        }
        catch (ExecutionException ignored) {
            return null;
        }
    }

    @Nullable
    private static VirtualFile findInstalledPackageDir(@Nullable PsiElement element, @NotNull String packageName) {
        VirtualFile packageDir;
        VirtualFile nodeModulesDir;
        VirtualFile file;
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packageJson/PackageJsonDocumentationProvider", "findInstalledPackageDir"));
        }
        JsonFile psiFile = element != null ? PackageJsonUtil.getContainingPackageJsonFile((PsiElement)element) : null;
        VirtualFile virtualFile = file = psiFile != null ? psiFile.getVirtualFile() : null;
        if (file != null && (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson((VirtualFile)file)) != null && nodeModulesDir.isValid() && nodeModulesDir.isDirectory() && (packageDir = nodeModulesDir.findFileByRelativePath(packageName)) != null && packageDir.isValid() && packageDir.isDirectory()) {
            return packageDir;
        }
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        JsonProperty property = originalElement != null ? PackageJsonUtil.findContainingProperty((PsiElement)originalElement) : null;
        return property != null && PackageJsonUtil.isPackageDependencyProperty((JsonProperty)property);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }
}

