/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packageJson;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.packageJson.PackageJsonEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PackageJsonEntries {
    private static final Logger LOG = Logger.getInstance(PackageJsonEntries.class);
    private final ImmutableList<PackageJsonEntry> myEntries;
    private final ImmutableMap<String, PackageJsonEntry> myEntryByNameMap;

    private PackageJsonEntries(@NotNull List<PackageJsonEntry> entries) {
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "<init>"));
        }
        this.myEntries = ImmutableList.copyOf(entries);
        HashMap entryByNameMap = Maps.newHashMapWithExpectedSize((int)entries.size());
        for (PackageJsonEntry entry : entries) {
            PackageJsonEntry oldEntry = entryByNameMap.put(entry.getName(), entry);
            if (oldEntry == null) continue;
            throw new RuntimeException("Duplicated package.json entry: " + entry.getName());
        }
        this.myEntryByNameMap = ImmutableMap.copyOf((Map)entryByNameMap);
    }

    @NotNull
    public static ImmutableList<PackageJsonEntry> getAllEntries() {
        ImmutableList<PackageJsonEntry> immutableList = Holder.INSTANCE.myEntries;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "getAllEntries"));
        }
        return immutableList;
    }

    @Nullable
    public static PackageJsonEntry findEntryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "findEntryByName"));
        }
        return (PackageJsonEntry)Holder.INSTANCE.myEntryByNameMap.get((Object)name);
    }

    @NotNull
    private static PackageJsonEntries parseFromXml() {
        PackageJsonEntries packageJsonEntries;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            String content = PackageJsonEntries.loadText();
            InputSource source = new InputSource(new StringReader(content));
            Document document = db.parse(source);
            packageJsonEntries = PackageJsonEntries.fromDocument(document);
        }
        catch (Exception e) {
            LOG.error("Can't parse package.json documentation :(", (Throwable)e);
            PackageJsonEntries packageJsonEntries2 = new PackageJsonEntries(Collections.emptyList());
            if (packageJsonEntries2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "parseFromXml"));
            }
            return packageJsonEntries2;
        }
        if (packageJsonEntries == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "parseFromXml"));
        }
        return packageJsonEntries;
    }

    @NotNull
    private static String loadText() throws IOException {
        InputStream in = PackageJsonEntries.class.getResourceAsStream("package-json-documentation.xml");
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        String string = FileUtil.loadTextAndClose((Reader)reader);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "loadText"));
        }
        return string;
    }

    @NotNull
    private static PackageJsonEntries fromDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "fromDocument"));
        }
        ArrayList entries = ContainerUtil.newArrayList();
        Element entriesElement = PackageJsonEntries.getTheOnlyChildElementWithTagName(document, "entries");
        List<Element> entryChildren = PackageJsonEntries.getChildElementsByTagName(entriesElement, "entry");
        for (Element entryElement : entryChildren) {
            PackageJsonEntry entry = PackageJsonEntries.createEntry(entryElement);
            List<String> aliases = PackageJsonEntries.createAliases(entryElement);
            entries.add(entry);
            for (String alias : aliases) {
                entries.add(new PackageJsonEntry(alias, entry.getShortDescription(), entry.getHtmlFullDescription()));
            }
        }
        PackageJsonEntries packageJsonEntries = new PackageJsonEntries(entries);
        if (packageJsonEntries == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "fromDocument"));
        }
        return packageJsonEntries;
    }

    @NotNull
    private static Element getTheOnlyChildElementWithTagName(@NotNull Node parentNode, @NotNull String childTagName) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "getTheOnlyChildElementWithTagName"));
        }
        if (childTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTagName", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "getTheOnlyChildElementWithTagName"));
        }
        List<Element> children = PackageJsonEntries.getChildElementsByTagName(parentNode, childTagName);
        if (children.size() != 1) {
            throw new RuntimeException("The only child is expected, but found: " + children.size());
        }
        Element element = children.get(0);
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "getTheOnlyChildElementWithTagName"));
        }
        return element;
    }

    @NotNull
    private static List<Element> getChildElementsByTagName(@NotNull Node parentNode, @NotNull String childTagName) {
        if (parentNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "getChildElementsByTagName"));
        }
        if (childTagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childTagName", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "getChildElementsByTagName"));
        }
        ArrayList children = ContainerUtil.newArrayList();
        NodeList nodeList = parentNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element childElement = (Element)ObjectUtils.tryCast((Object)nodeList.item(i), Element.class);
            if (childElement == null || !childTagName.equals(childElement.getTagName())) continue;
            children.add(childElement);
        }
        ArrayList arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "getChildElementsByTagName"));
        }
        return arrayList;
    }

    @NotNull
    private static PackageJsonEntry createEntry(@NotNull Element entryElement) {
        if (entryElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryElement", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "createEntry"));
        }
        String name = PackageJsonEntries.getMandatoryAttribute(entryElement, "name");
        Element shortDescriptionElement = PackageJsonEntries.getTheOnlyChildElementWithTagName(entryElement, "short-description");
        String shortDescription = shortDescriptionElement.getTextContent();
        Element fullDescriptionElement = PackageJsonEntries.getTheOnlyChildElementWithTagName(entryElement, "full-description");
        String fullHtmlDescription = fullDescriptionElement.getTextContent();
        if (!fullHtmlDescription.startsWith("<html>")) {
            fullHtmlDescription = "<html><body>" + fullHtmlDescription + "</body></html>";
        }
        PackageJsonEntry packageJsonEntry = new PackageJsonEntry(name, shortDescription, fullHtmlDescription);
        if (packageJsonEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "createEntry"));
        }
        return packageJsonEntry;
    }

    @NotNull
    private static List<String> createAliases(@NotNull Element entryElement) {
        if (entryElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryElement", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "createAliases"));
        }
        List<Element> aliasesElementList = PackageJsonEntries.getChildElementsByTagName(entryElement, "aliases");
        if (aliasesElementList.isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "createAliases"));
            }
            return list;
        }
        ArrayList aliases = ContainerUtil.newArrayList();
        for (Element aliasesElement : aliasesElementList) {
            List<Element> aliasElementList = PackageJsonEntries.getChildElementsByTagName(aliasesElement, "alias");
            for (Element aliasElement : aliasElementList) {
                aliases.add(aliasElement.getTextContent());
            }
        }
        ArrayList arrayList = aliases;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "createAliases"));
        }
        return arrayList;
    }

    @NotNull
    private static String getMandatoryAttribute(@NotNull Element element, @NotNull String attrName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "getMandatoryAttribute"));
        }
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "getMandatoryAttribute"));
        }
        String value = element.getAttribute(attrName);
        if (StringUtil.isEmpty((String)value)) {
            throw new RuntimeException("No '" + attrName + "' attribute!");
        }
        String string = value;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/PackageJsonEntries", "getMandatoryAttribute"));
        }
        return string;
    }

    static /* synthetic */ PackageJsonEntries access$100() {
        return PackageJsonEntries.parseFromXml();
    }

    private static class Holder {
        private static PackageJsonEntries INSTANCE = PackageJsonEntries.access$100();

        private Holder() {
        }
    }
}

