/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packageJson;

import com.intellij.ide.IdeView;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import icons.NodeJSIcons;
import org.jetbrains.annotations.Nullable;

public class PackageJsonNewFileAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(PackageJsonNewFileAction.class);

    public PackageJsonNewFileAction() {
        super("package.json File", "Creates a package.json file", NodeJSIcons.Nodejs_16);
    }

    public void actionPerformed(AnActionEvent e) {
        PsiDirectory psiDir = PackageJsonNewFileAction.getPsiDirectory(e);
        if (psiDir != null && psiDir.isValid()) {
            try {
                PackageJsonUtil.createPackageJson((PsiDirectory)psiDir, (boolean)true);
            }
            catch (RuntimeException ex) {
                LOG.error("Cannot create package.json", (Throwable)ex);
            }
        }
    }

    public void update(AnActionEvent e) {
        VirtualFile virtualDir;
        PsiDirectory psiDir;
        boolean available = false;
        Project project = e.getProject();
        if (project != null && (psiDir = PackageJsonNewFileAction.getPsiDirectory(e)) != null && psiDir.isValid() && (virtualDir = psiDir.getVirtualFile()).isValid() && virtualDir.isDirectory() && virtualDir.findChild("package.json") == null) {
            available = true;
        }
        e.getPresentation().setEnabledAndVisible(available);
    }

    @Nullable
    private static PsiDirectory getPsiDirectory(AnActionEvent e) {
        PsiDirectory[] directories;
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view != null && (directories = view.getDirectories()).length == 1) {
            return directories[0];
        }
        return null;
    }
}

