/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packageJson.popularPackages;

import com.google.gson.stream.JsonReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.reference.SoftReference;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.packages.NodePackageBasicInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PopularNodePackagesProvider {
    private static final Logger LOG = Logger.getInstance(PopularNodePackagesProvider.class);
    private static final String FILE_NAME = "popular-node-packages.json";
    private static final PopularNodePackagesProvider INSTANCE = new PopularNodePackagesProvider();
    private volatile WeakReference<List<NodePackageBasicInfo>> myInfosRef;

    @NotNull
    public static PopularNodePackagesProvider getInstance() {
        PopularNodePackagesProvider popularNodePackagesProvider = INSTANCE;
        if (popularNodePackagesProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/popularPackages/PopularNodePackagesProvider", "getInstance"));
        }
        return popularNodePackagesProvider;
    }

    @NotNull
    public List<NodePackageBasicInfo> findByPrefix(@NotNull String prefix, int limit, @NotNull Condition<NodePackageBasicInfo> filter) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/nodejs/packageJson/popularPackages/PopularNodePackagesProvider", "findByPrefix"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/jetbrains/nodejs/packageJson/popularPackages/PopularNodePackagesProvider", "findByPrefix"));
        }
        List<NodePackageBasicInfo> infos = (List<NodePackageBasicInfo>)SoftReference.dereference(this.myInfosRef);
        if (infos == null) {
            try {
                long startTime = System.nanoTime();
                infos = PopularNodePackagesProvider.parse();
                LOG.info("Popular node package list loaded in " + TimeoutUtil.getDurationMillis((long)startTime) + " ms");
            }
            catch (IOException e) {
                LOG.warn("Cannot parse popular node package list from popular-node-packages.json", (Throwable)e);
                infos = Collections.emptyList();
            }
            this.myInfosRef = new WeakReference<List<NodePackageBasicInfo>>(infos);
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (NodePackageBasicInfo info : infos) {
            if (!info.getName().startsWith(prefix) || !filter.value((Object)info)) continue;
            result.add(info);
            if (result.size() < limit) continue;
            break;
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/popularPackages/PopularNodePackagesProvider", "findByPrefix"));
        }
        return arrayList;
    }

    @NotNull
    private static List<NodePackageBasicInfo> parse() throws IOException {
        InputStream stream = PopularNodePackagesProvider.class.getResourceAsStream(FILE_NAME);
        if (stream == null) {
            throw new IOException("NodeJS plugin installation is possibly broken. Cannot find popular-node-packages.json");
        }
        List<NodePackageBasicInfo> list = PopularNodePackagesProvider.doParse(new JsonReader((Reader)new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET)));
        List<NodePackageBasicInfo> list2 = list;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/popularPackages/PopularNodePackagesProvider", "parse"));
        }
        return list2;
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to close stream", (Throwable)e);
                }
            }
        }
    }

    @NotNull
    private static List<NodePackageBasicInfo> doParse(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/packageJson/popularPackages/PopularNodePackagesProvider", "doParse"));
        }
        reader.beginArray();
        ArrayList result = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            reader.beginArray();
            String name = null;
            String description = null;
            if (reader.hasNext()) {
                name = reader.nextString();
            }
            if (reader.hasNext()) {
                description = reader.nextString();
            }
            while (reader.hasNext()) {
                reader.skipValue();
            }
            reader.endArray();
            if (name == null) continue;
            result.add(new NodePackageBasicInfo(name, description));
        }
        reader.endArray();
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/popularPackages/PopularNodePackagesProvider", "doParse"));
        }
        return arrayList;
    }
}

