/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packageJson.popularPackages;

import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.jetbrains.nodejs.packages.NodePackageBasicInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

public class PopularPackageListGenerator {
    private static final String MOST_DEPENDED_UPON_PACKAGES_DIR = "most-depended-upon-packages";
    private static final String MOST_STARRED_PACKAGES_DIR = "most-starred-packages";
    private static final int PACKAGES_PER_PAGE = 36;
    private static final int N = 1000;

    public static void main(String[] args) throws IOException {
        File downloadRoot = PopularPackageListGenerator.download();
        List<NodePackageBasicInfo> infos = PopularPackageListGenerator.parseAll(downloadRoot);
        PopularPackageListGenerator.writePackages(infos, new File(downloadRoot, "popular-node-packages.json"));
    }

    private static File download() throws IOException {
        File baseDir = FileUtil.createTempDirectory((String)"popular-node-packages-data", null, (boolean)false);
        if (!baseDir.isDirectory()) {
            throw new RuntimeException("Not a directory: " + baseDir.getAbsolutePath());
        }
        PopularPackageListGenerator.download("https://www.npmjs.com/browse/depended?offset=%d", new File(baseDir, MOST_DEPENDED_UPON_PACKAGES_DIR));
        PopularPackageListGenerator.download("https://www.npmjs.com/browse/star?offset=%d", new File(baseDir, MOST_STARRED_PACKAGES_DIR));
        return baseDir;
    }

    private static void download(@NotNull String urlPrefix, @NotNull File dir) throws IOException {
        if (urlPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlPrefix", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "download"));
        }
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "download"));
        }
        PopularPackageListGenerator.log("\n=== Downloading to " + dir.getAbsolutePath() + " ===", new Object[0]);
        for (int i = 0; i < 28; ++i) {
            String url = String.format(urlPrefix, i * 36);
            long startNano = System.nanoTime();
            RequestBuilder request = HttpRequests.request((String)url);
            request.connectTimeout(10000);
            request.readTimeout(10000);
            String content = request.readString(null);
            PopularPackageListGenerator.log("Downloaded in %d ms, content length: %s, %s", TimeoutUtil.getDurationMillis((long)startNano), content.length(), url);
            TimeoutUtil.sleep((long)1000L);
            File file = new File(dir, i + ".html");
            FileUtil.writeToFile((File)file, (String)content);
        }
    }

    private static void log(String format, Object ... args) {
        System.out.printf(format + "\n", args);
    }

    @NotNull
    public static List<NodePackageBasicInfo> parseAll(@NotNull File downloadRoot) throws IOException {
        if (downloadRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadRoot", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "parseAll"));
        }
        List<NodePackageBasicInfo> mostDependedUponInfos = PopularPackageListGenerator.parse(new File(downloadRoot, MOST_DEPENDED_UPON_PACKAGES_DIR));
        List<NodePackageBasicInfo> mostStarredInfos = PopularPackageListGenerator.parse(new File(downloadRoot, MOST_STARRED_PACKAGES_DIR));
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        for (NodePackageBasicInfo info : mostDependedUponInfos) {
            map.put(info.getName(), info);
        }
        for (NodePackageBasicInfo info : mostStarredInfos) {
            NodePackageBasicInfo old = (NodePackageBasicInfo)map.get(info.getName());
            if (old == null) {
                map.put(info.getName(), info);
                continue;
            }
            if (old.equals(info)) continue;
            throw new RuntimeException("Different packages: " + old + " vs " + info);
        }
        PopularPackageListGenerator.log("", new Object[0]);
        PopularPackageListGenerator.log("      Most starred: " + mostStarredInfos.size(), new Object[0]);
        PopularPackageListGenerator.log("Most depended upon: " + mostDependedUponInfos.size(), new Object[0]);
        PopularPackageListGenerator.log("        Total size: " + (mostStarredInfos.size() + mostDependedUponInfos.size()), new Object[0]);
        PopularPackageListGenerator.log(" Total merged size: " + map.size(), new Object[0]);
        List<NodePackageBasicInfo> list = map.values().stream().limit(1000L).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "parseAll"));
        }
        return list;
    }

    @NotNull
    private static List<NodePackageBasicInfo> parse(@NotNull File dir) throws IOException {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "parse"));
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException();
        }
        File[] files = (File[])ObjectUtils.notNull((Object)dir.listFiles(), (Object)ArrayUtil.EMPTY_FILE_ARRAY);
        Arrays.sort(files, (o1, o2) -> {
            String name1 = o1.getName();
            String name2 = o2.getName();
            int id1 = Integer.parseInt(FileUtil.getNameWithoutExtension((String)name1));
            int id2 = Integer.parseInt(FileUtil.getNameWithoutExtension((String)name2));
            return id1 - id2;
        });
        ArrayList infos = ContainerUtil.newArrayList();
        HashSet names = ContainerUtil.newHashSet();
        for (File file : files) {
            PopularPackageListGenerator.log("Parsing " + file.getAbsolutePath(), new Object[0]);
            String content = FileUtil.loadFile((File)file);
            List<NodePackageBasicInfo> parsed = PopularPackageListGenerator.parsedInfos(content);
            for (NodePackageBasicInfo info : parsed) {
                if (names.contains(info.getName())) {
                    throw new RuntimeException("Duplicated name " + info.getName());
                }
                infos.add(info);
            }
        }
        ArrayList arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "parse"));
        }
        return arrayList;
    }

    @NotNull
    private static List<NodePackageBasicInfo> parsedInfos(@NotNull String content) {
        int startInd;
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "parsedInfos"));
        }
        ArrayList infos = ContainerUtil.newArrayList();
        String TAG = "<div class=\"package-details\">";
        int i = 0;
        while (i < content.length() && (startInd = content.indexOf(TAG, i)) >= 0) {
            int endInd = content.indexOf("</div>", startInd);
            if (endInd < 0) {
                throw new RuntimeException("Cannot find closing tag");
            }
            NodePackageBasicInfo info = PopularPackageListGenerator.parseInfo(content.substring(startInd + TAG.length(), endInd));
            infos.add(info);
            i = endInd;
        }
        ArrayList arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "parsedInfos"));
        }
        return arrayList;
    }

    @NotNull
    private static NodePackageBasicInfo parseInfo(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "parseInfo"));
        }
        text = PopularPackageListGenerator.trimRequiredPrefix(text, "<h3>");
        int endInd = (text = PopularPackageListGenerator.trimRequiredPrefix(text, "<a class=\"name\" href=\"/package/")).indexOf("</a>");
        if (endInd < 0) {
            throw new RuntimeException("Cannot find link end");
        }
        int startInd = text.lastIndexOf(62, endInd);
        if (startInd < 0) {
            throw new RuntimeException("Cannot find link start");
        }
        String name = text.substring(startInd + 1, endInd);
        text = PopularPackageListGenerator.trimRequiredPrefix(text.substring(endInd), "</a>");
        text = PopularPackageListGenerator.trimRequiredPrefix(text, "</h3>");
        endInd = (text = PopularPackageListGenerator.trimRequiredPrefix(text, "<p class=\"description\">")).indexOf("</p>");
        if (endInd < 0) {
            throw new RuntimeException("Cannot find description end");
        }
        String description = text.substring(0, endInd);
        if (!(description = StringEscapeUtils.unescapeHtml((String)description)).contains(". ")) {
            description = StringUtil.trimEnd((String)description, (String)".");
        }
        if (description.startsWith("[![")) {
            description = null;
        }
        NodePackageBasicInfo nodePackageBasicInfo = new NodePackageBasicInfo(name, description);
        if (nodePackageBasicInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "parseInfo"));
        }
        return nodePackageBasicInfo;
    }

    @NotNull
    private static String trimRequiredPrefix(@NotNull String text, @NotNull String prefix) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "trimRequiredPrefix"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "trimRequiredPrefix"));
        }
        if (!(text = text.trim()).startsWith(prefix)) {
            throw new RuntimeException("Text doesn't start with " + prefix + ": " + text);
        }
        String string = text.substring(prefix.length());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "trimRequiredPrefix"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePackages(@NotNull List<NodePackageBasicInfo> names, @NotNull File outputFile) throws IOException {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "writePackages"));
        }
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "com/jetbrains/nodejs/packageJson/popularPackages/PopularPackageListGenerator", "writePackages"));
        }
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8));){
            writer.setIndent(" ");
            writer.beginArray();
            for (NodePackageBasicInfo info : names) {
                writer.beginArray();
                writer.setIndent("");
                writer.value(info.getName());
                if (info.getDescription() != null) {
                    writer.value(info.getDescription());
                }
                writer.endArray();
                writer.setIndent(" ");
            }
            writer.endArray();
        }
        PopularPackageListGenerator.log(names.size() + " packages are written to " + outputFile.getAbsolutePath(), new Object[0]);
    }
}

