/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packages;

import com.google.common.collect.Maps;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.packages.NodeInstalledPackage;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeInstalledPackagesProvider {
    private static final NodeInstalledPackagesProvider INSTANCE = new NodeInstalledPackagesProvider();
    private static final String[] FILE_EXTENSIONS = new String[]{".js", ".coffee", ".json", ".node"};

    @NotNull
    public static NodeInstalledPackagesProvider getInstance() {
        NodeInstalledPackagesProvider nodeInstalledPackagesProvider = INSTANCE;
        if (nodeInstalledPackagesProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodeInstalledPackagesProvider", "getInstance"));
        }
        return nodeInstalledPackagesProvider;
    }

    @NotNull
    public Collection<NodeInstalledPackage> listInstalledPackages(@Nullable File currentDir, @Nullable NodeJsLocalInterpreter interpreter) {
        HashMap packageByNameMap = Maps.newHashMap();
        if (currentDir != null) {
            NodeInstalledPackagesProvider.addPackagesFromNodeModulesDir(packageByNameMap, currentDir);
        }
        if (interpreter != null) {
            NodeInstalledPackagesProvider.addGloballyInstalledPackages(packageByNameMap, interpreter);
        }
        Collection<NodeInstalledPackage> collection = packageByNameMap.values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodeInstalledPackagesProvider", "listInstalledPackages"));
        }
        return collection;
    }

    private static void addGloballyInstalledPackages(@NotNull Map<String, NodeInstalledPackage> packageByNameMap, @NotNull NodeJsLocalInterpreter interpreter) {
        if (packageByNameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageByNameMap", "com/jetbrains/nodejs/packages/NodeInstalledPackagesProvider", "addGloballyInstalledPackages"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/packages/NodeInstalledPackagesProvider", "addGloballyInstalledPackages"));
        }
        VirtualFile dir = interpreter.getGlobalNodeModulesVirtualDir();
        if (dir != null && dir.isValid()) {
            File ioDir = new File(dir.getPath());
            NodeInstalledPackagesProvider.addPackagesFromDirectory(ioDir, packageByNameMap, true, null);
        }
    }

    private static void addPackagesFromNodeModulesDir(@NotNull Map<String, NodeInstalledPackage> packageByNameMap, @NotNull File currentDir) {
        if (packageByNameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageByNameMap", "com/jetbrains/nodejs/packages/NodeInstalledPackagesProvider", "addPackagesFromNodeModulesDir"));
        }
        if (currentDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDir", "com/jetbrains/nodejs/packages/NodeInstalledPackagesProvider", "addPackagesFromNodeModulesDir"));
        }
        File nodeModulesDir = new File(currentDir, "node_modules");
        if (nodeModulesDir.isDirectory()) {
            File packageJsonIoFile = new File(currentDir, "package.json");
            VirtualFile packageJsonFile = packageJsonIoFile.isFile() ? LocalFileSystem.getInstance().findFileByIoFile(packageJsonIoFile) : null;
            PackageJsonData data = packageJsonFile != null ? PackageJsonUtil.getOrCreateData((VirtualFile)packageJsonFile) : null;
            NodeInstalledPackagesProvider.addPackagesFromDirectory(nodeModulesDir, packageByNameMap, false, data);
        }
    }

    private static void addPackagesFromDirectory(@NotNull File dir, @NotNull Map<String, NodeInstalledPackage> packageByNameMap, boolean global, @Nullable PackageJsonData data) {
        File[] children;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/nodejs/packages/NodeInstalledPackagesProvider", "addPackagesFromDirectory"));
        }
        if (packageByNameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageByNameMap", "com/jetbrains/nodejs/packages/NodeInstalledPackagesProvider", "addPackagesFromDirectory"));
        }
        for (File child : children = (File[])ObjectUtils.notNull((Object)dir.listFiles(), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
            File[] grandChildren;
            if (!child.isDirectory()) continue;
            NodeInstalledPackagesProvider.tryAdd(child, child.getName(), packageByNameMap, global, data);
            if (!child.getName().startsWith("@")) continue;
            for (File grandChild : grandChildren = (File[])ObjectUtils.notNull((Object)child.listFiles(), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
                NodeInstalledPackagesProvider.tryAdd(grandChild, child.getName() + "/" + grandChild.getName(), packageByNameMap, global, data);
            }
        }
    }

    private static void tryAdd(@NotNull File dir, @NotNull String packageName, @NotNull Map<String, NodeInstalledPackage> packageByNameMap, boolean global, @Nullable PackageJsonData data) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/nodejs/packages/NodeInstalledPackagesProvider", "tryAdd"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodeInstalledPackagesProvider", "tryAdd"));
        }
        if (packageByNameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageByNameMap", "com/jetbrains/nodejs/packages/NodeInstalledPackagesProvider", "tryAdd"));
        }
        if (NodeInstalledPackagesProvider.canLoadDirectory(dir) && (data == null || data.isDependencyOfAnyType(packageName)) && !packageByNameMap.containsKey(packageName)) {
            SemVer semVer = NodePackageVersionUtil.getPackageVersion((File)dir);
            String rawVersion = semVer != null ? semVer.getRawVersion() : null;
            packageByNameMap.put(packageName, new NodeInstalledPackage(packageName, rawVersion, dir, global));
        }
    }

    private static boolean canLoadDirectory(@NotNull File dir) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/jetbrains/nodejs/packages/NodeInstalledPackagesProvider", "canLoadDirectory"));
        }
        File packageJson = new File(dir, "package.json");
        if (packageJson.isFile()) {
            return true;
        }
        for (String ext : FILE_EXTENSIONS) {
            File file = new File(dir, "index" + ext);
            if (!file.isFile()) continue;
            return true;
        }
        return false;
    }
}

