/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packages;

import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.bower.cache.PrevRequestSkippingCache;
import com.jetbrains.nodejs.packages.NodePackageInfo;
import com.jetbrains.nodejs.packages.NodePackageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageInfoManager {
    private final NodeJsLocalInterpreter myInterpreter;
    private PrevRequestSkippingCache<String, NodePackageInfo> myCache;

    public NodePackageInfoManager(@NotNull NodeJsLocalInterpreter interpreter) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/packages/NodePackageInfoManager", "<init>"));
        }
        this.myInterpreter = interpreter;
        this.myCache = new PrevRequestSkippingCache((PrevRequestSkippingCache.Fetcher)new PrevRequestSkippingCache.Fetcher<String, NodePackageInfo>(){

            @Nullable
            public NodePackageInfo fetch(@NotNull String packageName) throws Exception {
                if (packageName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageInfoManager$1", "fetch"));
                }
                return NodePackageUtil.loadPackageInfo(NodePackageInfoManager.this.myInterpreter, packageName, false);
            }
        });
    }

    public void fetchPackageInfo(final @NotNull PackageInfoConsumer packageInfoConsumer) {
        if (packageInfoConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageInfoConsumer", "com/jetbrains/nodejs/packages/NodePackageInfoManager", "fetchPackageInfo"));
        }
        String packageName = packageInfoConsumer.myPackageName;
        boolean canBeSkipped = packageInfoConsumer.myCanBeSkipped;
        PrevRequestSkippingCache.FetchCallback<String, NodePackageInfo> callback = new PrevRequestSkippingCache.FetchCallback<String, NodePackageInfo>(packageName, canBeSkipped){

            public void onSuccess(@Nullable NodePackageInfo packageInfo) {
                packageInfoConsumer.onPackageInfo(packageInfo);
            }

            public void onException(@NotNull Exception e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/packages/NodePackageInfoManager$2", "onException"));
                }
                packageInfoConsumer.onException(e);
            }
        };
        this.myCache.fetch((PrevRequestSkippingCache.FetchCallback)callback);
    }

    public static abstract class PackageInfoConsumer {
        private final String myPackageName;
        private final boolean myCanBeSkipped;

        public PackageInfoConsumer(@NotNull String packageName) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageInfoManager$PackageInfoConsumer", "<init>"));
            }
            this(packageName, true);
        }

        public PackageInfoConsumer(@NotNull String packageName, boolean canBeSkipped) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageInfoManager$PackageInfoConsumer", "<init>"));
            }
            this.myPackageName = packageName;
            this.myCanBeSkipped = canBeSkipped;
        }

        public abstract void onPackageInfo(@Nullable NodePackageInfo var1);

        public abstract void onException(@NotNull Exception var1);
    }
}

