/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packages;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.packages.NodePackageListProvider;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class NodePackageListCachingProvider {
    private static final Logger LOG = Logger.getInstance(NodePackageListCachingProvider.class);
    private static final long ERROR_ATTEMPT_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final long MAX_BLOCKING_DURATION_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    private static final String MESSAGE_PREFIX = "Cannot list all remote node packages";
    private volatile WeakReference<List<String>> myCache;
    private Future<List<String>> myRunningTask;
    private final Object myRunningTaskLock = new Object();
    private volatile long myLastErrorAttemptMillis = 0L;
    private volatile long myPackagesTimestamp = 0L;

    public static NodePackageListCachingProvider getInstance() {
        return (NodePackageListCachingProvider)ServiceManager.getService(NodePackageListCachingProvider.class);
    }

    @NotNull
    public List<String> getPackageNames() {
        List<String> list;
        List list2 = (List)SoftReference.dereference(this.myCache);
        if (list2 != null && NodePackageListProvider.getInstance().isFreshTimestamp(this.myPackagesTimestamp)) {
            List list3 = list2;
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListCachingProvider", "getPackageNames"));
            }
            return list3;
        }
        List notNullList = ContainerUtil.notNullize((List)list2);
        if (System.currentTimeMillis() - this.myLastErrorAttemptMillis < ERROR_ATTEMPT_TIMEOUT_MILLIS) {
            List list4 = notNullList;
            if (list4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListCachingProvider", "getPackageNames"));
            }
            return list4;
        }
        Future<List<String>> task = this.getOrCreateTask();
        try {
            list = task.get(MAX_BLOCKING_DURATION_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new AssertionError(MESSAGE_PREFIX, e);
            }
            LOG.warn(MESSAGE_PREFIX, (Throwable)e);
            List list5 = notNullList;
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListCachingProvider", "getPackageNames"));
            }
            return list5;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListCachingProvider", "getPackageNames"));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Future<List<String>> getOrCreateTask() {
        Object object = this.myRunningTaskLock;
        // MONITORENTER : object
        if (this.myRunningTask == null) {
            this.myRunningTask = this.createTask();
        }
        Future<List<String>> future = this.myRunningTask;
        // MONITOREXIT : object
        if (future != null) return future;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListCachingProvider", "getOrCreateTask"));
    }

    @NotNull
    private Future<List<String>> createTask() {
        FutureTask<List<String>> future = new FutureTask<List<String>>(() -> {
            try {
                NodePackageListProvider provider = NodePackageListProvider.getInstance();
                long timestamp = provider.getRemotePackagesTimestamp();
                List<String> list = provider.listAllRemotePackageNames();
                this.myPackagesTimestamp = timestamp;
                this.myLastErrorAttemptMillis = 0L;
                this.myCache = new WeakReference<List<String>>(list);
                List<String> list2 = list;
                return list2;
            }
            catch (Exception e) {
                LOG.warn(MESSAGE_PREFIX, (Throwable)e);
                this.myPackagesTimestamp = 0L;
                this.myLastErrorAttemptMillis = System.currentTimeMillis();
                throw e;
            }
            finally {
                Object object = this.myRunningTaskLock;
                synchronized (object) {
                    this.myRunningTask = null;
                }
            }
        });
        ApplicationManager.getApplication().executeOnPooledThread(future);
        FutureTask<List<String>> futureTask = future;
        if (futureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListCachingProvider", "createTask"));
        }
        return futureTask;
    }
}

