/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packages;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.packages.NodePackageListProvider;
import com.jetbrains.nodejs.packages.NodePackageNames;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.GZIPInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageListProviderImpl
implements NodePackageListProvider {
    private static final Logger LOG = Logger.getInstance(NodePackageListProviderImpl.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss Z";
    private static final String ALL_NODE_PACKAGE_NAMES_URL = "http://download.jetbrains.com/idea/nodejs/all-node-package-names-json.gzip";
    private static final String NPM_REGISTRY_ALL_URL = "http://registry.npmjs.org/-/all";
    private static final Object JSON_FILE_LOCK = new Object();
    private final ReentrantLock myUpdateLock = new ReentrantLock();

    private NodePackageListProviderImpl() {
    }

    @Override
    @NotNull
    public List<String> listAllRemotePackageNames() throws IOException {
        NodePackageNames packageNames = this.getAllNodePackageNames();
        List<String> list = Collections.unmodifiableList(packageNames.getNames());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "listAllRemotePackageNames"));
        }
        return list;
    }

    @Override
    public long getRemotePackagesTimestamp() {
        return NodePackageListProviderImpl.getAllPackageNamesJsonFile().lastModified();
    }

    @Override
    public boolean isFreshTimestamp(long ts) {
        return NodePackageNames.isValid(ts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private NodePackageNames getAllNodePackageNames() throws IOException {
        File allPackageNamesFile = NodePackageListProviderImpl.getAllPackageNamesJsonFile();
        NodePackageNames names = NodePackageListProviderImpl.readPackageNamesFileWithLock(allPackageNamesFile);
        if (names == null) {
            block10: {
                long beforeLastModified = allPackageNamesFile.lastModified();
                this.myUpdateLock.lock();
                try {
                    if (beforeLastModified != allPackageNamesFile.lastModified()) {
                        names = NodePackageListProviderImpl.readPackageNamesFileWithLock(allPackageNamesFile);
                    }
                    if (names != null) break block10;
                    try {
                        names = NodePackageListProviderImpl.updateSync();
                    }
                    catch (IOException e) {
                        LOG.warn("Cannot update all node packages synchronously", (Throwable)e);
                        throw e;
                    }
                }
                finally {
                    this.myUpdateLock.unlock();
                }
            }
            NodePackageNames nodePackageNames = names;
            if (nodePackageNames == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "getAllNodePackageNames"));
            }
            return nodePackageNames;
        }
        if (!names.isValid()) {
            NodePackageListProviderImpl.logOutdated(names);
            this.updateAsync();
        }
        NodePackageNames nodePackageNames = names;
        if (nodePackageNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "getAllNodePackageNames"));
        }
        return nodePackageNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static NodePackageNames readPackageNamesFileWithLock(@NotNull File allPackageNamesJsonFile) {
        if (allPackageNamesJsonFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPackageNamesJsonFile", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "readPackageNamesFileWithLock"));
        }
        Object object = JSON_FILE_LOCK;
        synchronized (object) {
            if (allPackageNamesJsonFile.isFile()) {
                try {
                    long startNanoTime = System.nanoTime();
                    NodePackageNames names = NodePackageListProviderImpl.readPackageNamesFile(allPackageNamesJsonFile, false);
                    double pastDays = (double)(System.currentTimeMillis() - names.getGenerationTimeMillis()) / (1.0 * (double)TimeUnit.DAYS.toMillis(1L));
                    LOG.info(String.format("%d node packages has been read in %d ms, updated %.2f days ago: %s", names.getNames().size(), TimeoutUtil.getDurationMillis((long)startNanoTime), pastDays, allPackageNamesJsonFile.getAbsolutePath()));
                    return names;
                }
                catch (IOException e) {
                    LOG.warn("Cannot parse " + allPackageNamesJsonFile.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        return null;
    }

    @NotNull
    private static File getAllPackageNamesJsonFile() {
        File file = new File(PathManager.getSystemPath(), "extLibs" + File.separator + "nodejs" + File.separator + "all-node-package-names.json");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "getAllPackageNamesJsonFile"));
        }
        return file;
    }

    private void updateAsync() {
        if (!this.myUpdateLock.isLocked()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                LOG.info("Updating all node package names asynchronously ...");
                this.myUpdateLock.lock();
                try {
                    NodePackageListProviderImpl.updateSync();
                }
                catch (Exception e) {
                    LOG.warn("Cannot update all node packages", (Throwable)e);
                }
                finally {
                    this.myUpdateLock.unlock();
                }
            });
        } else {
            LOG.info("Async update was skipped, because another update is in progress");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static NodePackageNames readPackageNamesFile(@NotNull File allPackageNamesFile, boolean gzipped) throws IOException {
        if (allPackageNamesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPackageNamesFile", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "readPackageNamesFile"));
        }
        JsonReader reader = NodePackageListProviderImpl.newJsonReader(allPackageNamesFile, gzipped);
        NodePackageNames nodePackageNames = NodePackageListProviderImpl.doReadPackages(reader, allPackageNamesFile);
        NodePackageNames nodePackageNames2 = nodePackageNames;
        if (nodePackageNames2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "readPackageNamesFile"));
        }
        return nodePackageNames2;
        finally {
            NodePackageListProviderImpl.closeSilently((Closeable)reader);
        }
    }

    @NotNull
    private static JsonReader newJsonReader(@NotNull File allPackagesJsonFile, boolean gzipped) throws IOException {
        if (allPackagesJsonFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPackagesJsonFile", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "newJsonReader"));
        }
        FilterInputStream inputStream = new BufferedInputStream(new FileInputStream(allPackagesJsonFile), 131072);
        if (gzipped) {
            try {
                inputStream = new GZIPInputStream(inputStream);
            }
            catch (IOException e) {
                NodePackageListProviderImpl.closeSilently(inputStream);
                throw e;
            }
        }
        JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
        if (jsonReader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "newJsonReader"));
        }
        return jsonReader;
    }

    @NotNull
    private static NodePackageNames doReadPackages(@NotNull JsonReader reader, @NotNull File jsonFile) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "doReadPackages"));
        }
        if (jsonFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonFile", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "doReadPackages"));
        }
        reader.beginObject();
        long generationTimeMillis = jsonFile.lastModified();
        List names = null;
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("_updated".equals(key)) {
                String generatedDateStr = reader.nextString();
                SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
                try {
                    Date date = format.parse(generatedDateStr);
                    generationTimeMillis = date.getTime();
                }
                catch (ParseException e) {
                    LOG.warn(String.format("Cannot parse generation date '%s' as '%s'", generatedDateStr, DATE_FORMAT), (Throwable)e);
                }
                continue;
            }
            if ("_total_package_count".equals(key)) {
                int totalPackageCount = reader.nextInt();
                names = ContainerUtil.newArrayListWithCapacity((int)totalPackageCount);
                continue;
            }
            if ("package_names".equals(key)) {
                if (names == null) {
                    LOG.warn("Package count not specified");
                    names = ContainerUtil.newArrayList();
                }
                reader.beginArray();
                while (reader.hasNext()) {
                    names.add(reader.nextString());
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (names == null || names.size() == 0) {
            throw new IOException("No packages found inside " + jsonFile.getAbsolutePath());
        }
        NodePackageNames nodePackageNames = new NodePackageNames(generationTimeMillis, names);
        if (nodePackageNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "doReadPackages"));
        }
        return nodePackageNames;
    }

    private static void closeSilently(@NotNull Closeable closeable) {
        if (closeable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closeable", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "closeSilently"));
        }
        try {
            closeable.close();
        }
        catch (IOException ioe) {
            LOG.warn("Cannot close stream", (Throwable)ioe);
        }
    }

    public static void logOutdated(@NotNull NodePackageNames names) throws IOException {
        if (names == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "names", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "logOutdated"));
        }
        double pastDays = (double)(System.currentTimeMillis() - names.getGenerationTimeMillis()) / (1.0 * (double)TimeUnit.DAYS.toMillis(1L));
        LOG.warn(String.format("Node package names were generated %.2f days ago", pastDays));
    }

    @NotNull
    private static NodePackageNames updateSync() throws IOException {
        NodePackageNames packageNames;
        block5: {
            File gzippedJson = FileUtil.createTempFile((String)"intellij-all-node-package-names-json", (String)".gzip");
            NodePackageListProviderImpl.downloadAndLog(ALL_NODE_PACKAGE_NAMES_URL, gzippedJson);
            packageNames = NodePackageListProviderImpl.readPackageNamesFile(gzippedJson, true);
            FileUtil.delete((File)gzippedJson);
            if (!packageNames.isValid()) break block5;
            NodePackageListProviderImpl.writePackageNamesWithLock(packageNames);
            NodePackageNames nodePackageNames = packageNames;
            if (nodePackageNames == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "updateSync"));
            }
            return nodePackageNames;
        }
        try {
            NodePackageListProviderImpl.logOutdated(packageNames);
        }
        catch (IOException e) {
            LOG.warn("Cannot update all package names", (Throwable)e);
        }
        File allNpmRegistryFile = FileUtil.createTempFile((String)"intellij-all-npm-registry", (String)".json");
        NodePackageListProviderImpl.downloadAndLog(NPM_REGISTRY_ALL_URL, allNpmRegistryFile);
        List<String> names = NodePackageListProviderImpl.extractNames(allNpmRegistryFile);
        FileUtil.delete((File)allNpmRegistryFile);
        NodePackageNames packageNames2 = new NodePackageNames(System.currentTimeMillis(), names);
        NodePackageListProviderImpl.writePackageNamesWithLock(packageNames2);
        NodePackageNames nodePackageNames = packageNames2;
        if (nodePackageNames == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "updateSync"));
        }
        return nodePackageNames;
    }

    private static void downloadAndLog(@NotNull String url, @NotNull File file) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "downloadAndLog"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "downloadAndLog"));
        }
        LOG.info("Downloading " + url + " to " + file.getAbsolutePath() + " ...");
        long startTimeMillis = System.currentTimeMillis();
        DownloadUtil.downloadAtomically(null, (String)url, (File)file);
        LOG.info(String.format("%s downloaded in %d ms", url, System.currentTimeMillis() - startTimeMillis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> extractNames(@NotNull File jsonFile) throws IOException {
        if (jsonFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonFile", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "extractNames"));
        }
        long startTimeMillis = System.currentTimeMillis();
        ArrayList names = ContainerUtil.newArrayList();
        try (JsonReader reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8), 65536));){
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if ("_updated".equalsIgnoreCase(key)) {
                    reader.skipValue();
                    continue;
                }
                String name = NodePackageListProviderImpl.readPackageName(reader);
                if (name == null) {
                    LOG.warn("Cannot parse info for node package '" + key + "'");
                    continue;
                }
                names.add(name);
            }
            reader.endObject();
            LOG.info(String.format("%d package names extracted in %d ms", names.size(), System.currentTimeMillis() - startTimeMillis));
        }
        return names;
    }

    @Nullable
    private static String readPackageName(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "readPackageName"));
        }
        reader.beginObject();
        String name = null;
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("name".equals(key)) {
                name = reader.nextString();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePackageNamesWithLock(@NotNull NodePackageNames packageNames) throws IOException {
        if (packageNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageNames", "com/jetbrains/nodejs/packages/NodePackageListProviderImpl", "writePackageNamesWithLock"));
        }
        Object object = JSON_FILE_LOCK;
        synchronized (object) {
            File allPackageNamesJsonFile = NodePackageListProviderImpl.getAllPackageNamesJsonFile();
            FileUtil.createParentDirs((File)allPackageNamesJsonFile);
            try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(allPackageNamesJsonFile), StandardCharsets.UTF_8));){
                writer.setIndent(" ");
                writer.beginObject();
                SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
                writer.name("_updated").value(df.format(new Date(packageNames.getGenerationTimeMillis())));
                writer.name("_total_package_count").value((long)packageNames.getNames().size());
                writer.name("package_names");
                writer.beginArray();
                for (String name : packageNames.getNames()) {
                    writer.value(name);
                }
                writer.endArray();
                writer.endObject();
            }
        }
    }
}

