/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packages;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import com.jetbrains.nodejs.packages.NodePackageInfo;
import com.jetbrains.nodejs.packages.NodePackageInfoException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageUtil {
    private static final Logger LOG = Logger.getInstance(NodePackageUtil.class);
    private static final String[] GIT_PREFIXES = new String[]{"git://", "git@"};
    private static final File WORKING_DIR;

    private NodePackageUtil() {
    }

    @Nullable
    public static NodePackageInfo loadPackageInfo(@NotNull NodeJsLocalInterpreter interpreter, @NotNull String packageName, boolean cacheOnFs) throws IOException {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/packages/NodePackageUtil", "loadPackageInfo"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageUtil", "loadPackageInfo"));
        }
        return NodePackageUtil.loadPackageInfo(interpreter, packageName, cacheOnFs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static NodePackageInfo loadPackageInfo(@NotNull NodeJsLocalInterpreter interpreter, @NotNull String packageName, boolean cacheOnFs, @Nullable ProgressIndicator indicator) throws IOException {
        NodePackageInfo nodePackageInfo;
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/packages/NodePackageUtil", "loadPackageInfo"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageUtil", "loadPackageInfo"));
        }
        long startNano = System.nanoTime();
        LOG.debug("Loading node package info for " + packageName + " ...");
        String status = "with exception";
        try {
            NodePackageInfo packageInfo = NodePackageUtil.doLoadPackageInfo(interpreter, packageName, cacheOnFs, indicator);
            status = packageInfo == null ? "as null" : "successfully";
            nodePackageInfo = packageInfo;
        }
        catch (Throwable throwable) {
            LOG.debug(String.format("Info for %s node package loaded %s in %d ms", packageName, status, TimeoutUtil.getDurationMillis((long)startNano)));
            throw throwable;
        }
        LOG.debug(String.format("Info for %s node package loaded %s in %d ms", packageName, status, TimeoutUtil.getDurationMillis((long)startNano)));
        return nodePackageInfo;
    }

    @Nullable
    private static NodePackageInfo doLoadPackageInfo(@NotNull NodeJsLocalInterpreter interpreter, @NotNull String packageName, boolean cacheOnFs, @Nullable ProgressIndicator indicator) throws IOException {
        File cacheFile;
        ProcessOutput output;
        GeneralCommandLine commandLine;
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/packages/NodePackageUtil", "doLoadPackageInfo"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageUtil", "doLoadPackageInfo"));
        }
        try {
            commandLine = NodeCommandLineUtil.createNpmCommandLine((File)WORKING_DIR, (NodeJsLocalInterpreter)interpreter, (List)Lists.newArrayList((Object[])new String[]{"info", "--json", packageName}));
            output = NodeCommandLineUtil.execute((GeneralCommandLine)commandLine, (ProgressIndicator)indicator, (long)TimeUnit.SECONDS.toMillis(120L));
        }
        catch (ExecutionException e) {
            throw new IOException(e.getMessage(), e);
        }
        int exitCode = output.getExitCode();
        if (output.isTimeout()) {
            throw new IOException("Command '" + commandLine.getCommandLineString() + "' is timed out.");
        }
        if (exitCode != 0) {
            throw new NodePackageInfoException(commandLine.getCommandLineString(), exitCode, output.getStdout(), output.getStderr());
        }
        String stdout = output.getStdout();
        if (StringUtil.isEmptyOrSpaces((String)stdout)) {
            throw new IOException("Got empty stdout, exit code: 0, stderr:\n" + output.getStderr());
        }
        NodePackageInfo info = NodePackageUtil.parsePackageInfo(stdout);
        if (info != null && cacheOnFs && (cacheFile = NodePackageUtil.getCacheFile(packageName)) != null) {
            try {
                Files.write((CharSequence)stdout, (File)cacheFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LOG.warn("Can't cache result of 'npm info " + packageName + "' in " + cacheFile.getAbsolutePath(), (Throwable)e);
            }
        }
        return info;
    }

    @Nullable
    private static File getCacheFile(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageUtil", "getCacheFile"));
        }
        File npmInfoDir = new File(PathManager.getSystemPath(), "extLibs" + File.separator + "nodejs" + File.separator + "npm-info-cache");
        if (FileUtil.createDirectory((File)npmInfoDir)) {
            return new File(npmInfoDir, packageName.replace('/', '$').replace('\\', '$'));
        }
        return null;
    }

    @Nullable
    public static NodePackageInfo loadCachedPackageInfo(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NodePackageUtil", "loadCachedPackageInfo"));
        }
        File cacheFile = NodePackageUtil.getCacheFile(packageName);
        if (cacheFile != null && cacheFile.isFile()) {
            try {
                String stdout = Files.toString((File)cacheFile, (Charset)StandardCharsets.UTF_8);
                return NodePackageUtil.parsePackageInfo(stdout);
            }
            catch (IOException e) {
                LOG.warn("Can't read cached output of 'npm info " + packageName + "'", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static NodePackageInfo parsePackageInfo(@NotNull String jsonContent) throws IOException {
        if (jsonContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonContent", "com/jetbrains/nodejs/packages/NodePackageUtil", "parsePackageInfo"));
        }
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(jsonContent));
        try {
            jsonReader.setLenient(true);
            NodePackageInfo nodePackageInfo = NodePackageUtil.doParsePackageInfo(jsonReader, true);
            return nodePackageInfo;
        }
        finally {
            try {
                jsonReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Nullable
    private static NodePackageInfo doParsePackageInfo(@NotNull JsonReader reader, boolean onRootObject) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/packages/NodePackageUtil", "doParsePackageInfo"));
        }
        JsonToken nextToken = reader.peek();
        if (nextToken != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return null;
        }
        List<String> versions = Collections.emptyList();
        String latestVersion = null;
        String packageName = null;
        String description = null;
        String author = null;
        String repositoryUrl = null;
        reader.beginObject();
        boolean typeKeyEncountered = false;
        NodePackageInfo innerResult = null;
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("versions".equals(key)) {
                versions = NodePackageUtil.parseVersions(reader);
                continue;
            }
            if ("dist-tags".equals(key)) {
                latestVersion = JsonUtil.getChildAsString((JsonReader)reader, (String)"latest");
                continue;
            }
            if ("name".equals(key)) {
                packageName = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            if ("description".equals(key)) {
                description = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            if ("author".equals(key)) {
                author = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            if ("repository".equals(key)) {
                repositoryUrl = NodePackageUtil.parseRepositoryUrl(reader);
                continue;
            }
            if (onRootObject && "data".equals(key)) {
                innerResult = NodePackageUtil.doParsePackageInfo(reader, false);
                continue;
            }
            if (onRootObject && "type".equals(key)) {
                typeKeyEncountered = true;
                reader.skipValue();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (packageName != null) {
            return new NodePackageInfo(packageName, StringUtil.notNullize(description), versions, latestVersion, author, repositoryUrl);
        }
        return typeKeyEncountered ? innerResult : null;
    }

    private static List<String> parseVersions(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/packages/NodePackageUtil", "parseVersions"));
        }
        JsonToken nextToken = reader.peek();
        if (nextToken != JsonToken.BEGIN_ARRAY) {
            reader.skipValue();
            return Collections.emptyList();
        }
        ArrayList versions = ContainerUtil.newArrayList((Iterable)JsonUtil.nextStringList((JsonReader)reader));
        Collections.reverse(versions);
        return versions;
    }

    @Nullable
    private static String parseRepositoryUrl(@NotNull JsonReader reader) throws IOException {
        boolean gitRepo;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/packages/NodePackageUtil", "parseRepositoryUrl"));
        }
        JsonToken nextToken = reader.peek();
        if (nextToken != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return null;
        }
        String url = null;
        String type = null;
        reader.beginObject();
        while (reader.hasNext()) {
            String key = reader.nextName();
            if ("url".equals(key)) {
                url = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            if ("type".equals(key)) {
                type = JsonUtil.nextStringOrSkip((JsonReader)reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (url == null) {
            return null;
        }
        boolean bl = gitRepo = "git".equals(type) || StringUtil.isEmpty(type);
        if (gitRepo) {
            String gitPrefix = null;
            for (String gp : GIT_PREFIXES) {
                if (!url.startsWith(gp)) continue;
                gitPrefix = gp;
                break;
            }
            if (gitPrefix != null) {
                if (gitPrefix == "git@") {
                    int colonInd = url.indexOf(58);
                    if (colonInd >= 0) {
                        url = url.substring(0, colonInd) + "/" + url.substring(colonInd + 1);
                    } else {
                        return url;
                    }
                }
                url = "http://" + url.substring(gitPrefix.length());
                String gitSuffix = ".git";
                url = StringUtil.trimEnd((String)url, (String)gitSuffix);
            }
        }
        return url;
    }

    static {
        File workingDir = null;
        try {
            workingDir = FileUtil.createTempDirectory((String)"intellij-npm-info", null, (boolean)false);
        }
        catch (Exception e) {
            LOG.warn("Can't create temporary directory, working directory won't be specified.");
        }
        WORKING_DIR = workingDir;
    }
}

