/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packages;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.packages.NodePackageBasicInfo;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NpmRegistryService {
    private static final Logger LOG = Logger.getInstance(NpmRegistryService.class);
    private static final String LATEST_DIST_TAG = "latest";
    private final ConcurrentMap<String, TimestampedDistTags> myDistTagsCache = ContainerUtil.createConcurrentSoftMap();
    private final ConcurrentMap<String, Future<DistTags>> myRunningFutures = ContainerUtil.newConcurrentMap();
    private final ExecutorService myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"npm registry pool", (int)2);

    public static NpmRegistryService getInstance() {
        return (NpmRegistryService)ServiceManager.getService(NpmRegistryService.class);
    }

    public void findPackagesByPrefix(@Nullable ProgressIndicator indicator, @NotNull String prefix, int limit, @NotNull Condition<NodePackageBasicInfo> filter, @NotNull Consumer<NodePackageBasicInfo> consumer) throws IOException, ProcessCanceledException {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/nodejs/packages/NpmRegistryService", "findPackagesByPrefix"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/jetbrains/nodejs/packages/NpmRegistryService", "findPackagesByPrefix"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/nodejs/packages/NpmRegistryService", "findPackagesByPrefix"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        String baseUrl = prefix.startsWith("@") ? "https://replicate.npmjs.com" : "https://skimdb.npmjs.com";
        HashSet all = ContainerUtil.newHashSet();
        int found = 0;
        int skip = 0;
        while (found < limit) {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            int localLimit = limit - found;
            List<NodePackageBasicInfo> results = NpmRegistryService.findPackagesOrWaitForIt(indicator, baseUrl, prefix, skip, localLimit);
            skip += localLimit;
            String duplicate = null;
            for (NodePackageBasicInfo info : results) {
                if (all.add(info.getName())) {
                    if (!filter.value((Object)info)) continue;
                    consumer.consume((Object)info);
                    ++found;
                    continue;
                }
                duplicate = info.getName();
            }
            if (results.size() < localLimit) break;
            if (duplicate == null) continue;
            LOG.warn("Duplicated package: " + duplicate + ", prefix: " + prefix + ". Stopping to preserve infinite loop.");
            break;
        }
    }

    @NotNull
    private static List<NodePackageBasicInfo> findPackagesOrWaitForIt(@Nullable ProgressIndicator indicator, @NotNull String baseUrl, @NotNull String prefix, int skip, int limit) throws IOException {
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/jetbrains/nodejs/packages/NpmRegistryService", "findPackagesOrWaitForIt"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/nodejs/packages/NpmRegistryService", "findPackagesOrWaitForIt"));
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            List list;
            try {
                list = (List)ApplicationUtil.runWithCheckCanceled(() -> {
                    if (baseUrl == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/jetbrains/nodejs/packages/NpmRegistryService", "lambda$findPackagesOrWaitForIt$0"));
                    }
                    if (prefix == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/nodejs/packages/NpmRegistryService", "lambda$findPackagesOrWaitForIt$0"));
                    }
                    return NpmRegistryService.doFetchPackages(indicator, baseUrl, prefix, skip, limit);
                }, (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)indicator));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "findPackagesOrWaitForIt"));
            }
            return list;
        }
        List<NodePackageBasicInfo> list = NpmRegistryService.doFetchPackages(indicator, baseUrl, prefix, skip, limit);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "findPackagesOrWaitForIt"));
        }
        return list;
    }

    @NotNull
    private static List<NodePackageBasicInfo> doFetchPackages(@Nullable ProgressIndicator indicator, @NotNull String baseUrl, @NotNull String prefix, int skip, int limit) throws IOException {
        List<NodePackageBasicInfo> list;
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "com/jetbrains/nodejs/packages/NpmRegistryService", "doFetchPackages"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/nodejs/packages/NpmRegistryService", "doFetchPackages"));
        }
        String startKey = "[\"" + prefix + "\"]";
        String endKey = "[\"" + prefix + "z\",{}]";
        String url = baseUrl + "/registry/_design/app/_view/browseAll?group_level=2&skip=" + skip + "&limit=" + limit + "&start_key=" + URLUtil.encodeURIComponent((String)startKey) + "&end_key=" + URLUtil.encodeURIComponent((String)endKey);
        try {
            long startNano = System.nanoTime();
            String content = HttpRequests.request((String)url).readString(indicator);
            JsonReader reader = new JsonReader((Reader)new StringReader(content));
            List<NodePackageBasicInfo> infos = NpmRegistryService.readPackages(reader);
            LOG.info("Found " + infos.size() + " packages matching '" + prefix + "*' in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms (" + url + ")");
            list = infos;
        }
        catch (IOException e) {
            throw new IOException("Failed to fetch packages for '" + prefix + "'", e);
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "doFetchPackages"));
        }
        return list;
    }

    @NotNull
    private static List<NodePackageBasicInfo> readPackages(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/packages/NpmRegistryService", "readPackages"));
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            List<NodePackageBasicInfo> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "readPackages"));
            }
            return list;
        }
        reader.beginObject();
        List<NodePackageBasicInfo> packages = Collections.emptyList();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("rows".equals(name)) {
                packages = NpmRegistryService.readPackagesInsideRows(reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        List<NodePackageBasicInfo> list = packages;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "readPackages"));
        }
        return list;
    }

    @NotNull
    private static List<NodePackageBasicInfo> readPackagesInsideRows(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/packages/NpmRegistryService", "readPackagesInsideRows"));
        }
        if (reader.peek() != JsonToken.BEGIN_ARRAY) {
            reader.skipValue();
            List<NodePackageBasicInfo> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "readPackagesInsideRows"));
            }
            return list;
        }
        reader.beginArray();
        ArrayList infos = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            NodePackageBasicInfo info = NpmRegistryService.readSinglePackage(reader);
            if (info == null) continue;
            infos.add(info);
        }
        reader.endArray();
        ArrayList arrayList = infos;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "readPackagesInsideRows"));
        }
        return arrayList;
    }

    @Nullable
    private static NodePackageBasicInfo readSinglePackage(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/packages/NpmRegistryService", "readSinglePackage"));
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            return null;
        }
        reader.beginObject();
        NodePackageBasicInfo info = null;
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("key".equals(name)) {
                info = NpmRegistryService.readArrayInsideKey(reader);
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return info;
    }

    @Nullable
    private static NodePackageBasicInfo readArrayInsideKey(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/packages/NpmRegistryService", "readArrayInsideKey"));
        }
        if (reader.peek() != JsonToken.BEGIN_ARRAY) {
            reader.skipValue();
            return null;
        }
        reader.beginArray();
        String name = null;
        String description = null;
        int i = 0;
        while (reader.hasNext()) {
            if (i < 2 && reader.peek() == JsonToken.STRING) {
                String str = reader.nextString();
                if (i == 0) {
                    name = str;
                } else {
                    description = str;
                }
            } else {
                reader.skipValue();
            }
            ++i;
        }
        reader.endArray();
        return name != null ? new NodePackageBasicInfo(name, description) : null;
    }

    @Nullable
    public List<Pair<String, SemVer>> getCachedPackageDistTags(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NpmRegistryService", "getCachedPackageDistTags"));
        }
        TimestampedDistTags cache = (TimestampedDistTags)this.myDistTagsCache.get(packageName);
        if (cache != null && cache.getCreateTimeNano() + TimeUnit.MINUTES.toNanos(10L) > System.nanoTime()) {
            DistTags tags = cache.getDistTags();
            return tags != null ? tags.getList() : Collections.emptyList();
        }
        return null;
    }

    public void asyncUpdatePackageDistTags(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NpmRegistryService", "asyncUpdatePackageDistTags"));
        }
        this.getOrCreateDistTagsFetchFuture(packageName);
    }

    @NotNull
    public List<Pair<String, SemVer>> getCachedOrFetchPackageDistTags(@NotNull String packageName, @Nullable ProgressIndicator indicator) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NpmRegistryService", "getCachedOrFetchPackageDistTags"));
        }
        List<Pair<String, SemVer>> cache = this.getCachedPackageDistTags(packageName);
        if (cache != null) {
            List<Pair<String, SemVer>> list = cache;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "getCachedOrFetchPackageDistTags"));
            }
            return list;
        }
        Future<DistTags> future = this.getOrCreateDistTagsFetchFuture(packageName);
        DistTags distTags = null;
        if (indicator == null) {
            try {
                distTags = future.get();
            }
            catch (Exception exception) {}
        } else {
            while (true) {
                try {
                    distTags = future.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException e) {
                    if (!indicator.isCanceled()) continue;
                    List<Pair<String, SemVer>> list = Collections.emptyList();
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "getCachedOrFetchPackageDistTags"));
                    }
                    return list;
                }
                catch (Exception e) {
                    // empty catch block
                }
                break;
            }
        }
        this.myDistTagsCache.put(packageName, new TimestampedDistTags(distTags));
        List<Object> list = distTags != null ? distTags.getList() : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "getCachedOrFetchPackageDistTags"));
        }
        return list;
    }

    @NotNull
    private Future<DistTags> getOrCreateDistTagsFetchFuture(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NpmRegistryService", "getOrCreateDistTagsFetchFuture"));
        }
        FutureTask<DistTags> newFuture = new FutureTask<DistTags>(() -> {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NpmRegistryService", "lambda$getOrCreateDistTagsFetchFuture$1"));
            }
            DistTags tags = null;
            try {
                tags = NpmRegistryService.fetchPackageDistTags(packageName);
            }
            catch (Throwable t) {
                LOG.info("Failed to fetch dist-tags for package '" + packageName + "'", t);
            }
            finally {
                this.myDistTagsCache.put(packageName, new TimestampedDistTags(tags));
                this.myRunningFutures.remove(packageName);
            }
            return tags;
        });
        Future running = this.myRunningFutures.putIfAbsent(packageName, newFuture);
        if (running != null) {
            Future future = running;
            if (future == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "getOrCreateDistTagsFetchFuture"));
            }
            return future;
        }
        this.myExecutorService.submit(newFuture);
        FutureTask<DistTags> futureTask = newFuture;
        if (futureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "getOrCreateDistTagsFetchFuture"));
        }
        return futureTask;
    }

    @NotNull
    private static DistTags fetchPackageDistTags(@NotNull String packageName) throws IOException {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/packages/NpmRegistryService", "fetchPackageDistTags"));
        }
        String url = "http://registry.npmjs.org/-/package/" + URLUtil.encodeURIComponent((String)packageName) + "/dist-tags";
        long startNano = System.nanoTime();
        String content = HttpRequests.request((String)url).connectTimeout(5000).readTimeout(5000).readString(null);
        JsonReader reader = new JsonReader((Reader)new StringReader(content));
        List<Pair<String, SemVer>> distTags = NpmRegistryService.readDistTags(reader);
        NpmRegistryService.sortDistTags(distTags);
        LOG.info("Found " + distTags.size() + " dist-tags for " + packageName + " in " + TimeoutUtil.getDurationMillis((long)startNano) + "ms");
        DistTags distTags2 = new DistTags(distTags);
        if (distTags2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "fetchPackageDistTags"));
        }
        return distTags2;
    }

    private static void sortDistTags(@NotNull List<Pair<String, SemVer>> distTags) {
        if (distTags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "distTags", "com/jetbrains/nodejs/packages/NpmRegistryService", "sortDistTags"));
        }
        Collections.sort(distTags, (d1, d2) -> {
            String name1 = (String)d1.getFirst();
            String name2 = (String)d2.getFirst();
            if (LATEST_DIST_TAG.equals(name1) != LATEST_DIST_TAG.equals(name2)) {
                return LATEST_DIST_TAG.equals(name1) ? -1 : 1;
            }
            return -1 * ((SemVer)d1.getSecond()).compareTo((SemVer)d2.getSecond());
        });
    }

    @NotNull
    private static List<Pair<String, SemVer>> readDistTags(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/jetbrains/nodejs/packages/NpmRegistryService", "readDistTags"));
        }
        if (reader.peek() != JsonToken.BEGIN_OBJECT) {
            reader.skipValue();
            List<Pair<String, SemVer>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "readDistTags"));
            }
            return list;
        }
        reader.beginObject();
        ArrayList distTags = ContainerUtil.newArrayList();
        while (reader.hasNext()) {
            String distTagName = reader.nextName();
            String versionStr = reader.nextString();
            SemVer version = SemVer.parseFromText((String)versionStr);
            if (version == null) {
                LOG.info("Cannot parse dist-tag version from " + versionStr);
                continue;
            }
            distTags.add(Pair.create((Object)distTagName, (Object)version));
        }
        reader.endObject();
        ArrayList arrayList = distTags;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService", "readDistTags"));
        }
        return arrayList;
    }

    private static class DistTags {
        private final List<Pair<String, SemVer>> myList;

        public DistTags(@NotNull List<Pair<String, SemVer>> list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/nodejs/packages/NpmRegistryService$DistTags", "<init>"));
            }
            this.myList = list;
        }

        @NotNull
        public List<Pair<String, SemVer>> getList() {
            List<Pair<String, SemVer>> list = this.myList;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/packages/NpmRegistryService$DistTags", "getList"));
            }
            return list;
        }
    }

    private static class TimestampedDistTags {
        private final long myCreateTimeNano;
        private final DistTags myDistTags;

        private TimestampedDistTags(@Nullable DistTags distTags) {
            this.myDistTags = distTags;
            this.myCreateTimeNano = System.nanoTime();
        }

        public long getCreateTimeNano() {
            return this.myCreateTimeNano;
        }

        @Nullable
        public DistTags getDistTags() {
            return this.myDistTags;
        }
    }
}

