/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeLocalFileTransfer;
import com.intellij.javascript.nodejs.NodeProfilingRuntimeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.nodejs.execution.NodeProfilingRuntimeConfigurer;
import com.jetbrains.nodejs.run.NodeJSRunConfigurationExtension;
import com.jetbrains.nodejs.run.NodeJSRuntimeSession;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingPanel;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSProfilingRunConfigurationExtension
extends NodeJSRunConfigurationExtension {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.NodeJSProfilingRunConfigurationExtension");

    @Override
    protected NodeJSRunConfigurationExtension.RuntimeSessionHelper createRemoteRuntimeSession(final @NotNull NodeJsRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, final @NotNull NodeFileTransfer fileTransfer) throws ExecutionException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "createRemoteRuntimeSession"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "createRemoteRuntimeSession"));
        }
        if (fileTransfer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTransfer", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "createRemoteRuntimeSession"));
        }
        NodeProfilingSettings settings = runConfiguration.getNodeProfilingSettings();
        if (!settings.isProfile() && !settings.isAllowRuntimeHeapSnapshot()) {
            return null;
        }
        final NodeProfilingRuntimeConfigurer configurer = new NodeProfilingRuntimeConfigurer(runConfiguration, environment, fileTransfer);
        return new MyLocalRuntimeSessionHelper(settings, runConfiguration, configurer, fileTransfer){

            @Override
            public String configureAppFilePath(File localUsualPath, String workingDirectory, NodeJSRuntimeSession executionSession) throws ExecutionException {
                String proxy = super.configureAppFilePath(localUsualPath, workingDirectory, executionSession);
                if (proxy != null) {
                    try {
                        return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                            if (fileTransfer == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTransfer", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension$1", "lambda$configureAppFilePath$1"));
                            }
                            File proxyFile = new File(proxy);
                            String content = FileUtil.loadFile((File)proxyFile);
                            String remoteProxyPath = fileTransfer.copyToRemoteTmpFile(workingDirectory, proxyFile.getName(), content);
                            configurer.registerAfterAction(() -> {
                                if (fileTransfer == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTransfer", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension$1", "lambda$null$0"));
                                }
                                try {
                                    fileTransfer.deleteRemote(remoteProxyPath);
                                }
                                catch (Exception e) {
                                    LOG.info((Throwable)e);
                                }
                            });
                            return remoteProxyPath;
                        }, "Creating V8 Heap Profiling Proxy", false, runConfiguration.getProject());
                    }
                    catch (IOException e) {
                        throw new ExecutionException((Throwable)e);
                    }
                }
                return null;
            }
        };
    }

    @Override
    @Nullable
    protected NodeJSRunConfigurationExtension.RuntimeSessionHelper createLocalRuntimeSession(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "createLocalRuntimeSession"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "createLocalRuntimeSession"));
        }
        NodeProfilingSettings settings = runConfiguration.getNodeProfilingSettings();
        if (!settings.isProfile() && !settings.isAllowRuntimeHeapSnapshot()) {
            return null;
        }
        NodeProfilingRuntimeConfigurer configurer = new NodeProfilingRuntimeConfigurer(runConfiguration, environment, (NodeFileTransfer)new NodeLocalFileTransfer());
        return new MyLocalRuntimeSessionHelper(settings, runConfiguration, configurer, (NodeFileTransfer)NodeLocalFileTransfer.INSTANCE);
    }

    protected void writeExternal(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull Element element) {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "writeExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "writeExternal"));
        }
        runConfiguration.getNodeProfilingSettings().writeExternal(element);
    }

    protected void readExternal(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "readExternal"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "readExternal"));
        }
        NodeProfilingSettings profilingSettings = NodeProfilingSettings.readExternal(element, runConfiguration.getProject());
        runConfiguration.setNodeProfilingSettings(profilingSettings);
    }

    @Override
    @Nullable
    public String getEditorTitle() {
        return "V8 Profiling";
    }

    protected boolean isApplicableFor(@NotNull NodeJsRunConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "isApplicableFor"));
        }
        return true;
    }

    protected boolean isEnabledFor(@NotNull NodeJsRunConfiguration applicableConfiguration, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicableConfiguration", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "isEnabledFor"));
        }
        return true;
    }

    @Override
    @Nullable
    protected <P extends NodeJsRunConfiguration> SettingsEditor<P> createEditor(@NotNull P configuration, @NotNull Getter<NodeJsInterpreter> currentInterpreterGetter, Consumer<NodeJsInterpreterChangeListener> listenerRegistrar) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "createEditor"));
        }
        if (currentInterpreterGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentInterpreterGetter", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension", "createEditor"));
        }
        return new NodeProfilingPanel(currentInterpreterGetter, configuration.getProject());
    }

    private static class MyLocalRuntimeSessionHelper
    implements NodeJSRunConfigurationExtension.RuntimeSessionHelper {
        private final NodeProfilingSettings mySettings;
        private final NodeJsRunConfiguration myRunConfiguration;
        private final NodeProfilingRuntimeConfigurer myConfigurer;
        private final NodeFileTransfer myFileTransfer;
        private final NodeProfilingRuntimeSettings myRuntimeSettings;

        public MyLocalRuntimeSessionHelper(NodeProfilingSettings settings, NodeJsRunConfiguration runConfiguration, NodeProfilingRuntimeConfigurer configurer, NodeFileTransfer fileTransfer) throws ExecutionException {
            this.mySettings = settings;
            this.myRunConfiguration = runConfiguration;
            this.myConfigurer = configurer;
            this.myFileTransfer = fileTransfer;
            try {
                this.myRuntimeSettings = this.mySettings.createRuntimeSettings(this.myRunConfiguration.getProject(), this.myFileTransfer.getMappingFor(this.myRunConfiguration.getWorkingDirectory()), this.myFileTransfer);
                this.myConfigurer.setRuntimeSettings(this.myRuntimeSettings);
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }

        @Override
        public String configureAppFilePath(File localUsualPath, String workingDirectory, NodeJSRuntimeSession executionSession) throws ExecutionException {
            return this.myConfigurer.onCommandLineCreation(this.myFileTransfer.getMappingFor(localUsualPath.getAbsolutePath()), executionSession.getDebugHost());
        }

        @Override
        @NotNull
        public List<String> getNodeParameters() {
            String parameters = this.myRuntimeSettings == null ? null : this.myRuntimeSettings.getNodeParameters();
            List list = StringUtil.isEmptyOrSpaces((String)parameters) ? Collections.emptyList() : ParametersListUtil.parse((String)parameters);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension$MyLocalRuntimeSessionHelper", "getNodeParameters"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<AnAction> getRunDebugActions() {
            List<Object> list = this.myConfigurer.isTakeHeapSnapshots() ? Collections.singletonList(this.myConfigurer.getSnapshotAction()) : Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension$MyLocalRuntimeSessionHelper", "getRunDebugActions"));
            }
            return list;
        }

        @Override
        @NotNull
        public List<Integer> getUsedPorts() {
            if (this.myConfigurer.isTakeHeapSnapshots()) {
                List<Integer> list = Collections.singletonList(this.myRunConfiguration.getNodeProfilingSettings().getInnerPort());
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension$MyLocalRuntimeSessionHelper", "getUsedPorts"));
                }
                return list;
            }
            List<Integer> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJSProfilingRunConfigurationExtension$MyLocalRuntimeSessionHelper", "getUsedPorts"));
            }
            return list;
        }
    }
}

