/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.RunConfigurationExtensionsManager;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.nodejs.NodeFileTransfer;
import com.intellij.javascript.nodejs.NodeLocalFileTransfer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.jetbrains.nodeJs.NodeDebugProgramRunnerKt;
import com.jetbrains.nodejs.run.NodeJSRunConfigurationExtension;
import com.jetbrains.nodejs.run.NodeJSRuntimeSession;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJSRunConfigurationExtensionsManager
extends RunConfigurationExtensionsManager<NodeJsRunConfiguration, NodeJSRunConfigurationExtension> {
    public NodeJSRunConfigurationExtensionsManager() {
        super(NodeJSRunConfigurationExtension.EP_NAME);
    }

    public static NodeJSRunConfigurationExtensionsManager getInstance() {
        return (NodeJSRunConfigurationExtensionsManager)((Object)ServiceManager.getService(NodeJSRunConfigurationExtensionsManager.class));
    }

    public NodeJSRuntimeSession createRuntimeSession(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (runConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager", "createRuntimeSession"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager", "createRuntimeSession"));
        }
        return new MyRuntimeSessionHelper(runConfiguration, environment, this.createFileTransfer(runConfiguration));
    }

    public void appendEditorsNode(@NotNull NodeJsRunConfiguration configuration, @NotNull SettingsEditorGroup<NodeJsRunConfiguration> group, @NotNull NodeJsRunConfiguration.NodeJSRunConfigurationSettings settings) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager", "appendEditorsNode"));
        }
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager", "appendEditorsNode"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager", "appendEditorsNode"));
        }
        Consumer listenerRegistrar = listener -> {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager", "lambda$appendEditorsNode$0"));
            }
            settings.addListener((NodeJsInterpreterChangeListener)listener);
        };
        ArrayList extensions = new ArrayList(this.getApplicableExtensions((RunConfigurationBase)configuration));
        Collections.sort(extensions, (o1, o2) -> new Integer(o1.getEditorPriority()).compareTo(o2.getEditorPriority()));
        for (NodeJSRunConfigurationExtension extension : extensions) {
            SettingsEditor<NodeJsRunConfiguration> editor = extension.createEditor(configuration, settings.getPathProvider(), (Consumer<NodeJsInterpreterChangeListener>)listenerRegistrar);
            if (editor == null) continue;
            if (extension.showEditorInMainPage(configuration)) {
                settings.addChildComponent(editor);
                continue;
            }
            group.addEditor(extension.getEditorTitle(), editor);
        }
    }

    @NotNull
    public NodeFileTransfer createFileTransfer(@NotNull NodeJsRunConfiguration configuration) throws ExecutionException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager", "createFileTransfer"));
        }
        for (NodeJSRunConfigurationExtension extension : this.getApplicableExtensions((RunConfigurationBase)configuration)) {
            NodeFileTransfer transfer = extension.overrideFileTransfer(configuration);
            if (transfer == null) continue;
            NodeFileTransfer nodeFileTransfer = transfer;
            if (nodeFileTransfer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager", "createFileTransfer"));
            }
            return nodeFileTransfer;
        }
        NodeLocalFileTransfer nodeLocalFileTransfer = NodeLocalFileTransfer.INSTANCE;
        if (nodeLocalFileTransfer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager", "createFileTransfer"));
        }
        return nodeLocalFileTransfer;
    }

    public void checkConfiguration(@NotNull NodeJsRunConfiguration configuration, @NotNull String nodePath) throws RuntimeConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager", "checkConfiguration"));
        }
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager", "checkConfiguration"));
        }
        for (NodeJSRunConfigurationExtension extension : this.getApplicableExtensions((RunConfigurationBase)configuration)) {
            extension.checkConfiguration(configuration, nodePath);
        }
    }

    private class MyRuntimeSessionHelper
    implements NodeJSRuntimeSession {
        @NotNull
        private final NodeJsRunConfiguration myRunConfiguration;
        @NotNull
        private final NodeFileTransfer myFileTransfer;
        private final List<NodeJSRunConfigurationExtension.RuntimeSessionHelper> mySessions;
        private String myWorkingDirectory;

        public MyRuntimeSessionHelper(@NotNull NodeJsRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, NodeFileTransfer fileTransfer) throws ExecutionException {
            if (runConfiguration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runConfiguration", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager$MyRuntimeSessionHelper", "<init>"));
            }
            if (environment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager$MyRuntimeSessionHelper", "<init>"));
            }
            if (fileTransfer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTransfer", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager$MyRuntimeSessionHelper", "<init>"));
            }
            this.myRunConfiguration = runConfiguration;
            this.myFileTransfer = fileTransfer;
            this.mySessions = new ArrayList<NodeJSRunConfigurationExtension.RuntimeSessionHelper>();
            this.myWorkingDirectory = StringUtil.notNullize((String)this.myRunConfiguration.getWorkingDirectory());
            if (!this.myFileTransfer.isLocal() && !StringUtil.isEmptyOrSpaces((String)this.myWorkingDirectory)) {
                this.myWorkingDirectory = this.myFileTransfer.getMappingFor(this.myWorkingDirectory);
            }
            for (NodeJSRunConfigurationExtension extension : NodeJSRunConfigurationExtensionsManager.this.getApplicableExtensions((RunConfigurationBase)this.myRunConfiguration)) {
                NodeJSRunConfigurationExtension.RuntimeSessionHelper session = fileTransfer.isLocal() ? extension.createLocalRuntimeSession(runConfiguration, environment) : extension.createRemoteRuntimeSession(runConfiguration, environment, fileTransfer);
                if (session == null) continue;
                this.mySessions.add(session);
            }
        }

        @Override
        public String configureAppFilePath(File localUsualPath, String workingDirectory, NodeJSRuntimeSession executionSession) throws ExecutionException {
            String path = null;
            for (NodeJSRunConfigurationExtension.RuntimeSessionHelper session : this.mySessions) {
                String appFilePath = session.configureAppFilePath(localUsualPath, this.myWorkingDirectory, this);
                if (appFilePath == null) continue;
                path = appFilePath;
            }
            if (path != null) {
                return path;
            }
            return this.myFileTransfer.isLocal() ? localUsualPath.getAbsolutePath() : this.myFileTransfer.getMappingFor(localUsualPath.getAbsolutePath());
        }

        @Override
        public void configuredAppPath(@Nullable String configuredPath) throws ExecutionException {
            for (NodeJSRunConfigurationExtension.RuntimeSessionHelper session : this.mySessions) {
                session.configuredAppPath(configuredPath);
            }
        }

        @Override
        @NotNull
        public List<String> getNodeParameters() {
            SmartList list = new SmartList();
            for (NodeJSRunConfigurationExtension.RuntimeSessionHelper session : this.mySessions) {
                list.addAll(session.getNodeParameters());
            }
            SmartList smartList = list;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager$MyRuntimeSessionHelper", "getNodeParameters"));
            }
            return smartList;
        }

        @Override
        @NotNull
        public List<AnAction> getRunDebugActions() {
            SmartList list = new SmartList();
            for (NodeJSRunConfigurationExtension.RuntimeSessionHelper session : this.mySessions) {
                list.addAll(session.getRunDebugActions());
            }
            SmartList smartList = list;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJSRunConfigurationExtensionsManager$MyRuntimeSessionHelper", "getRunDebugActions"));
            }
            return smartList;
        }

        public List<Integer> getUsedPorts() {
            SmartList list = new SmartList();
            for (NodeJSRunConfigurationExtension.RuntimeSessionHelper session : this.mySessions) {
                list.addAll(session.getUsedPorts());
            }
            return list;
        }

        @Override
        public ProcessHandler createProcessHandler(GeneralCommandLine commandLine, int debugPort, List<Integer> openPorts) throws ExecutionException {
            NodeJSRunConfigurationExtension.RuntimeSessionHelper session;
            List<Integer> extendedPorts = this.getUsedPorts();
            extendedPorts.addAll(openPorts);
            this.setWorkingDirectory(commandLine);
            ProcessHandler handler = null;
            Iterator<NodeJSRunConfigurationExtension.RuntimeSessionHelper> iterator = this.mySessions.iterator();
            while (iterator.hasNext() && (handler = (session = iterator.next()).createProcessHandler(commandLine, debugPort, extendedPorts)) == null) {
            }
            if (handler == null) {
                handler = NodeDebugProgramRunnerKt.createProcessHandler((GeneralCommandLine)commandLine);
            }
            this.onProcessStarted(handler);
            return handler;
        }

        private void setWorkingDirectory(GeneralCommandLine commandLine) throws ExecutionException {
            commandLine.withWorkDirectory(this.myWorkingDirectory);
        }

        private void onProcessStarted(ProcessHandler processHandler) {
            for (NodeJSRunConfigurationExtension.RuntimeSessionHelper session : this.mySessions) {
                session.onProcessStarted(processHandler);
            }
        }

        @Override
        @Nullable
        public String getDebugHost() {
            for (NodeJSRunConfigurationExtension.RuntimeSessionHelper session : this.mySessions) {
                String host = session.getDebugHost();
                if (host == null) continue;
                return host;
            }
            return null;
        }
    }
}

