/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunProfileWithCompileBeforeLaunchOption;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.CredentialsTypeEx;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBPanel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.PathKt;
import com.intellij.util.net.NetUtils;
import com.intellij.util.ui.FormBuilder;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.nodeJs.NodeDebugProgramRunnerKt;
import com.jetbrains.nodeJs.NodeJSDebuggableConfiguration;
import com.jetbrains.nodejs.NodeModuleManager;
import com.jetbrains.nodejs.execution.NodeCommandLineState;
import com.jetbrains.nodejs.run.NodeJSRunConfigurationExtensionsManager;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationRefactoringHandler;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationType;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import com.jetbrains.nodejs.util.RelativePathUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsRunConfiguration
extends LocatableConfigurationBase
implements NodeJSDebuggableConfiguration,
RefactoringListenerProvider,
DebuggableProcessRunConfiguration,
RunProfileWithCompileBeforeLaunchOption {
    private static final String PATH_TO_NODE = "path-to-node";
    private static final String NODE_PARAMETERS = "node-parameters";
    private static final String PATH_TO_JS_FILE = "path-to-js-file";
    private static final String APPLICATION_PARAMETERS = "application-parameters";
    private static final String APPLICATION_WORKING_DIR = "working-dir";
    @NotNull
    private String workingDir = "";
    @NotNull
    private NodeJsInterpreterRef myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
    private String pathToJsFile;
    private String applicationParameters;
    private String nodeParameters;
    @NotNull
    private StartBrowserSettings myStartBrowserSettings = new StartBrowserSettings();
    @NotNull
    private NodeProfilingSettings myNodeProfilingSettings;
    @NotNull
    private EnvironmentVariablesData myEnvData = EnvironmentVariablesData.DEFAULT;

    protected NodeJsRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
        this.myNodeProfilingSettings = new NodeProfilingSettings();
    }

    @NotNull
    public String getWorkingDirectory() {
        String string = this.workingDir;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "getWorkingDirectory"));
        }
        return string;
    }

    public void setWorkingDirectory(@Nullable String workingDir) {
        this.workingDir = StringUtil.notNullize((String)workingDir);
    }

    @NotNull
    public StartBrowserSettings getStartBrowserSettings() {
        StartBrowserSettings startBrowserSettings = this.myStartBrowserSettings;
        if (startBrowserSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "getStartBrowserSettings"));
        }
        return startBrowserSettings;
    }

    public void setStartBrowserSettings(@NotNull StartBrowserSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "setStartBrowserSettings"));
        }
        this.myStartBrowserSettings = settings;
    }

    @NotNull
    public NodeProfilingSettings getNodeProfilingSettings() {
        NodeProfilingSettings nodeProfilingSettings = this.myNodeProfilingSettings;
        if (nodeProfilingSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "getNodeProfilingSettings"));
        }
        return nodeProfilingSettings;
    }

    public void setNodeProfilingSettings(@NotNull NodeProfilingSettings nodeProfilingSettings) {
        if (nodeProfilingSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeProfilingSettings", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "setNodeProfilingSettings"));
        }
        this.myNodeProfilingSettings = nodeProfilingSettings;
    }

    public RunConfiguration clone() {
        NodeJsRunConfiguration clone = (NodeJsRunConfiguration)super.clone();
        clone.myInterpreterRef = this.myInterpreterRef;
        if (clone.workingDir.isEmpty()) {
            clone.workingDir = StringUtil.notNullize((String)this.getProject().getBasePath());
        }
        clone.myNodeProfilingSettings = new NodeProfilingSettings(this.myNodeProfilingSettings);
        return clone;
    }

    @NotNull
    public SettingsEditor<NodeJsRunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        NodeJSRunConfigurationSettings settings = new NodeJSRunConfigurationSettings(this.getProject());
        group.addEditor("Configuration", (SettingsEditor)settings);
        NodeJSRunConfigurationExtensionsManager.getInstance().appendEditorsNode(this, (SettingsEditorGroup<NodeJsRunConfiguration>)group, settings);
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "getConfigurationEditor"));
        }
        return settingsEditorGroup;
    }

    public boolean isCompileBeforeLaunchAddedByDefault() {
        return false;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "getState"));
        }
        if (executionEnvironment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executionEnvironment", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "getState"));
        }
        return this.createState(executionEnvironment);
    }

    @NotNull
    private RunProfileState createState(@NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "createState"));
        }
        NodeCommandLineState nodeCommandLineState = new NodeCommandLineState(environment, this);
        if (nodeCommandLineState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "createState"));
        }
        return nodeCommandLineState;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        NodeJsInterpreter interpreter = this.getInterpreter();
        if (interpreter == null) {
            throw new RuntimeConfigurationException("Please specify Node.js interpreter");
        }
        String interpreterError = interpreter.validate(this.getProject());
        if (interpreterError != null) {
            throw new RuntimeConfigurationException(interpreterError);
        }
        NodeJSRunConfigurationExtensionsManager.getInstance().checkConfiguration(this, this.myInterpreterRef.getReferenceName());
        Path workingDir = Paths.get(this.workingDir, new String[0]);
        if (!workingDir.isAbsolute() || !Files.isDirectory(workingDir, new LinkOption[0])) {
            throw new RuntimeConfigurationError("Please specify working directory correctly.");
        }
        if (this.pathToJsFile != null) {
            BasicFileAttributes attributes;
            if (ScriptFileUtil.isMemoryScriptPath((String)this.pathToJsFile) && ScriptFileUtil.findScriptFileByPath((String)this.pathToJsFile) == null) {
                throw new RuntimeConfigurationError("Cannot find script file");
            }
            Path jsFile = Paths.get(this.pathToJsFile, new String[0]);
            boolean ok = false;
            if (jsFile.isAbsolute()) {
                attributes = PathKt.basicAttributesIfExists((Path)jsFile);
                boolean bl = ok = attributes != null && (attributes.isRegularFile() || attributes.isSymbolicLink());
            }
            if (!ok) {
                jsFile = workingDir.resolve(this.pathToJsFile);
                attributes = PathKt.basicAttributesIfExists((Path)jsFile);
                boolean bl = ok = attributes != null && (attributes.isRegularFile() || attributes.isSymbolicLink());
                if (!ok) {
                    throw new RuntimeConfigurationError("Please specify path to JavaScript file correctly");
                }
            }
        }
        if (this.myStartBrowserSettings.isSelected() && this.myStartBrowserSettings.getUrl() == null) {
            throw new RuntimeConfigurationError("Startup page is empty");
        }
        this.myNodeProfilingSettings.check(this.getProject(), interpreter);
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.myInterpreterRef.resolve(this.getProject());
    }

    public String suggestedName() {
        return PathUtilRt.getFileName((String)this.pathToJsFile);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        String interpreterReferenceName = element.getAttributeValue(PATH_TO_NODE);
        this.myInterpreterRef = interpreterReferenceName == null ? NodeJsInterpreterRef.createProjectRef() : NodeJsInterpreterRef.create((String)interpreterReferenceName);
        String savedPathToJsFile = element.getAttributeValue(PATH_TO_JS_FILE);
        if (savedPathToJsFile != null) {
            this.setInputPath(savedPathToJsFile);
        }
        this.setApplicationParameters(element.getAttributeValue(APPLICATION_PARAMETERS));
        this.setProgramParameters(element.getAttributeValue(NODE_PARAMETERS));
        String savedApplicationWorkingDir = element.getAttributeValue(APPLICATION_WORKING_DIR);
        if (savedApplicationWorkingDir != null) {
            this.workingDir = FileUtil.toSystemDependentName((String)savedApplicationWorkingDir);
        }
        this.myEnvData = EnvironmentVariablesData.readExternal((Element)element);
        this.myStartBrowserSettings = StartBrowserSettings.readExternal((Element)element);
        this.myNodeProfilingSettings = NodeProfilingSettings.readExternal(element, this.getProject());
        this.migrateCoffeeScriptSupport(element);
        NodeJSRunConfigurationExtensionsManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    private void migrateCoffeeScriptSupport(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "migrateCoffeeScriptSupport"));
        }
        if (Boolean.parseBoolean(element.getAttributeValue("coffeescript-run"))) {
            this.addCoffeeScriptNodeOptionIfNeeded();
        }
    }

    public void addCoffeeScriptNodeOptionIfNeeded() {
        if (this.pathToJsFile == null || !this.pathToJsFile.endsWith(".coffee")) {
            return;
        }
        String nodeOption = "--require coffee-script/register";
        if (this.nodeParameters == null) {
            this.nodeParameters = nodeOption;
        } else if (!this.nodeParameters.contains(nodeOption)) {
            if (!this.nodeParameters.endsWith(" ")) {
                this.nodeParameters = this.nodeParameters + " ";
            }
            this.nodeParameters = this.nodeParameters + nodeOption;
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (!this.myInterpreterRef.getReferenceName().isEmpty()) {
            element.setAttribute(PATH_TO_NODE, this.myInterpreterRef.getReferenceName());
        }
        if (this.pathToJsFile != null) {
            element.setAttribute(PATH_TO_JS_FILE, FileUtil.toSystemIndependentName((String)this.pathToJsFile));
        }
        if (this.applicationParameters != null) {
            element.setAttribute(APPLICATION_PARAMETERS, this.applicationParameters);
        }
        if (this.nodeParameters != null) {
            element.setAttribute(NODE_PARAMETERS, this.nodeParameters);
        }
        element.setAttribute(APPLICATION_WORKING_DIR, FileUtil.toSystemIndependentName((String)this.workingDir));
        if (!EnvironmentVariablesData.DEFAULT.equals((Object)this.myEnvData)) {
            this.myEnvData.writeExternal(element);
        }
        this.myStartBrowserSettings.writeExternal(element);
        this.myNodeProfilingSettings.writeExternal(element);
        NodeJSRunConfigurationExtensionsManager.getInstance().writeExternal((RunConfigurationBase)this, element);
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return NodeJsRunConfigurationRefactoringHandler.createRefactoringElementListener(this, element);
    }

    @Nullable
    public String getProgramParameters() {
        return this.nodeParameters;
    }

    public void setProgramParameters(@Nullable String value) {
        this.nodeParameters = StringUtil.nullize((String)value);
    }

    @Nullable
    public String getApplicationParameters() {
        return this.applicationParameters;
    }

    public void setApplicationParameters(@Nullable String applicationParameters) {
        this.applicationParameters = StringUtil.nullize((String)applicationParameters);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map map = this.myEnvData.getEnvs();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "getEnvs"));
        }
        return map;
    }

    public boolean isPassParentEnvs() {
        return this.myEnvData.isPassParentEnvs();
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "getEnvData"));
        }
        return environmentVariablesData;
    }

    @NotNull
    public Module[] getModules() {
        if (Module.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "getModules"));
        }
        return Module.EMPTY_ARRAY;
    }

    @Nullable
    public static NodeJsRunConfiguration getDefaultRunConfiguration(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "getDefaultRunConfiguration"));
        }
        ConfigurationFactory configurationFactory = NodeJsRunConfigurationType.getInstance().getFactory();
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings settings = runManager.getConfigurationTemplate(configurationFactory);
        return (NodeJsRunConfiguration)((Object)ObjectUtils.tryCast((Object)settings.getConfiguration(), NodeJsRunConfiguration.class));
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myEnvData = EnvironmentVariablesData.create((Map)this.myEnvData.getEnvs(), (boolean)passParentEnvs);
    }

    @Nullable
    public String getExePath() {
        return PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)this.getRawExePath()));
    }

    public String getRawExePath() {
        NodeJsInterpreter interpreter = this.getInterpreter();
        if (interpreter == null) {
            return "";
        }
        return interpreter.getOldPath();
    }

    @Nullable
    public String getInputPath() {
        return PathUtil.toSystemIndependentName((String)this.pathToJsFile);
    }

    public void setInputPath(@Nullable String value) {
        this.pathToJsFile = (value = StringUtil.nullize((String)value)) == null ? null : (ScriptFileUtil.isMemoryScriptPath((String)value) ? value : FileUtilRt.toSystemDependentName((String)value));
    }

    @Nullable
    public String getEffectiveExePath() throws ExecutionException {
        NodeJSRemoteInterpreterManager manager;
        NodeJsInterpreter interpreter = this.getInterpreter();
        NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)interpreter);
        if (remoteInterpreter != null && (manager = NodeJSRemoteInterpreterManager.getInstanceOrPrompt((String)"Node.js Run Configuration")) != null) {
            try {
                RemoteSdkAdditionalData data = manager.getRemoteSdkAdditionalData(this.getProject(), remoteInterpreter.getRemoteUrl());
                CredentialsType type = data.getRemoteConnectionType();
                boolean isExtended = type instanceof CredentialsTypeEx;
                if (!isExtended || ((CredentialsTypeEx)type).useRemoteCredentials()) {
                    return StringUtil.nullize((String)data.getRemoteSdkCredentials(this.getProject(), true).getInterpreterPath());
                }
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        return StringUtil.nullize((String)this.getRawExePath());
    }

    @Nullable
    public String getEffectiveWorkingDirectory() {
        return PathUtil.toSystemDependentName((String)StringUtil.nullize((String)this.getWorkingDirectory()));
    }

    @NotNull
    public String correctExePath(@NotNull String exePath) {
        if (exePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exePath", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "correctExePath"));
        }
        String string = exePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "correctExePath"));
        }
        return string;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (socketAddress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "socketAddress", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "createDebugProcess"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "createDebugProcess"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "createDebugProcess"));
        }
        XDebugProcess xDebugProcess = NodeDebugProgramRunnerKt.createDebugProcess((NodeJSDebuggableConfiguration)this, (InetSocketAddress)socketAddress, (XDebugSession)session, (ExecutionResult)executionResult, (boolean)true);
        if (xDebugProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "createDebugProcess"));
        }
        return xDebugProcess;
    }

    @NotNull
    public InetSocketAddress computeDebugAddress(RunProfileState state) throws ExecutionException {
        InetSocketAddress inetSocketAddress;
        block5: {
            block3: {
                InetSocketAddress inetSocketAddress2;
                block4: {
                    try {
                        String host;
                        if (!(state instanceof NodeCommandLineState) || (host = ((NodeCommandLineState)state).getDebugHost()) == null) break block3;
                        inetSocketAddress2 = new InetSocketAddress(host, NetUtils.findAvailableSocketPort());
                        if (inetSocketAddress2 != null) break block4;
                    }
                    catch (IOException e) {
                        throw new ExecutionException("Cannot find available port", (Throwable)e);
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "computeDebugAddress"));
                }
                return inetSocketAddress2;
            }
            inetSocketAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), NetUtils.findAvailableSocketPort());
            if (inetSocketAddress != null) break block5;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "computeDebugAddress"));
        }
        return inetSocketAddress;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "setEnvs"));
        }
        this.myEnvData = EnvironmentVariablesData.create(envs, (boolean)this.myEnvData.isPassParentEnvs());
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "canRun"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "profile", "com/jetbrains/nodejs/run/NodeJsRunConfiguration", "canRun"));
        }
        return this.pathToJsFile == null || !this.pathToJsFile.endsWith(".coffee");
    }

    public static class NodeJSRunConfigurationSettings
    extends SettingsEditor<NodeJsRunConfiguration> {
        private final Getter<NodeJsInterpreter> myPathProvider;
        private JPanel panel;
        private TextFieldWithBrowseButton pathToJSFile;
        private TextFieldWithBrowseButton workingDir;
        private RawCommandLineEditor applicationParametersTextField;
        private RawCommandLineEditor nodeParameters;
        private EnvironmentVariablesComponent myEnvVariablesComponent;
        private JComponent pathToNode;
        private JPanel myChildContainer;
        private NodeJsInterpreterField myInterpreterField;
        private final Project myProject;
        private final List<NodeJsInterpreterChangeListener> myListeners;
        private FormBuilder myChildBuilder;
        private ArrayList<SettingsEditor<NodeJsRunConfiguration>> myEmbeddedEditors;

        NodeJSRunConfigurationSettings(Project project) {
            this.myProject = project;
            this.myPathProvider = () -> this.myInterpreterField.getInterpreter();
            this.$$$setupUI$$$();
            this.myListeners = new ArrayList<NodeJsInterpreterChangeListener>();
            this.myChildBuilder = new FormBuilder();
            this.myEmbeddedEditors = new ArrayList();
        }

        public Getter<NodeJsInterpreter> getPathProvider() {
            return this.myPathProvider;
        }

        public void addChildComponent(@NotNull SettingsEditor<NodeJsRunConfiguration> embeddedEditor) {
            if (embeddedEditor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "embeddedEditor", "com/jetbrains/nodejs/run/NodeJsRunConfiguration$NodeJSRunConfigurationSettings", "addChildComponent"));
            }
            this.myEmbeddedEditors.add(embeddedEditor);
            this.myChildBuilder.addComponent(embeddedEditor.getComponent());
            this.myChildContainer.removeAll();
            this.myChildContainer.add((Component)this.myChildBuilder.getPanel(), "Center");
        }

        protected void resetEditorFrom(@NotNull NodeJsRunConfiguration configuration) {
            if (configuration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/nodejs/run/NodeJsRunConfiguration$NodeJSRunConfigurationSettings", "resetEditorFrom"));
            }
            this.myInterpreterField.setInterpreterRef(configuration.myInterpreterRef);
            this.workingDir.getTextField().setText(configuration.workingDir);
            this.pathToJSFile.getTextField().setText(configuration.pathToJsFile);
            this.applicationParametersTextField.setText(configuration.applicationParameters);
            this.nodeParameters.setText(configuration.nodeParameters);
            this.myEnvVariablesComponent.setEnvData(configuration.myEnvData);
            for (SettingsEditor<NodeJsRunConfiguration> editor : this.myEmbeddedEditors) {
                editor.resetFrom((Object)configuration);
            }
        }

        protected void applyEditorTo(@NotNull NodeJsRunConfiguration nodeJSRunConfiguration) throws ConfigurationException {
            if (nodeJSRunConfiguration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeJSRunConfiguration", "com/jetbrains/nodejs/run/NodeJsRunConfiguration$NodeJSRunConfigurationSettings", "applyEditorTo"));
            }
            nodeJSRunConfiguration.myInterpreterRef = this.myInterpreterField.getInterpreterRef();
            nodeJSRunConfiguration.setInputPath(this.pathToJSFile.getTextField().getText());
            nodeJSRunConfiguration.workingDir = StringUtil.notNullize((String)this.workingDir.getTextField().getText());
            nodeJSRunConfiguration.setApplicationParameters(this.applicationParametersTextField.getText());
            nodeJSRunConfiguration.setProgramParameters(this.nodeParameters.getText());
            nodeJSRunConfiguration.myEnvData = this.myEnvVariablesComponent.getEnvData();
            NodeModuleManager.getInstance(this.myProject).dropNodePathCache();
            for (SettingsEditor<NodeJsRunConfiguration> editor : this.myEmbeddedEditors) {
                editor.applyTo((Object)nodeJSRunConfiguration);
            }
        }

        @NotNull
        protected JComponent createEditor() {
            JPanel jPanel = this.panel;
            if (jPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration$NodeJSRunConfigurationSettings", "createEditor"));
            }
            return jPanel;
        }

        public void addListener(@NotNull NodeJsInterpreterChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/nodejs/run/NodeJsRunConfiguration$NodeJSRunConfigurationSettings", "addListener"));
            }
            this.myListeners.add(listener);
        }

        private void createUIComponents() {
            this.myChildContainer = new JBPanel((LayoutManager)new BorderLayout());
            this.myInterpreterField = new NodeJsInterpreterField(this.myProject, true);
            this.myInterpreterField.addChangeListener(new NodeJsInterpreterChangeListener(){

                public void interpreterChanged(@Nullable NodeJsInterpreter newInterpreter) {
                    for (NodeJsInterpreterChangeListener listener : myListeners) {
                        listener.interpreterChanged(newInterpreter);
                    }
                }
            });
            this.pathToNode = this.myInterpreterField;
            this.workingDir = NodeJSRunConfigurationSettings.createWorkingDirectory(this.myProject, (Disposable)this);
            this.pathToJSFile = NodeJSRunConfigurationSettings.createPathToJsFile(this.myProject, this.workingDir.getTextField());
        }

        protected void disposeEditor() {
            super.disposeEditor();
            for (SettingsEditor<NodeJsRunConfiguration> editor : this.myEmbeddedEditors) {
                Disposer.dispose(editor);
            }
            this.myListeners.clear();
        }

        @NotNull
        private static TextFieldWithBrowseButton createWorkingDirectory(@NotNull Project project, @NotNull Disposable parent) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/NodeJsRunConfiguration$NodeJSRunConfigurationSettings", "createWorkingDirectory"));
            }
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/nodejs/run/NodeJsRunConfiguration$NodeJSRunConfigurationSettings", "createWorkingDirectory"));
            }
            TextFieldWithBrowseButton workingDir = new TextFieldWithBrowseButton();
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            workingDir.addBrowseFolderListener(null, null, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
            FileChooserFactory.getInstance().installFileCompletion(workingDir.getTextField(), descriptor, false, parent);
            TextFieldWithBrowseButton textFieldWithBrowseButton = workingDir;
            if (textFieldWithBrowseButton == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration$NodeJSRunConfigurationSettings", "createWorkingDirectory"));
            }
            return textFieldWithBrowseButton;
        }

        @NotNull
        private static TextFieldWithBrowseButton createPathToJsFile(@NotNull Project project, @NotNull JTextField workingDir) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/NodeJsRunConfiguration$NodeJSRunConfigurationSettings", "createPathToJsFile"));
            }
            if (workingDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/jetbrains/nodejs/run/NodeJsRunConfiguration$NodeJSRunConfigurationSettings", "createPathToJsFile"));
            }
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
            TextFieldWithBrowseButton pathToJSFile = RelativePathUIUtil.createRelativePathTextFieldAndTrackBaseDirChanges(project, descriptor, workingDir.getDocument());
            pathToJSFile.addBrowseFolderListener(null, null, project, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
            TextFieldWithBrowseButton textFieldWithBrowseButton = pathToJSFile;
            if (textFieldWithBrowseButton == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/NodeJsRunConfiguration$NodeJSRunConfigurationSettings", "createPathToJsFile"));
            }
            return textFieldWithBrowseButton;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            RawCommandLineEditor rawCommandLineEditor;
            RawCommandLineEditor rawCommandLineEditor2;
            EnvironmentVariablesComponent environmentVariablesComponent;
            JPanel jPanel;
            this.createUIComponents();
            this.panel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JLabel jLabel = new JLabel();
            jLabel.setText("Node interpreter:");
            jLabel.setDisplayedMnemonic('O');
            jLabel.setDisplayedMnemonicIndex(1);
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("JavaScript file:");
            jLabel2.setDisplayedMnemonic('F');
            jLabel2.setDisplayedMnemonicIndex(11);
            jPanel.add((Component)jLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel3 = new JLabel();
            jLabel3.setText("Application parameters:");
            jLabel3.setDisplayedMnemonic('A');
            jLabel3.setDisplayedMnemonicIndex(0);
            jPanel.add((Component)jLabel3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel4 = new JLabel();
            jLabel4.setText("Node parameters:");
            jLabel4.setDisplayedMnemonic('P');
            jLabel4.setDisplayedMnemonicIndex(5);
            jPanel.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myEnvVariablesComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
            environmentVariablesComponent.setLabelLocation("West");
            jPanel.add((Component)environmentVariablesComponent, new GridConstraints(5, 0, 1, 3, 0, 1, 3, 3, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(7, 2, 1, 1, 0, 2, 1, 6, null, null, null));
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.pathToJSFile;
            jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 2, 1, 1, 0, 1, 2, 0, null, null, null));
            JLabel jLabel5 = new JLabel();
            jLabel5.setText("Working directory:");
            jLabel5.setDisplayedMnemonic('D');
            jLabel5.setDisplayedMnemonicIndex(8);
            jPanel.add((Component)jLabel5, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.workingDir;
            jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 2, 1, 1, 0, 1, 2, 0, null, null, null));
            this.nodeParameters = rawCommandLineEditor2 = new RawCommandLineEditor();
            rawCommandLineEditor2.setDialogCaption("Node Parameters");
            jPanel.add((Component)rawCommandLineEditor2, new GridConstraints(1, 2, 1, 1, 0, 1, 7, 0, null, null, null));
            this.applicationParametersTextField = rawCommandLineEditor = new RawCommandLineEditor();
            rawCommandLineEditor.setDialogCaption("Application Parameters");
            jPanel.add((Component)rawCommandLineEditor, new GridConstraints(4, 2, 1, 1, 0, 1, 7, 0, null, null, null));
            JComponent jComponent = this.pathToNode;
            jPanel.add((Component)jComponent, new GridConstraints(0, 2, 1, 1, 1, 1, 7, 0, null, null, null));
            JPanel jPanel2 = this.myChildContainer;
            jPanel.add((Component)jPanel2, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
            jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
            environmentVariablesComponent.setAnchor((JComponent)jLabel3);
            jLabel5.setLabelFor((Component)textFieldWithBrowseButton2);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.panel;
        }
    }
}

