/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.calculation;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.cpu.calculation.Pause;
import com.jetbrains.nodejs.run.profile.cpu.calculation.PlotSizeParameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlotParameters {
    public static final PlotSizeParameters ourDefault = new PlotSizeParameters(1600, 700, 10, 9, 11, 99, -3, -1, -1);
    @NonNls
    private static final String SIZE = "size ";
    private int myWidthPixels;
    private int myHeightPixels;
    private float myXStart;
    private float myXEnd;
    private int myLeftBound;
    private int myRightBound;
    private float myOnePoint;
    private List<Pause> myPauses;
    private final PlotSizeParameters myParameters;

    public PlotParameters(@NotNull List<String> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters", "<init>"));
        }
        this(lines, null);
    }

    public PlotParameters(@NotNull List<String> lines, @Nullable PlotSizeParameters forcedSize) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters", "<init>"));
        }
        this.myWidthPixels = -1;
        this.myHeightPixels = -1;
        this.myXStart = -1.0f;
        this.myXEnd = -1.0f;
        this.myParameters = forcedSize == null ? ourDefault : forcedSize;
        ArrayList<ChartCorrector> processors = new ArrayList<ChartCorrector>();
        ImageSizeCorrector imageSizeCorrector = new ImageSizeCorrector(forcedSize != null, this.myParameters);
        processors.add(imageSizeCorrector);
        XRangeCorrector rangeCorrector = new XRangeCorrector(this.myParameters);
        processors.add(rangeCorrector);
        LabelCorrector labelCorrector = new LabelCorrector(this.myParameters);
        processors.add(labelCorrector);
        if (!this.processLines(lines, processors)) {
            return;
        }
        this.myWidthPixels = imageSizeCorrector.getWidthPixels();
        this.myHeightPixels = imageSizeCorrector.getHeightPixels();
        this.myXStart = rangeCorrector.getXStart();
        this.myXEnd = rangeCorrector.getXEnd();
        this.myLeftBound = (int)((double)this.myWidthPixels / 100.0) * this.myParameters.getLeftMarginPercent();
        this.myRightBound = (int)((double)this.myWidthPixels / 100.0) * this.myParameters.getRightMarginPercent();
        float realInterval = this.myXEnd - this.myXStart;
        int plotPixels = this.myWidthPixels - this.myLeftBound - (this.myWidthPixels - this.myRightBound);
        this.myOnePoint = realInterval / (float)plotPixels;
        this.myPauses = labelCorrector.getPauses();
        for (Pause pause : this.myPauses) {
            pause.setTsPoints(this.getPixels(pause.getTs()));
        }
        Collections.sort(this.myPauses, (o1, o2) -> Integer.valueOf(o2.getTsPoints()).compareTo(o1.getTsPoints()));
    }

    public boolean isOk() {
        return this.myWidthPixels > 0 && this.myHeightPixels > 0 && this.myXStart > 0.0f && this.myXEnd > 0.0f;
    }

    private boolean processLines(@NotNull List<String> lines, List<ChartCorrector> processors) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters", "processLines"));
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            int finalI = i;
            Consumer changeConsumer = newLine -> {
                if (lines == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters", "lambda$processLines$1"));
                }
                lines.set(finalI, (String)newLine);
            };
            Consumer insertConsumer = insertedLines -> {
                if (lines == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters", "lambda$processLines$2"));
                }
                if (((String[])insertedLines).length > 0) {
                    lines.addAll(finalI, Arrays.asList(insertedLines));
                }
            };
            Iterator<ChartCorrector> iterator = processors.iterator();
            while (iterator.hasNext()) {
                ChartCorrector chartCorrector = iterator.next();
                if (chartCorrector.processLine(line, (Consumer<String>)changeConsumer, (Consumer<String[]>)insertConsumer)) continue;
                if (!chartCorrector.chartIsValid()) {
                    return false;
                }
                iterator.remove();
            }
            if (processors.isEmpty()) break;
        }
        return !processors.isEmpty();
    }

    public Pair<Integer, Integer> getSize() {
        return Pair.create((Object)this.myWidthPixels, (Object)this.myHeightPixels);
    }

    private static String percentToString(int percent) {
        return percent < 10 ? "0" + percent : String.valueOf(percent);
    }

    public int getBottomMargin() {
        return this.myParameters.getBottomMarginPercent() * this.myHeightPixels / 100;
    }

    public int getPauseCorrectionPixels() {
        return this.myParameters.getPauseCorrectionPixels();
    }

    public List<Pause> getPauses() {
        return this.myPauses;
    }

    public int getZeroXPixels() {
        return this.myLeftBound;
    }

    public int getMaxXPixels() {
        return this.myRightBound;
    }

    private int getPixels(float x) {
        return this.myLeftBound + (int)((x - this.myXStart) / this.myOnePoint);
    }

    public Pair<Integer, Integer> getSelectedInterval(int x1, int x2) {
        int end;
        int start;
        if (x1 > x2) {
            start = x2;
            end = x1;
        } else {
            start = x1;
            end = x2;
        }
        int startValue = (int)(this.myXStart + (float)(start - this.myLeftBound) * this.myOnePoint);
        int endValue = (int)(this.myXStart + (float)(end - this.myLeftBound) * this.myOnePoint);
        startValue = this.roundStart(startValue);
        endValue = this.roundEnd(endValue);
        return new Pair((Object)startValue, (Object)endValue);
    }

    public Pair<Integer, Integer> roundPoint(int point) {
        return Pair.create((Object)this.roundStart(point), (Object)this.roundEnd(point));
    }

    private int roundEnd(int endValue) {
        int roundEnd = endValue / 10 * 10;
        if (roundEnd != endValue) {
            endValue = roundEnd + 10;
            endValue = Math.min(endValue, (int)Math.ceil(this.myXEnd));
        }
        return endValue;
    }

    private int roundStart(int startValue) {
        int roundStart = startValue / 10 * 10;
        if (roundStart != startValue) {
            startValue = roundStart - 10;
            startValue = Math.max(startValue, (int)Math.floor(this.myXStart));
        }
        return startValue;
    }

    public static class LabelCorrector
    implements ChartCorrector {
        private static final String[] EXPECTED_PAUSE = new String[]{"set", "label", "*ms", "ms\"", "at", "*"};
        private final List<Pause> myPauses;
        private final PlotSizeParameters myParameters;

        public LabelCorrector(PlotSizeParameters parameters) {
            this.myParameters = parameters;
            this.myPauses = new ArrayList<Pause>();
        }

        @Override
        public boolean chartIsValid() {
            return true;
        }

        @Override
        public boolean processLine(@NotNull String line, @NotNull Consumer<String> changeConsumer, @NotNull Consumer<String[]> insertConsumer) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$LabelCorrector", "processLine"));
            }
            if (changeConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeConsumer", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$LabelCorrector", "processLine"));
            }
            if (insertConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertConsumer", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$LabelCorrector", "processLine"));
            }
            if (!line.contains("set label ")) {
                return true;
            }
            Pause pause = LabelCorrector.parsePause(line);
            if (pause != null) {
                if (this.myParameters.getPauseLabelsFont() > 0) {
                    changeConsumer.consume((Object)LabelCorrector.correctFont(line, this.myParameters.getPauseLabelsFont()));
                }
                this.myPauses.add(pause);
            } else if (this.myParameters.getLabelsFont() > 0) {
                changeConsumer.consume((Object)LabelCorrector.correctFont(line, this.myParameters.getLabelsFont()));
            }
            return true;
        }

        private static String correctFont(@NotNull String line, int font) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$LabelCorrector", "correctFont"));
            }
            int idx = line.indexOf(" font ");
            if (idx > 0) {
                return line.substring(0, idx) + " font \"Helvetica," + font + "'\"";
            }
            return line;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Pause parsePause(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$LabelCorrector", "parsePause"));
            }
            String[] split = line.split(" ");
            int idx = 0;
            int ms = -1;
            Float x = null;
            for (String s : split) {
                if (StringUtil.isEmptyOrSpaces((String)s)) continue;
                if (EXPECTED_PAUSE[idx].startsWith("*")) {
                    if ("*ms".equals(EXPECTED_PAUSE[idx])) {
                        if (!s.startsWith("\"")) {
                            return null;
                        }
                        try {
                            ms = Integer.parseInt(s.substring(1));
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    } else {
                        String[] nums = s.split(",");
                        if (nums.length != 2) {
                            return null;
                        }
                        try {
                            x = Float.valueOf(Float.parseFloat(nums[0]));
                            break;
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                    }
                }
                if (!EXPECTED_PAUSE[idx].equals(s)) {
                    return null;
                }
                ++idx;
            }
            if (x != null && ms != -1) {
                return new Pause(x.floatValue(), ms);
            }
            return null;
        }

        public List<Pause> getPauses() {
            return this.myPauses;
        }
    }

    private static class XRangeCorrector
    implements ChartCorrector {
        private final PlotSizeParameters myParameters;
        private float myXStart = -1.0f;
        private float myXEnd = -1.0f;

        private XRangeCorrector(PlotSizeParameters parameters) {
            this.myParameters = parameters;
        }

        @Override
        public boolean chartIsValid() {
            return this.myXStart != -1.0f;
        }

        @Override
        public boolean processLine(@NotNull String line, @NotNull Consumer<String> changeConsumer, @NotNull Consumer<String[]> insertConsumer) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$XRangeCorrector", "processLine"));
            }
            if (changeConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeConsumer", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$XRangeCorrector", "processLine"));
            }
            if (insertConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertConsumer", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$XRangeCorrector", "processLine"));
            }
            if (!line.contains("set xrange ")) {
                return true;
            }
            this.parseXRange(line);
            if (this.myXStart > 0.0f) {
                insertConsumer.consume((Object)new String[]{"set bmargin at screen 0." + PlotParameters.percentToString(this.myParameters.getBottomMarginPercent()), "set lmargin at screen 0." + PlotParameters.percentToString(this.myParameters.getLeftMarginPercent()), "set rmargin at screen 0." + PlotParameters.percentToString(this.myParameters.getRightMarginPercent())});
            }
            return false;
        }

        private void parseXRange(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$XRangeCorrector", "parseXRange"));
            }
            int i1 = line.indexOf(91);
            if (i1 == -1) {
                return;
            }
            int i2 = line.indexOf(58, i1 + 1);
            if (i2 == -1) {
                return;
            }
            int i3 = line.indexOf(93, i2 + 1);
            if (i3 == -1) {
                return;
            }
            try {
                this.myXStart = Float.parseFloat(line.substring(i1 + 1, i2));
                this.myXEnd = Float.parseFloat(line.substring(i2 + 1, i3));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public float getXStart() {
            return this.myXStart;
        }

        public float getXEnd() {
            return this.myXEnd;
        }
    }

    private static class ImageSizeCorrector
    implements ChartCorrector {
        private final boolean myForce;
        private final PlotSizeParameters myParameters;
        private int myWidthPixels = -1;
        private int myHeightPixels = -1;

        private ImageSizeCorrector(boolean force, PlotSizeParameters parameters) {
            this.myForce = force;
            this.myParameters = parameters;
        }

        @Override
        public boolean chartIsValid() {
            return this.myWidthPixels != -1;
        }

        @Override
        public boolean processLine(@NotNull String line, @NotNull Consumer<String> changeConsumer, @NotNull Consumer<String[]> insertConsumer) {
            Pair<Integer, Integer> pair;
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$ImageSizeCorrector", "processLine"));
            }
            if (changeConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeConsumer", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$ImageSizeCorrector", "processLine"));
            }
            if (insertConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "insertConsumer", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$ImageSizeCorrector", "processLine"));
            }
            if (!line.contains("set terminal ")) {
                return true;
            }
            if (this.myForce || (pair = ImageSizeCorrector.parseTerminal(line)) == null) {
                this.myWidthPixels = this.myParameters.getWidth();
                this.myHeightPixels = this.myParameters.getHeight();
                changeConsumer.consume((Object)("set terminal pngcairo size " + this.myWidthPixels + "," + this.myHeightPixels + " enhanced font 'Helvetica," + this.myParameters.getFontSize() + "'"));
            } else {
                this.myWidthPixels = (Integer)pair.getFirst();
                this.myHeightPixels = (Integer)pair.getSecond();
            }
            return false;
        }

        private static Pair<Integer, Integer> parseTerminal(@NotNull String line) {
            int idx;
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/jetbrains/nodejs/run/profile/cpu/calculation/PlotParameters$ImageSizeCorrector", "parseTerminal"));
            }
            int idxSize = line.indexOf(PlotParameters.SIZE);
            if (idxSize == -1) {
                return null;
            }
            for (idx = idxSize + PlotParameters.SIZE.length(); idx < line.length() && line.charAt(idx) == ' '; ++idx) {
            }
            int spaceIdx = line.indexOf(32, idx);
            if (spaceIdx == -1) {
                return null;
            }
            String size = line.substring(idxSize + PlotParameters.SIZE.length(), spaceIdx);
            String[] split = size.split(",");
            if (split.length != 2) {
                return null;
            }
            try {
                return Pair.create((Object)Integer.parseInt(split[0]), (Object)Integer.parseInt(split[1]));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public int getWidthPixels() {
            return this.myWidthPixels;
        }

        public int getHeightPixels() {
            return this.myHeightPixels;
        }
    }

    private static interface ChartCorrector {
        public boolean chartIsValid();

        public boolean processLine(@NotNull String var1, @NotNull Consumer<String> var2, @NotNull Consumer<String[]> var3);
    }
}

