/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.calculation;

import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.cpu.calculation.Chain;
import com.jetbrains.nodejs.run.profile.cpu.calculation.ChainProcessor;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class V8CpuRecursionFolder {
    private final V8ProfileLine myRoot;
    private V8ProfileLine myFiltered;
    private boolean myWasFiltered;

    public V8CpuRecursionFolder(V8ProfileLine root) {
        this.myRoot = root;
    }

    public void execute() {
        ArrayList chains = new ArrayList();
        this.findSingleThreadedFragments(chains);
        ChainProcessor processor = new ChainProcessor(chains);
        processor.process();
        List rollUp = processor.getRollUp();
    }

    private void findSingleThreadedFragments(final @NotNull List<Chain<V8ProfileLine>> chains) {
        if (chains == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chains", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8CpuRecursionFolder", "findSingleThreadedFragments"));
        }
        V8ProfileLine.dfs(this.myRoot, new Consumer<V8ProfileLine>(){
            private V8ProfileLine myStart;
            private V8ProfileLine myPrevious;
            private List<Long> mySequence;

            public void consume(V8ProfileLine line) {
                boolean singleThreadDown;
                boolean isChildOfPrevious;
                boolean bl = isChildOfPrevious = line.getParent() != null && line.getParent().equals(this.myPrevious);
                if (isChildOfPrevious) {
                    if (this.myStart != null) {
                        this.mySequence.add(line.getCall().getStringId());
                    }
                    this.myPrevious = line;
                }
                boolean bl2 = singleThreadDown = line.getChildren().size() == 1;
                if (this.myStart == null && singleThreadDown) {
                    this.myStart = line;
                    this.mySequence.add(line.getCall().getStringId());
                    this.myPrevious = line;
                }
                if (!(this.myStart == null || singleThreadDown && isChildOfPrevious)) {
                    chains.add(new Chain<V8ProfileLine>(this.myStart, new ArrayList<Long>(this.mySequence)));
                    this.mySequence.clear();
                    this.myStart = null;
                    this.myPrevious = null;
                }
            }
        });
    }
}

