/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.calculation;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.webcore.util.CommandLineUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8LogTransformer {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.cpu.calculation.V8LogTransformer");
    @NotNull
    private final String myNodePath;
    @NotNull
    private final String myTickPath;
    @NotNull
    private final File myLogFile;
    private String myErrorText;
    private MyOutputReader myReader;
    private final boolean myCreateTimeLine;
    private int myZoomStartX;
    private int myZoomEndX;

    private V8LogTransformer(@NotNull File logFile, @NotNull String nodePath, @NotNull String tickPath, boolean createTimeline) {
        if (logFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logFile", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8LogTransformer", "<init>"));
        }
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8LogTransformer", "<init>"));
        }
        if (tickPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tickPath", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8LogTransformer", "<init>"));
        }
        this.myZoomStartX = -1;
        this.myZoomEndX = -1;
        this.myLogFile = logFile;
        this.myNodePath = nodePath;
        this.myTickPath = tickPath;
        this.myCreateTimeLine = createTimeline;
    }

    public void setZoomStartX(int zoomStartX) {
        this.myZoomStartX = zoomStartX;
    }

    public void setZoomEndX(int zoomEndX) {
        this.myZoomEndX = zoomEndX;
    }

    public static V8LogTransformer createCallTreesTransformer(@NotNull File logFile, @NotNull String nodePath, @NotNull String tickPath) {
        if (logFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logFile", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8LogTransformer", "createCallTreesTransformer"));
        }
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8LogTransformer", "createCallTreesTransformer"));
        }
        if (tickPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tickPath", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8LogTransformer", "createCallTreesTransformer"));
        }
        return new V8LogTransformer(logFile, nodePath, tickPath, false);
    }

    public static V8LogTransformer createTimelineTransformer(@NotNull File logFile, @NotNull String nodePath, @NotNull String tickPath) {
        if (logFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logFile", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8LogTransformer", "createTimelineTransformer"));
        }
        if (nodePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodePath", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8LogTransformer", "createTimelineTransformer"));
        }
        if (tickPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tickPath", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8LogTransformer", "createTimelineTransformer"));
        }
        return new V8LogTransformer(logFile, nodePath, tickPath, true);
    }

    public boolean process(@Nullable ProgressIndicator indicator) {
        OSProcessHandler processHandler;
        GeneralCommandLine commandLine = this.createCommandLine();
        try {
            processHandler = new OSProcessHandler(commandLine);
        }
        catch (ExecutionException e) {
            LOG.info("Can not start node.js tick process: " + e.getMessage(), (Throwable)e);
            return this.createError("Can not start node.js tick process: " + e.getMessage());
        }
        this.myReader = new MyOutputReader();
        processHandler.addProcessListener((ProcessListener)this.myReader);
        processHandler.startNotify();
        V8LogTransformer.waitForProcessUnderProgress(processHandler, indicator);
        return true;
    }

    public static void waitForProcessUnderProgress(@NotNull OSProcessHandler processHandler, @Nullable ProgressIndicator indicator) {
        boolean success;
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8LogTransformer", "waitForProcessUnderProgress"));
        }
        while (!(success = processHandler.waitFor(200L))) {
            if (indicator == null) continue;
            indicator.checkCanceled();
        }
    }

    public List<String> getResult() {
        return this.myReader.getOutput();
    }

    private boolean createError(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/nodejs/run/profile/cpu/calculation/V8LogTransformer", "createError"));
        }
        this.myErrorText = text;
        return false;
    }

    public String getErrorText() {
        return V8LogTransformer.combineErrors(this.myErrorText, this.myReader.getError());
    }

    public static String combineErrors(String firstError, String secondError) {
        return V8LogTransformer.combineErrors(firstError, null, secondError, null);
    }

    public static String combineErrors(String firstError, String firstPrefix, String secondError, String secondPrefix) {
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmptyOrSpaces((String)firstError)) {
            if (firstPrefix != null) {
                sb.append(firstPrefix);
            }
            sb.append(firstError);
        }
        if (!StringUtil.isEmptyOrSpaces((String)secondError)) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            if (secondPrefix != null) {
                sb.append(secondPrefix);
            }
            sb.append(secondError);
        }
        return sb.length() == 0 ? null : sb.toString();
    }

    private GeneralCommandLine createCommandLine() {
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        CommandLineUtil.configureShellEnvironment((GeneralCommandLine)commandLine, (boolean)true, Collections.emptyMap());
        commandLine.withWorkDirectory(this.myLogFile.getParentFile());
        commandLine.setExePath(this.myNodePath);
        String pathToScript = FileUtil.toSystemDependentName((String)this.myTickPath);
        pathToScript = pathToScript.endsWith(File.separator) ? pathToScript : pathToScript + File.separator;
        pathToScript = pathToScript + "bin" + File.separator + (this.myCreateTimeLine ? "stdio.js" : "tickprocessor-driver.js");
        commandLine.addParameters(new String[]{pathToScript});
        if (SystemInfo.isMac) {
            commandLine.addParameter("--mac");
            if (!Boolean.TRUE.equals(Boolean.getBoolean("idea.nodejs.profiling.dont.apply.nm.fix"))) {
                commandLine.addParameter("--nm=\"\"");
            }
        } else if (SystemInfo.isWindows) {
            commandLine.addParameter("--windows");
        } else if (SystemInfo.isUnix) {
            commandLine.addParameter("--unix");
        }
        if (this.myZoomStartX > 0 && this.myZoomEndX > 0) {
            commandLine.addParameters(new String[]{"--range=" + this.myZoomStartX + "," + this.myZoomEndX});
        }
        if (this.myCreateTimeLine) {
            commandLine.addParameters(new String[]{"--distortion=4500"});
        }
        commandLine.addParameters(new String[]{this.myLogFile.getAbsolutePath()});
        return commandLine;
    }

    private static class MyOutputReader
    extends ProcessAdapter {
        private final StringBuilder myErr;
        private final List<String> myOut = new ArrayList<String>();

        private MyOutputReader() {
            this.myErr = new StringBuilder();
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            String text = event.getText().trim();
            if (outputType == ProcessOutputTypes.STDERR) {
                if (this.myErr.length() > 0) {
                    this.myErr.append("\n");
                }
                this.myErr.append(text);
            } else if (outputType == ProcessOutputTypes.STDOUT) {
                this.myOut.add(text);
            }
        }

        public String getError() {
            return this.myErr.toString();
        }

        public List<String> getOutput() {
            return this.myOut;
        }
    }
}

