/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8RawLogProcessor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8CpuViewCreatorPartner;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameChartParameters;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingMainComponent;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import icons.NodeJSIcons;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ReadV8LogRawAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.cpu.ReadV8LogAction");
    public static final String TOOL_WINDOW_TITLE = "V8 CPU Profiling";

    public ReadV8LogRawAction() {
        super("Analyze V8 Profiling Log...", "Read V8 profiling log file, show CPU profiling results.", NodeJSIcons.OpenV8ProfilingLog);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/nodejs/run/profile/cpu/v8log/ReadV8LogRawAction", "actionPerformed"));
        }
        DataContext dc = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dc);
        if (project == null) {
            return;
        }
        VirtualFile vf = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleLocalFileDescriptor(), (Project)project, null);
        if (vf != null) {
            UsageTrigger.trigger((String)"node.js.v8.profiling.read.log");
            File file = new File(vf.getPath());
            ReadV8LogRawAction.openFile(project, file);
        }
    }

    public static void openFile(final Project project, final File file) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Process V8 log...", true){
            private CompositeCloseable myResources;
            private V8LogCachingReader myReader;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/cpu/v8log/ReadV8LogRawAction$1", "run"));
                }
                Consumer<String> notificator = ReadV8LogRawAction.createNotificator(this.myProject);
                try {
                    V8RawLogProcessor processor = new V8RawLogProcessor(project, file, notificator);
                    processor.run(indicator);
                    this.myResources = processor.getResources();
                    this.myReader = processor.getReader();
                }
                catch (IOException e) {
                    notificator.consume((Object)e.getMessage());
                    indicator.cancel();
                }
            }

            public void onSuccess() {
                if (this.myReader != null) {
                    String description = file.getName();
                    V8CpuViewCreatorPartner partner = new V8CpuViewCreatorPartner(this.myProject, this.myResources, this.myReader, ReadV8LogRawAction.createNotificator(this.myProject), description, null, null, new FlameChartParameters());
                    V8ProfilingMainComponent.showMe(project, description, ReadV8LogRawAction.TOOL_WINDOW_TITLE, NodeJSIcons.OpenV8ProfilingLog_ToolWin, 1, partner, null, description, null);
                }
            }
        });
    }

    @NotNull
    public static Consumer<String> createNotificator(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/cpu/v8log/ReadV8LogRawAction", "createNotificator"));
        }
        Consumer consumer = s -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/cpu/v8log/ReadV8LogRawAction", "lambda$createNotificator$0"));
            }
            NodeProfilingSettings.CPU_NOTIFICATION_GROUP.createNotification("V8 CPU log processing problem: " + s, NotificationType.ERROR).notify(project);
        };
        if (consumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/run/profile/cpu/v8log/ReadV8LogRawAction", "createNotificator"));
        }
        return consumer;
    }
}

