/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.Counter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CallTree {
    private final CallTreeNode myRoot = new CallTreeNode(-1L);

    public CallTreeNode getRoot() {
        return this.myRoot;
    }

    public void addPath(@NotNull List<Long> strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/CallTree", "addPath"));
        }
        if (strings.isEmpty()) {
            return;
        }
        CallTreeNode current = this.myRoot;
        for (Long path : strings) {
            current = current.findOrAddChild(path);
        }
        current.getSelfWeight().incrementAndGet();
    }

    public void computeTotalWeight() {
        CallTreeNode node;
        ArrayDeque<CallTreeNode> in = new ArrayDeque<CallTreeNode>();
        ArrayDeque<CallTreeNode> out = new ArrayDeque<CallTreeNode>();
        in.add(this.myRoot);
        while (!in.isEmpty()) {
            node = (CallTreeNode)in.removeFirst();
            out.add(node);
            Collection<CallTreeNode> children = node.getChildren().values();
            in.addAll(children);
        }
        while (!out.isEmpty()) {
            node = (CallTreeNode)out.removeLast();
            node.computeTotalWeight();
        }
    }

    public static class CallTreeNode {
        private final Long myName;
        private final Counter mySelfWeight;
        private Counter myTotalWeight;
        private final Map<Long, CallTreeNode> myChildren;

        public CallTreeNode(Long name) {
            this.myName = name;
            this.mySelfWeight = new Counter();
            this.myTotalWeight = new Counter();
            this.myChildren = new HashMap();
        }

        public CallTreeNode findOrAddChild(@NotNull Long name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/CallTree$CallTreeNode", "findOrAddChild"));
            }
            CallTreeNode node = this.myChildren.get(name);
            if (node != null) {
                return node;
            }
            node = new CallTreeNode(name);
            this.myChildren.put(name, node);
            return node;
        }

        public void computeTotalWeight() {
            this.myTotalWeight.add(this.mySelfWeight.getCnt());
            for (CallTreeNode node : this.myChildren.values()) {
                this.myTotalWeight.add(node.getTotalWeight().getCnt());
            }
        }

        public Long getName() {
            return this.myName;
        }

        public Counter getSelfWeight() {
            return this.mySelfWeight;
        }

        public Counter getTotalWeight() {
            return this.myTotalWeight;
        }

        public Map<Long, CallTreeNode> getChildren() {
            return this.myChildren;
        }
    }
}

