/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.util.ThrowableConsumer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8LineReader {
    private final byte[] myBuf = new byte[20000];
    private final InputStream myInputStream;
    private boolean myAtEnd = false;
    private final ReadLine myLine;

    public V8LineReader(InputStream in) {
        this.myInputStream = in;
        this.myLine = new ReadLine();
    }

    public void readLines(@NotNull ThrowableConsumer<String, IOException> consumer, Charset charset) throws IOException {
        int size;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8LineReader", "readLines"));
        }
        while (!this.myAtEnd && (size = this.myInputStream.read(this.myBuf)) >= 0) {
            String str = new String(this.myBuf, 0, size, charset);
            String[] lines = str.replace('\r', '\n').split("\n");
            for (int i = 0; i < lines.length - 1; ++i) {
                consumer.consume((Object)lines[i]);
            }
            String last = lines[lines.length - 1];
            if (last.length() == 0) continue;
            this.myLine.reset();
            this.myLine.myResult.write(last.getBytes(charset));
            byte[] bytes = this.myLine.execute();
            if (bytes == null) {
                consumer.consume((Object)last);
                continue;
            }
            consumer.consume((Object)new String(bytes, charset));
        }
    }

    public byte[] readLine() throws IOException {
        this.myLine.reset();
        return this.myLine.execute();
    }

    private boolean isNewline(int ch) {
        return ch == 13 || ch == 10;
    }

    private class ReadLine {
        private final ByteArrayOutputStream myResult = new ByteArrayOutputStream(1000);

        private ReadLine() {
        }

        public void reset() {
            this.myResult.reset();
        }

        @Nullable
        public byte[] execute() throws IOException {
            if (V8LineReader.this.myAtEnd) {
                return null;
            }
            boolean atStart = true;
            int ch;
            while ((ch = V8LineReader.this.myInputStream.read()) >= 0) {
                if (V8LineReader.this.isNewline(ch)) {
                    if (atStart) continue;
                    return this.getResult();
                }
                atStart = false;
                this.myResult.write(ch);
            }
            return this.processEndOfStream();
        }

        private byte[] getResult() {
            try {
                this.myResult.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this.myResult.toByteArray();
        }

        private byte[] processEndOfStream() {
            V8LineReader.this.myAtEnd = true;
            return this.getResult();
        }
    }
}

