/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8CachingLogProcessor;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class V8RawLogProcessor {
    @NotNull
    private final Project myProject;
    private File myV8log;
    private final Consumer<String> myNotificator;
    private CompositeCloseable myResources;
    private V8LogCachingReader myReader;
    private V8CachingLogProcessor myCachingLogProcessor;

    public V8RawLogProcessor(@NotNull Project project, @NotNull File v8log, @NotNull Consumer<String> notificator) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8RawLogProcessor", "<init>"));
        }
        if (v8log == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v8log", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8RawLogProcessor", "<init>"));
        }
        if (notificator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificator", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8RawLogProcessor", "<init>"));
        }
        this.myProject = project;
        this.myV8log = v8log;
        this.myNotificator = notificator;
        this.myResources = new CompositeCloseable();
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8RawLogProcessor", "run"));
        }
        try {
            this.myCachingLogProcessor = new V8CachingLogProcessor(this.myProject, this.myResources, this.myV8log, 0L);
            this.myReader = this.myCachingLogProcessor.getFromCacheOrProcess(indicator);
        }
        catch (IOException e) {
            this.myNotificator.consume((Object)e.getMessage());
            return;
        }
    }

    public V8LogCachingReader getReader() {
        return this.myReader;
    }

    public CompositeCloseable getResources() {
        return this.myResources;
    }
}

