/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.data;

import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LogIndexesWriter;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8EventType;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class EventsStripeData {
    private final TreeMap<Long, V8LogIndexesWriter.TimerEvent> myExecution = new TreeMap();
    private final TreeMap<Long, V8LogIndexesWriter.TimerEvent> myExternal = new TreeMap();
    private final TreeMap<Long, V8LogIndexesWriter.TimerEvent> myEngine = new TreeMap();
    private final TreeMap<Long, V8LogIndexesWriter.TimerEvent> myGc = new TreeMap();

    public void addEvent(@NotNull V8LogIndexesWriter.TimerEvent timerEvent) {
        if (timerEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timerEvent", "com/jetbrains/nodejs/run/profile/cpu/v8log/data/EventsStripeData", "addEvent"));
        }
        V8EventType type = timerEvent.getEventType();
        if (V8EventType.Execute.equals((Object)type)) {
            this.myExecution.put(timerEvent.getStartNanos(), timerEvent);
        } else if (V8EventType.External.equals((Object)type)) {
            this.myExternal.put(timerEvent.getStartNanos(), timerEvent);
        } else if (type.isEngine()) {
            this.myEngine.put(timerEvent.getStartNanos(), timerEvent);
        } else if (type.isGc()) {
            this.myGc.put(timerEvent.getStartNanos(), timerEvent);
        }
    }

    public TreeMap<Long, V8LogIndexesWriter.TimerEvent> getExecution() {
        return this.myExecution;
    }

    public TreeMap<Long, V8LogIndexesWriter.TimerEvent> getExternal() {
        return this.myExternal;
    }

    public TreeMap<Long, V8LogIndexesWriter.TimerEvent> getEngine() {
        return this.myEngine;
    }

    public TreeMap<Long, V8LogIndexesWriter.TimerEvent> getGc() {
        return this.myGc;
    }

    public List<TreeMap<Long, V8LogIndexesWriter.TimerEvent>> getOrdered() {
        ArrayList<TreeMap<Long, V8LogIndexesWriter.TimerEvent>> list = new ArrayList<TreeMap<Long, V8LogIndexesWriter.TimerEvent>>();
        list.add(this.myGc);
        list.add(this.myEngine);
        list.add(this.myExternal);
        list.add(this.myExecution);
        return list;
    }
}

