/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.data;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.nodejs.run.profile.cpu.calculation.CallTreesSerializer;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.heap.io.RawSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FlatTopCalls {
    @NonNls
    public static final String JAVA_SCRIPT_GROUP = "JavaScript";
    private final List<V8ProfileLine> myUnknown;
    private final List<V8ProfileLine> mySharedLibraries;
    private final List<V8ProfileLine> myJavaScript;
    private final List<V8ProfileLine> myCpp;
    private final List<V8ProfileLine> myGc;

    public FlatTopCalls() {
        this.myUnknown = new ArrayList<V8ProfileLine>();
        this.mySharedLibraries = new ArrayList<V8ProfileLine>();
        this.myJavaScript = new ArrayList<V8ProfileLine>();
        this.myCpp = new ArrayList<V8ProfileLine>();
        this.myGc = new ArrayList<V8ProfileLine>();
    }

    public FlatTopCalls cloneMe() {
        return new FlatTopCalls(this.myUnknown, this.mySharedLibraries, this.myJavaScript, this.myCpp, this.myGc);
    }

    private FlatTopCalls(List<V8ProfileLine> unknown, List<V8ProfileLine> sharedLibraries, List<V8ProfileLine> javaScript, List<V8ProfileLine> cpp, List<V8ProfileLine> gc) {
        this.myUnknown = unknown;
        this.mySharedLibraries = sharedLibraries;
        this.myJavaScript = javaScript;
        this.myCpp = cpp;
        this.myGc = gc;
    }

    public List<Pair<String, List<V8ProfileLine>>> createPresentation() {
        ArrayList<Pair<String, List<V8ProfileLine>>> list = new ArrayList<Pair<String, List<V8ProfileLine>>>();
        this.addList(list, this.myUnknown, "Unknown");
        this.addList(list, this.myGc, "GC");
        this.addList(list, this.mySharedLibraries, "Shared Libraries");
        this.addList(list, this.myJavaScript, JAVA_SCRIPT_GROUP);
        this.addList(list, this.myCpp, "C++");
        return list;
    }

    private void addList(List<Pair<String, List<V8ProfileLine>>> list, List<V8ProfileLine> subList, String name) {
        if (!subList.isEmpty()) {
            V8ProfileLine line;
            if (subList.size() == 1 && StringUtil.isEmptyOrSpaces((String)(line = subList.get(0)).toString())) {
                line.setPresentation("<total>");
                line.setIsInternal(true);
            }
            list.add((Pair<String, List<V8ProfileLine>>)Pair.create((Object)name, subList));
        }
    }

    public List<V8ProfileLine> getUnknown() {
        return this.myUnknown;
    }

    public List<V8ProfileLine> getSharedLibraries() {
        return this.mySharedLibraries;
    }

    public List<V8ProfileLine> getJavaScript() {
        return this.myJavaScript;
    }

    public List<V8ProfileLine> getCpp() {
        return this.myCpp;
    }

    public List<V8ProfileLine> getGc() {
        return this.myGc;
    }

    public static class MySerializer
    implements RawSerializer<FlatTopCalls> {
        @Override
        public long getRecordSize() {
            return -1L;
        }

        @Override
        public void write(@NotNull DataOutput os, @NotNull FlatTopCalls calls) throws IOException {
            if (os == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "os", "com/jetbrains/nodejs/run/profile/cpu/v8log/data/FlatTopCalls$MySerializer", "write"));
            }
            if (calls == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calls", "com/jetbrains/nodejs/run/profile/cpu/v8log/data/FlatTopCalls$MySerializer", "write"));
            }
            this.writeList(os, calls.myUnknown);
            this.writeList(os, calls.mySharedLibraries);
            this.writeList(os, calls.myJavaScript);
            this.writeList(os, calls.myCpp);
            this.writeList(os, calls.myGc);
        }

        private void writeList(@NotNull DataOutput os, @NotNull List<V8ProfileLine> list) throws IOException {
            if (os == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "os", "com/jetbrains/nodejs/run/profile/cpu/v8log/data/FlatTopCalls$MySerializer", "writeList"));
            }
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/nodejs/run/profile/cpu/v8log/data/FlatTopCalls$MySerializer", "writeList"));
            }
            os.writeInt(list.size());
            for (V8ProfileLine line : list) {
                CallTreesSerializer.writeLine(os, line);
            }
        }

        private void readList(@NotNull DataInput is, List<V8ProfileLine> list) throws IOException {
            if (is == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "is", "com/jetbrains/nodejs/run/profile/cpu/v8log/data/FlatTopCalls$MySerializer", "readList"));
            }
            int size = is.readInt();
            for (int i = 0; i < size; ++i) {
                list.add(CallTreesSerializer.readLine(is, null));
            }
        }

        @Override
        public FlatTopCalls read(@NotNull DataInput is) throws IOException {
            if (is == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "is", "com/jetbrains/nodejs/run/profile/cpu/v8log/data/FlatTopCalls$MySerializer", "read"));
            }
            FlatTopCalls calls = new FlatTopCalls();
            this.readList(is, calls.myUnknown);
            this.readList(is, calls.mySharedLibraries);
            this.readList(is, calls.myJavaScript);
            this.readList(is, calls.myCpp);
            this.readList(is, calls.myGc);
            return calls;
        }
    }
}

